// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.payroll.v1.model;
import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.payroll.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;
public class CollectionItem {
     /**
      * 填报模板ID
      * <p> 示例值：7202076988667019308
      */
    @SerializedName("template_id")
    private String templateId;
     /**
      * 填报模板版本ID
      * <p> 示例值：7202076988667019308
      */
    @SerializedName("template_version_id")
    private String templateVersionId;
     /**
      * 填报项ID
      * <p> 示例值：7202076988667019308
      */
    @SerializedName("item_id")
    private String itemId;
     /**
      * 填报项名称
      * <p> 示例值：
      */
    @SerializedName("item_name")
    private I18n itemName;
     /**
      * 填报项类型，1-文本，2-金额，3-数值，4-百分比，5-日期，6-日期范围
      * <p> 示例值：1
      */
    @SerializedName("field_type")
    private Integer fieldType;
     /**
      * 小数位数
      * <p> 示例值：1
      */
    @SerializedName("decimal_places")
    private Integer decimalPlaces;
     /**
      * 计算方式，1-加和，2-最新值
      * <p> 示例值：1
      */
    @SerializedName("calc_method")
    private Integer calcMethod;
     /**
      * 是否预置填报项
      * <p> 示例值：true
      */
    @SerializedName("preset")
    private Boolean preset;
     /**
      * 是否必填
      * <p> 示例值：true
      */
    @SerializedName("is_required")
    private Boolean isRequired;
    public String getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    public String getTemplateVersionId() {
        return this.templateVersionId;
    }

    public void setTemplateVersionId(String templateVersionId) {
        this.templateVersionId = templateVersionId;
    }

    public String getItemId() {
        return this.itemId;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public I18n getItemName() {
        return this.itemName;
    }

    public void setItemName(I18n itemName) {
        this.itemName = itemName;
    }

    public Integer getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(Integer fieldType) {
        this.fieldType = fieldType;
    }

    public Integer getDecimalPlaces() {
        return this.decimalPlaces;
    }

    public void setDecimalPlaces(Integer decimalPlaces) {
        this.decimalPlaces = decimalPlaces;
    }

    public Integer getCalcMethod() {
        return this.calcMethod;
    }

    public void setCalcMethod(Integer calcMethod) {
        this.calcMethod = calcMethod;
    }

    public Boolean getPreset() {
        return this.preset;
    }

    public void setPreset(Boolean preset) {
        this.preset = preset;
    }

    public Boolean getIsRequired() {
        return this.isRequired;
    }

    public void setIsRequired(Boolean isRequired) {
        this.isRequired = isRequired;
    }


// builder 开始
  public CollectionItem(){}

  public CollectionItem(Builder builder){
         /**
          * 填报模板ID
          * <p> 示例值：7202076988667019308
          */
      this.templateId = builder.templateId;
         /**
          * 填报模板版本ID
          * <p> 示例值：7202076988667019308
          */
      this.templateVersionId = builder.templateVersionId;
         /**
          * 填报项ID
          * <p> 示例值：7202076988667019308
          */
      this.itemId = builder.itemId;
         /**
          * 填报项名称
          * <p> 示例值：
          */
      this.itemName = builder.itemName;
         /**
          * 填报项类型，1-文本，2-金额，3-数值，4-百分比，5-日期，6-日期范围
          * <p> 示例值：1
          */
      this.fieldType = builder.fieldType;
         /**
          * 小数位数
          * <p> 示例值：1
          */
      this.decimalPlaces = builder.decimalPlaces;
         /**
          * 计算方式，1-加和，2-最新值
          * <p> 示例值：1
          */
      this.calcMethod = builder.calcMethod;
         /**
          * 是否预置填报项
          * <p> 示例值：true
          */
      this.preset = builder.preset;
         /**
          * 是否必填
          * <p> 示例值：true
          */
      this.isRequired = builder.isRequired;
  }

    public static class Builder {
     /**
      * 填报模板ID
      * <p> 示例值：7202076988667019308
      */
        private String templateId;
     /**
      * 填报模板版本ID
      * <p> 示例值：7202076988667019308
      */
        private String templateVersionId;
     /**
      * 填报项ID
      * <p> 示例值：7202076988667019308
      */
        private String itemId;
     /**
      * 填报项名称
      * <p> 示例值：
      */
        private I18n itemName;
     /**
      * 填报项类型，1-文本，2-金额，3-数值，4-百分比，5-日期，6-日期范围
      * <p> 示例值：1
      */
        private Integer fieldType;
     /**
      * 小数位数
      * <p> 示例值：1
      */
        private Integer decimalPlaces;
     /**
      * 计算方式，1-加和，2-最新值
      * <p> 示例值：1
      */
        private Integer calcMethod;
     /**
      * 是否预置填报项
      * <p> 示例值：true
      */
        private Boolean preset;
     /**
      * 是否必填
      * <p> 示例值：true
      */
        private Boolean isRequired;

        /**
         * 填报模板ID
         * <p> 示例值：7202076988667019308
         * @param templateId
         * @return
         */
        public Builder templateId(String templateId) {
             this.templateId = templateId;
             return this;
        }

    

        /**
         * 填报模板版本ID
         * <p> 示例值：7202076988667019308
         * @param templateVersionId
         * @return
         */
        public Builder templateVersionId(String templateVersionId) {
             this.templateVersionId = templateVersionId;
             return this;
        }

    

        /**
         * 填报项ID
         * <p> 示例值：7202076988667019308
         * @param itemId
         * @return
         */
        public Builder itemId(String itemId) {
             this.itemId = itemId;
             return this;
        }

    

        /**
         * 填报项名称
         * <p> 示例值：
         * @param itemName
         * @return
         */
        public Builder itemName(I18n itemName) {
             this.itemName = itemName;
             return this;
        }

    

        /**
         * 填报项类型，1-文本，2-金额，3-数值，4-百分比，5-日期，6-日期范围
         * <p> 示例值：1
         * @param fieldType
         * @return
         */
        public Builder fieldType(Integer fieldType) {
             this.fieldType = fieldType;
             return this;
        }

    

        /**
         * 小数位数
         * <p> 示例值：1
         * @param decimalPlaces
         * @return
         */
        public Builder decimalPlaces(Integer decimalPlaces) {
             this.decimalPlaces = decimalPlaces;
             return this;
        }

    

        /**
         * 计算方式，1-加和，2-最新值
         * <p> 示例值：1
         * @param calcMethod
         * @return
         */
        public Builder calcMethod(Integer calcMethod) {
             this.calcMethod = calcMethod;
             return this;
        }

    

        /**
         * 是否预置填报项
         * <p> 示例值：true
         * @param preset
         * @return
         */
        public Builder preset(Boolean preset) {
             this.preset = preset;
             return this;
        }

    

        /**
         * 是否必填
         * <p> 示例值：true
         * @param isRequired
         * @return
         */
        public Builder isRequired(Boolean isRequired) {
             this.isRequired = isRequired;
             return this;
        }

    
    
    public CollectionItem build(){
        return new CollectionItem(this);
      }
    }

    public static Builder newBuilder() {
        return new Builder();
    }
}
