// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.payroll.v1.model;
import com.google.gson.annotations.SerializedName;

public class PayGroup {
     /**
      * 薪资组ID
      * <p> 示例值：6823630319749580301
      */
    @SerializedName("pay_group_id")
    private String payGroupId;
     /**
      * 薪资组名称
      * <p> 示例值：CHN - 审核
      */
    @SerializedName("name")
    private I18n name;
     /**
      * 薪资组编码
      * <p> 示例值：PAY_GROUP-3-8
      */
    @SerializedName("code")
    private String code;
     /**
      * 薪资组状态
      * <p> 示例值：1
      */
    @SerializedName("status")
    private Integer status;
     /**
      * 薪资组所属国家/地区
      * <p> 示例值：
      */
    @SerializedName("country_region")
    private CountryRegion countryRegion;
    public String getPayGroupId() {
        return this.payGroupId;
    }

    public void setPayGroupId(String payGroupId) {
        this.payGroupId = payGroupId;
    }

    public I18n getName() {
        return this.name;
    }

    public void setName(I18n name) {
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public CountryRegion getCountryRegion() {
        return this.countryRegion;
    }

    public void setCountryRegion(CountryRegion countryRegion) {
        this.countryRegion = countryRegion;
    }


// builder 开始
  public PayGroup(){}

  public PayGroup(Builder builder){
         /**
          * 薪资组ID
          * <p> 示例值：6823630319749580301
          */
      this.payGroupId = builder.payGroupId;
         /**
          * 薪资组名称
          * <p> 示例值：CHN - 审核
          */
      this.name = builder.name;
         /**
          * 薪资组编码
          * <p> 示例值：PAY_GROUP-3-8
          */
      this.code = builder.code;
         /**
          * 薪资组状态
          * <p> 示例值：1
          */
      this.status = builder.status;
         /**
          * 薪资组所属国家/地区
          * <p> 示例值：
          */
      this.countryRegion = builder.countryRegion;
  }

    public static class Builder {
     /**
      * 薪资组ID
      * <p> 示例值：6823630319749580301
      */
        private String payGroupId;
     /**
      * 薪资组名称
      * <p> 示例值：CHN - 审核
      */
        private I18n name;
     /**
      * 薪资组编码
      * <p> 示例值：PAY_GROUP-3-8
      */
        private String code;
     /**
      * 薪资组状态
      * <p> 示例值：1
      */
        private Integer status;
     /**
      * 薪资组所属国家/地区
      * <p> 示例值：
      */
        private CountryRegion countryRegion;

        /**
         * 薪资组ID
         * <p> 示例值：6823630319749580301
         * @param payGroupId
         * @return
         */
        public Builder payGroupId(String payGroupId) {
             this.payGroupId = payGroupId;
             return this;
        }

    

        /**
         * 薪资组名称
         * <p> 示例值：CHN - 审核
         * @param name
         * @return
         */
        public Builder name(I18n name) {
             this.name = name;
             return this;
        }

    

        /**
         * 薪资组编码
         * <p> 示例值：PAY_GROUP-3-8
         * @param code
         * @return
         */
        public Builder code(String code) {
             this.code = code;
             return this;
        }

    

        /**
         * 薪资组状态
         * <p> 示例值：1
         * @param status
         * @return
         */
        public Builder status(Integer status) {
             this.status = status;
             return this;
        }
        /**
         * 薪资组状态
         * <p> 示例值：1
         * @param status {@link com.lark.oapi.service.payroll.v1.enums.PaygroupStatusEnum}
         * @return
         */
        public Builder status(com.lark.oapi.service.payroll.v1.enums.PaygroupStatusEnum status) {
             this.status = status.getValue();
             return this;
        }

    

        /**
         * 薪资组所属国家/地区
         * <p> 示例值：
         * @param countryRegion
         * @return
         */
        public Builder countryRegion(CountryRegion countryRegion) {
             this.countryRegion = countryRegion;
             return this;
        }

    
    
    public PayGroup build(){
        return new PayGroup(this);
      }
    }

    public static Builder newBuilder() {
        return new Builder();
    }
}
