// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.performance.v2.model;
import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.performance.v2.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;
public class ReviewTemplate {
     /**
      * 环节模板列表
      * <p> 示例值：
      */
    @SerializedName("templates")
    private Template[] templates;
     /**
      * 评估内容列表
      * <p> 示例值：
      */
    @SerializedName("units")
    private Unit[] units;
     /**
      * 评估模板 ID
      * <p> 示例值：7343513161666723843
      */
    @SerializedName("review_template_id")
    private String reviewTemplateId;
     /**
      * 评估模板名称
      * <p> 示例值：
      */
    @SerializedName("name")
    private I18n name;
     /**
      * 评估模板描述
      * <p> 示例值：
      */
    @SerializedName("description")
    private I18n description;
     /**
      * 状态
      * <p> 示例值：enabled
      */
    @SerializedName("status")
    private String status;
    public Template[] getTemplates() {
        return this.templates;
    }

    public void setTemplates(Template[] templates) {
        this.templates = templates;
    }

    public Unit[] getUnits() {
        return this.units;
    }

    public void setUnits(Unit[] units) {
        this.units = units;
    }

    public String getReviewTemplateId() {
        return this.reviewTemplateId;
    }

    public void setReviewTemplateId(String reviewTemplateId) {
        this.reviewTemplateId = reviewTemplateId;
    }

    public I18n getName() {
        return this.name;
    }

    public void setName(I18n name) {
        this.name = name;
    }

    public I18n getDescription() {
        return this.description;
    }

    public void setDescription(I18n description) {
        this.description = description;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }


// builder 开始
  public ReviewTemplate(){}

  public ReviewTemplate(Builder builder){
         /**
          * 环节模板列表
          * <p> 示例值：
          */
      this.templates = builder.templates;
         /**
          * 评估内容列表
          * <p> 示例值：
          */
      this.units = builder.units;
         /**
          * 评估模板 ID
          * <p> 示例值：7343513161666723843
          */
      this.reviewTemplateId = builder.reviewTemplateId;
         /**
          * 评估模板名称
          * <p> 示例值：
          */
      this.name = builder.name;
         /**
          * 评估模板描述
          * <p> 示例值：
          */
      this.description = builder.description;
         /**
          * 状态
          * <p> 示例值：enabled
          */
      this.status = builder.status;
  }

    public static class Builder {
     /**
      * 环节模板列表
      * <p> 示例值：
      */
        private Template[] templates;
     /**
      * 评估内容列表
      * <p> 示例值：
      */
        private Unit[] units;
     /**
      * 评估模板 ID
      * <p> 示例值：7343513161666723843
      */
        private String reviewTemplateId;
     /**
      * 评估模板名称
      * <p> 示例值：
      */
        private I18n name;
     /**
      * 评估模板描述
      * <p> 示例值：
      */
        private I18n description;
     /**
      * 状态
      * <p> 示例值：enabled
      */
        private String status;

        /**
         * 环节模板列表
         * <p> 示例值：
         * @param templates
         * @return
         */
        public Builder templates(Template[] templates) {
             this.templates = templates;
             return this;
        }

    

        /**
         * 评估内容列表
         * <p> 示例值：
         * @param units
         * @return
         */
        public Builder units(Unit[] units) {
             this.units = units;
             return this;
        }

    

        /**
         * 评估模板 ID
         * <p> 示例值：7343513161666723843
         * @param reviewTemplateId
         * @return
         */
        public Builder reviewTemplateId(String reviewTemplateId) {
             this.reviewTemplateId = reviewTemplateId;
             return this;
        }

    

        /**
         * 评估模板名称
         * <p> 示例值：
         * @param name
         * @return
         */
        public Builder name(I18n name) {
             this.name = name;
             return this;
        }

    

        /**
         * 评估模板描述
         * <p> 示例值：
         * @param description
         * @return
         */
        public Builder description(I18n description) {
             this.description = description;
             return this;
        }

    

        /**
         * 状态
         * <p> 示例值：enabled
         * @param status
         * @return
         */
        public Builder status(String status) {
             this.status = status;
             return this;
        }

    
    
    public ReviewTemplate build(){
        return new ReviewTemplate(this);
      }
    }

    public static Builder newBuilder() {
        return new Builder();
    }
}
