// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.performance.v2.model;
import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.performance.v2.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;
public class Reviewee {
     /**
      * 被评估人 ID
      * <p> 示例值：
      */
    @SerializedName("reviewee_user_id")
    private User revieweeUserId;
     /**
      * 被评估人参与的项目
      * <p> 示例值：
      */
    @SerializedName("activity_ids")
    private String[] activityIds;
     /**
      * 被评估人在该周期的个人绩效详情页链接。如果参与的项目未启动则为空
      * <p> 示例值：https://performance.feishu.cn/perf/profile?rootReviewId=7380183500051202067
      */
    @SerializedName("reviewprofile_url")
    private String reviewprofileUrl;
    public User getRevieweeUserId() {
        return this.revieweeUserId;
    }

    public void setRevieweeUserId(User revieweeUserId) {
        this.revieweeUserId = revieweeUserId;
    }

    public String[] getActivityIds() {
        return this.activityIds;
    }

    public void setActivityIds(String[] activityIds) {
        this.activityIds = activityIds;
    }

    public String getReviewprofileUrl() {
        return this.reviewprofileUrl;
    }

    public void setReviewprofileUrl(String reviewprofileUrl) {
        this.reviewprofileUrl = reviewprofileUrl;
    }


// builder 开始
  public Reviewee(){}

  public Reviewee(Builder builder){
         /**
          * 被评估人 ID
          * <p> 示例值：
          */
      this.revieweeUserId = builder.revieweeUserId;
         /**
          * 被评估人参与的项目
          * <p> 示例值：
          */
      this.activityIds = builder.activityIds;
         /**
          * 被评估人在该周期的个人绩效详情页链接。如果参与的项目未启动则为空
          * <p> 示例值：https://performance.feishu.cn/perf/profile?rootReviewId=7380183500051202067
          */
      this.reviewprofileUrl = builder.reviewprofileUrl;
  }

    public static class Builder {
     /**
      * 被评估人 ID
      * <p> 示例值：
      */
        private User revieweeUserId;
     /**
      * 被评估人参与的项目
      * <p> 示例值：
      */
        private String[] activityIds;
     /**
      * 被评估人在该周期的个人绩效详情页链接。如果参与的项目未启动则为空
      * <p> 示例值：https://performance.feishu.cn/perf/profile?rootReviewId=7380183500051202067
      */
        private String reviewprofileUrl;

        /**
         * 被评估人 ID
         * <p> 示例值：
         * @param revieweeUserId
         * @return
         */
        public Builder revieweeUserId(User revieweeUserId) {
             this.revieweeUserId = revieweeUserId;
             return this;
        }

    

        /**
         * 被评估人参与的项目
         * <p> 示例值：
         * @param activityIds
         * @return
         */
        public Builder activityIds(String[] activityIds) {
             this.activityIds = activityIds;
             return this;
        }

    

        /**
         * 被评估人在该周期的个人绩效详情页链接。如果参与的项目未启动则为空
         * <p> 示例值：https://performance.feishu.cn/perf/profile?rootReviewId=7380183500051202067
         * @param reviewprofileUrl
         * @return
         */
        public Builder reviewprofileUrl(String reviewprofileUrl) {
             this.reviewprofileUrl = reviewprofileUrl;
             return this;
        }

    
    
    public Reviewee build(){
        return new Reviewee(this);
      }
    }

    public static Builder newBuilder() {
        return new Builder();
    }
}
