// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.performance.v2.model;
import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.performance.v2.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;
public class ReviewerInfo {
     /**
      * 360° 评估人的评估尺度标签，枚举值为： 1：严格 2：适中 3：宽松
      * <p> 示例值：1
      */
    @SerializedName("invite_distribute_type")
    private Integer inviteDistributeType;
     /**
      * 360° 评估人的评估尺度数值
      * <p> 示例值：1.1
      */
    @SerializedName("invite_avg_diff")
    private String inviteAvgDiff;
     /**
      * 360° 评估人的与被评估人关系，枚举值： direct_report 直属下级 skiplevel_report 隔级下级 former_direct_manager 原直属上级 skiplevel_manager 隔级上级 teammate 相同上级同事 crossteam_colleague 不同上级同事
      * <p> 示例值：direct_report
      */
    @SerializedName("invite_relationship_with_reviewee")
    private String inviteRelationshipWithReviewee;
     /**
      * 360° 评估人的邀请人类型，枚举值： system_default 系统默认 reviewee 被评估人本人 manager 上级 hrbp_or_others HRBP 或其他人
      * <p> 示例值：reviewee
      */
    @SerializedName("invite_invitedby")
    private String inviteInvitedby;
     /**
      * 评估人作为直属项目上级所在的项目
      * <p> 示例值：7343513161666707459
      */
    @SerializedName("cooperation_project")
    private String cooperationProject;
     /**
      * 合作项目的名称
      * <p> 示例值：
      */
    @SerializedName("cooperation_project_name")
    private I18n cooperationProjectName;
     /**
      * 直属项目上级的项目角色 ID
      * <p> 示例值：7343513161666707459
      */
    @SerializedName("direct_project_leader_role_id")
    private String directProjectLeaderRoleId;
    public Integer getInviteDistributeType() {
        return this.inviteDistributeType;
    }

    public void setInviteDistributeType(Integer inviteDistributeType) {
        this.inviteDistributeType = inviteDistributeType;
    }

    public String getInviteAvgDiff() {
        return this.inviteAvgDiff;
    }

    public void setInviteAvgDiff(String inviteAvgDiff) {
        this.inviteAvgDiff = inviteAvgDiff;
    }

    public String getInviteRelationshipWithReviewee() {
        return this.inviteRelationshipWithReviewee;
    }

    public void setInviteRelationshipWithReviewee(String inviteRelationshipWithReviewee) {
        this.inviteRelationshipWithReviewee = inviteRelationshipWithReviewee;
    }

    public String getInviteInvitedby() {
        return this.inviteInvitedby;
    }

    public void setInviteInvitedby(String inviteInvitedby) {
        this.inviteInvitedby = inviteInvitedby;
    }

    public String getCooperationProject() {
        return this.cooperationProject;
    }

    public void setCooperationProject(String cooperationProject) {
        this.cooperationProject = cooperationProject;
    }

    public I18n getCooperationProjectName() {
        return this.cooperationProjectName;
    }

    public void setCooperationProjectName(I18n cooperationProjectName) {
        this.cooperationProjectName = cooperationProjectName;
    }

    public String getDirectProjectLeaderRoleId() {
        return this.directProjectLeaderRoleId;
    }

    public void setDirectProjectLeaderRoleId(String directProjectLeaderRoleId) {
        this.directProjectLeaderRoleId = directProjectLeaderRoleId;
    }


// builder 开始
  public ReviewerInfo(){}

  public ReviewerInfo(Builder builder){
         /**
          * 360° 评估人的评估尺度标签，枚举值为： 1：严格 2：适中 3：宽松
          * <p> 示例值：1
          */
      this.inviteDistributeType = builder.inviteDistributeType;
         /**
          * 360° 评估人的评估尺度数值
          * <p> 示例值：1.1
          */
      this.inviteAvgDiff = builder.inviteAvgDiff;
         /**
          * 360° 评估人的与被评估人关系，枚举值： direct_report 直属下级 skiplevel_report 隔级下级 former_direct_manager 原直属上级 skiplevel_manager 隔级上级 teammate 相同上级同事 crossteam_colleague 不同上级同事
          * <p> 示例值：direct_report
          */
      this.inviteRelationshipWithReviewee = builder.inviteRelationshipWithReviewee;
         /**
          * 360° 评估人的邀请人类型，枚举值： system_default 系统默认 reviewee 被评估人本人 manager 上级 hrbp_or_others HRBP 或其他人
          * <p> 示例值：reviewee
          */
      this.inviteInvitedby = builder.inviteInvitedby;
         /**
          * 评估人作为直属项目上级所在的项目
          * <p> 示例值：7343513161666707459
          */
      this.cooperationProject = builder.cooperationProject;
         /**
          * 合作项目的名称
          * <p> 示例值：
          */
      this.cooperationProjectName = builder.cooperationProjectName;
         /**
          * 直属项目上级的项目角色 ID
          * <p> 示例值：7343513161666707459
          */
      this.directProjectLeaderRoleId = builder.directProjectLeaderRoleId;
  }

    public static class Builder {
     /**
      * 360° 评估人的评估尺度标签，枚举值为： 1：严格 2：适中 3：宽松
      * <p> 示例值：1
      */
        private Integer inviteDistributeType;
     /**
      * 360° 评估人的评估尺度数值
      * <p> 示例值：1.1
      */
        private String inviteAvgDiff;
     /**
      * 360° 评估人的与被评估人关系，枚举值： direct_report 直属下级 skiplevel_report 隔级下级 former_direct_manager 原直属上级 skiplevel_manager 隔级上级 teammate 相同上级同事 crossteam_colleague 不同上级同事
      * <p> 示例值：direct_report
      */
        private String inviteRelationshipWithReviewee;
     /**
      * 360° 评估人的邀请人类型，枚举值： system_default 系统默认 reviewee 被评估人本人 manager 上级 hrbp_or_others HRBP 或其他人
      * <p> 示例值：reviewee
      */
        private String inviteInvitedby;
     /**
      * 评估人作为直属项目上级所在的项目
      * <p> 示例值：7343513161666707459
      */
        private String cooperationProject;
     /**
      * 合作项目的名称
      * <p> 示例值：
      */
        private I18n cooperationProjectName;
     /**
      * 直属项目上级的项目角色 ID
      * <p> 示例值：7343513161666707459
      */
        private String directProjectLeaderRoleId;

        /**
         * 360° 评估人的评估尺度标签，枚举值为： 1：严格 2：适中 3：宽松
         * <p> 示例值：1
         * @param inviteDistributeType
         * @return
         */
        public Builder inviteDistributeType(Integer inviteDistributeType) {
             this.inviteDistributeType = inviteDistributeType;
             return this;
        }

    

        /**
         * 360° 评估人的评估尺度数值
         * <p> 示例值：1.1
         * @param inviteAvgDiff
         * @return
         */
        public Builder inviteAvgDiff(String inviteAvgDiff) {
             this.inviteAvgDiff = inviteAvgDiff;
             return this;
        }

    

        /**
         * 360° 评估人的与被评估人关系，枚举值： direct_report 直属下级 skiplevel_report 隔级下级 former_direct_manager 原直属上级 skiplevel_manager 隔级上级 teammate 相同上级同事 crossteam_colleague 不同上级同事
         * <p> 示例值：direct_report
         * @param inviteRelationshipWithReviewee
         * @return
         */
        public Builder inviteRelationshipWithReviewee(String inviteRelationshipWithReviewee) {
             this.inviteRelationshipWithReviewee = inviteRelationshipWithReviewee;
             return this;
        }

    

        /**
         * 360° 评估人的邀请人类型，枚举值： system_default 系统默认 reviewee 被评估人本人 manager 上级 hrbp_or_others HRBP 或其他人
         * <p> 示例值：reviewee
         * @param inviteInvitedby
         * @return
         */
        public Builder inviteInvitedby(String inviteInvitedby) {
             this.inviteInvitedby = inviteInvitedby;
             return this;
        }

    

        /**
         * 评估人作为直属项目上级所在的项目
         * <p> 示例值：7343513161666707459
         * @param cooperationProject
         * @return
         */
        public Builder cooperationProject(String cooperationProject) {
             this.cooperationProject = cooperationProject;
             return this;
        }

    

        /**
         * 合作项目的名称
         * <p> 示例值：
         * @param cooperationProjectName
         * @return
         */
        public Builder cooperationProjectName(I18n cooperationProjectName) {
             this.cooperationProjectName = cooperationProjectName;
             return this;
        }

    

        /**
         * 直属项目上级的项目角色 ID
         * <p> 示例值：7343513161666707459
         * @param directProjectLeaderRoleId
         * @return
         */
        public Builder directProjectLeaderRoleId(String directProjectLeaderRoleId) {
             this.directProjectLeaderRoleId = directProjectLeaderRoleId;
             return this;
        }

    
    
    public ReviewerInfo build(){
        return new ReviewerInfo(this);
      }
    }

    public static Builder newBuilder() {
        return new Builder();
    }
}
