// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.performance.v2.model;
import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.performance.v2.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;
public class UserInfo {
     /**
      * 人员
      * <p> 示例值：
      */
    @SerializedName("user_id")
    private User userId;
     /**
      * 用户的直属上级的用户ID
      * <p> 示例值：
      */
    @SerializedName("direct_leader_user_id")
    private User directLeaderUserId;
     /**
      * 人员的部门
      * <p> 示例值：
      */
    @SerializedName("department")
    private Department department;
     /**
      * 人员的序列
      * <p> 示例值：
      */
    @SerializedName("job_family")
    private JobFamily jobFamily;
     /**
      * 人员的职级
      * <p> 示例值：
      */
    @SerializedName("job_level")
    private JobLevel jobLevel;
    public User getUserId() {
        return this.userId;
    }

    public void setUserId(User userId) {
        this.userId = userId;
    }

    public User getDirectLeaderUserId() {
        return this.directLeaderUserId;
    }

    public void setDirectLeaderUserId(User directLeaderUserId) {
        this.directLeaderUserId = directLeaderUserId;
    }

    public Department getDepartment() {
        return this.department;
    }

    public void setDepartment(Department department) {
        this.department = department;
    }

    public JobFamily getJobFamily() {
        return this.jobFamily;
    }

    public void setJobFamily(JobFamily jobFamily) {
        this.jobFamily = jobFamily;
    }

    public JobLevel getJobLevel() {
        return this.jobLevel;
    }

    public void setJobLevel(JobLevel jobLevel) {
        this.jobLevel = jobLevel;
    }


// builder 开始
  public UserInfo(){}

  public UserInfo(Builder builder){
         /**
          * 人员
          * <p> 示例值：
          */
      this.userId = builder.userId;
         /**
          * 用户的直属上级的用户ID
          * <p> 示例值：
          */
      this.directLeaderUserId = builder.directLeaderUserId;
         /**
          * 人员的部门
          * <p> 示例值：
          */
      this.department = builder.department;
         /**
          * 人员的序列
          * <p> 示例值：
          */
      this.jobFamily = builder.jobFamily;
         /**
          * 人员的职级
          * <p> 示例值：
          */
      this.jobLevel = builder.jobLevel;
  }

    public static class Builder {
     /**
      * 人员
      * <p> 示例值：
      */
        private User userId;
     /**
      * 用户的直属上级的用户ID
      * <p> 示例值：
      */
        private User directLeaderUserId;
     /**
      * 人员的部门
      * <p> 示例值：
      */
        private Department department;
     /**
      * 人员的序列
      * <p> 示例值：
      */
        private JobFamily jobFamily;
     /**
      * 人员的职级
      * <p> 示例值：
      */
        private JobLevel jobLevel;

        /**
         * 人员
         * <p> 示例值：
         * @param userId
         * @return
         */
        public Builder userId(User userId) {
             this.userId = userId;
             return this;
        }

    

        /**
         * 用户的直属上级的用户ID
         * <p> 示例值：
         * @param directLeaderUserId
         * @return
         */
        public Builder directLeaderUserId(User directLeaderUserId) {
             this.directLeaderUserId = directLeaderUserId;
             return this;
        }

    

        /**
         * 人员的部门
         * <p> 示例值：
         * @param department
         * @return
         */
        public Builder department(Department department) {
             this.department = department;
             return this;
        }

    

        /**
         * 人员的序列
         * <p> 示例值：
         * @param jobFamily
         * @return
         */
        public Builder jobFamily(JobFamily jobFamily) {
             this.jobFamily = jobFamily;
             return this;
        }

    

        /**
         * 人员的职级
         * <p> 示例值：
         * @param jobLevel
         * @return
         */
        public Builder jobLevel(JobLevel jobLevel) {
             this.jobLevel = jobLevel;
             return this;
        }

    
    
    public UserInfo build(){
        return new UserInfo(this);
      }
    }

    public static Builder newBuilder() {
        return new Builder();
    }
}
