// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.search.v2.model;
import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.search.v2.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;
public class KnowledgeQaAnswerRequest {
     /**
      * 用户问题
      * <p> 示例值：如何申请显示器
      */
    @SerializedName("query")
    private String query;
     /**
      * 启用图片理解与展示
      * <p> 示例值：false
      */
    @SerializedName("enable_image")
    private Boolean enableImage;
     /**
      * 指定答案生成的知识范围
      * <p> 示例值：enterprise
      */
    @SerializedName("knowledge_scope")
    private String knowledgeScope;
     /**
      * 企业内知识的检索范围，选择企业内知识时必填
      * <p> 示例值：
      */
    @SerializedName("enterprise_knowledge_source")
    private EnterpriseKnowledgeSourceParam enterpriseKnowledgeSource;
     /**
      * 额外信息
      * <p> 示例值：
      */
    @SerializedName("extra")
    private KnowledgeSourceRequestExtra extra;
     /**
      * 大模型种类
      * <p> 示例值：doubao
      */
    @SerializedName("model_type")
    private String modelType;
    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public Boolean getEnableImage() {
        return this.enableImage;
    }

    public void setEnableImage(Boolean enableImage) {
        this.enableImage = enableImage;
    }

    public String getKnowledgeScope() {
        return this.knowledgeScope;
    }

    public void setKnowledgeScope(String knowledgeScope) {
        this.knowledgeScope = knowledgeScope;
    }

    public EnterpriseKnowledgeSourceParam getEnterpriseKnowledgeSource() {
        return this.enterpriseKnowledgeSource;
    }

    public void setEnterpriseKnowledgeSource(EnterpriseKnowledgeSourceParam enterpriseKnowledgeSource) {
        this.enterpriseKnowledgeSource = enterpriseKnowledgeSource;
    }

    public KnowledgeSourceRequestExtra getExtra() {
        return this.extra;
    }

    public void setExtra(KnowledgeSourceRequestExtra extra) {
        this.extra = extra;
    }

    public String getModelType() {
        return this.modelType;
    }

    public void setModelType(String modelType) {
        this.modelType = modelType;
    }


// builder 开始
  public KnowledgeQaAnswerRequest(){}

  public KnowledgeQaAnswerRequest(Builder builder){
         /**
          * 用户问题
          * <p> 示例值：如何申请显示器
          */
      this.query = builder.query;
         /**
          * 启用图片理解与展示
          * <p> 示例值：false
          */
      this.enableImage = builder.enableImage;
         /**
          * 指定答案生成的知识范围
          * <p> 示例值：enterprise
          */
      this.knowledgeScope = builder.knowledgeScope;
         /**
          * 企业内知识的检索范围，选择企业内知识时必填
          * <p> 示例值：
          */
      this.enterpriseKnowledgeSource = builder.enterpriseKnowledgeSource;
         /**
          * 额外信息
          * <p> 示例值：
          */
      this.extra = builder.extra;
         /**
          * 大模型种类
          * <p> 示例值：doubao
          */
      this.modelType = builder.modelType;
  }

    public static class Builder {
     /**
      * 用户问题
      * <p> 示例值：如何申请显示器
      */
        private String query;
     /**
      * 启用图片理解与展示
      * <p> 示例值：false
      */
        private Boolean enableImage;
     /**
      * 指定答案生成的知识范围
      * <p> 示例值：enterprise
      */
        private String knowledgeScope;
     /**
      * 企业内知识的检索范围，选择企业内知识时必填
      * <p> 示例值：
      */
        private EnterpriseKnowledgeSourceParam enterpriseKnowledgeSource;
     /**
      * 额外信息
      * <p> 示例值：
      */
        private KnowledgeSourceRequestExtra extra;
     /**
      * 大模型种类
      * <p> 示例值：doubao
      */
        private String modelType;

        /**
         * 用户问题
         * <p> 示例值：如何申请显示器
         * @param query
         * @return
         */
        public Builder query(String query) {
             this.query = query;
             return this;
        }

    

        /**
         * 启用图片理解与展示
         * <p> 示例值：false
         * @param enableImage
         * @return
         */
        public Builder enableImage(Boolean enableImage) {
             this.enableImage = enableImage;
             return this;
        }

    

        /**
         * 指定答案生成的知识范围
         * <p> 示例值：enterprise
         * @param knowledgeScope
         * @return
         */
        public Builder knowledgeScope(String knowledgeScope) {
             this.knowledgeScope = knowledgeScope;
             return this;
        }
        /**
         * 指定答案生成的知识范围
         * <p> 示例值：enterprise
         * @param knowledgeScope {@link com.lark.oapi.service.search.v2.enums.KnowledgeQaAnswerRequestKnowledgeScopeEnum}
         * @return
         */
        public Builder knowledgeScope(com.lark.oapi.service.search.v2.enums.KnowledgeQaAnswerRequestKnowledgeScopeEnum knowledgeScope) {
             this.knowledgeScope = knowledgeScope.getValue();
             return this;
        }

    

        /**
         * 企业内知识的检索范围，选择企业内知识时必填
         * <p> 示例值：
         * @param enterpriseKnowledgeSource
         * @return
         */
        public Builder enterpriseKnowledgeSource(EnterpriseKnowledgeSourceParam enterpriseKnowledgeSource) {
             this.enterpriseKnowledgeSource = enterpriseKnowledgeSource;
             return this;
        }

    

        /**
         * 额外信息
         * <p> 示例值：
         * @param extra
         * @return
         */
        public Builder extra(KnowledgeSourceRequestExtra extra) {
             this.extra = extra;
             return this;
        }

    

        /**
         * 大模型种类
         * <p> 示例值：doubao
         * @param modelType
         * @return
         */
        public Builder modelType(String modelType) {
             this.modelType = modelType;
             return this;
        }
        /**
         * 大模型种类
         * <p> 示例值：doubao
         * @param modelType {@link com.lark.oapi.service.search.v2.enums.KnowledgeQaAnswerRequestModelTypeEnum}
         * @return
         */
        public Builder modelType(com.lark.oapi.service.search.v2.enums.KnowledgeQaAnswerRequestModelTypeEnum modelType) {
             this.modelType = modelType.getValue();
             return this;
        }

    
    
    public KnowledgeQaAnswerRequest build(){
        return new KnowledgeQaAnswerRequest(this);
      }
    }

    public static Builder newBuilder() {
        return new Builder();
    }
}
