// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.security_and_compliance.v1.model;
import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.security_and_compliance.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;
public class FileRiskDetectionRecordResult {
     /**
      * 检测状态
      * <p> 示例值：FINISHED
      */
    @SerializedName("status")
    private String status;
     /**
      * 风险类型
      * <p> 示例值：RISK
      */
    @SerializedName("risk_tag")
    private String riskTag;
     /**
      * 是否需要机器人通知
      * <p> 示例值：true
      */
    @SerializedName("need_bot_notify")
    private Boolean needBotNotify;
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getRiskTag() {
        return this.riskTag;
    }

    public void setRiskTag(String riskTag) {
        this.riskTag = riskTag;
    }

    public Boolean getNeedBotNotify() {
        return this.needBotNotify;
    }

    public void setNeedBotNotify(Boolean needBotNotify) {
        this.needBotNotify = needBotNotify;
    }


// builder 开始
  public FileRiskDetectionRecordResult(){}

  public FileRiskDetectionRecordResult(Builder builder){
         /**
          * 检测状态
          * <p> 示例值：FINISHED
          */
      this.status = builder.status;
         /**
          * 风险类型
          * <p> 示例值：RISK
          */
      this.riskTag = builder.riskTag;
         /**
          * 是否需要机器人通知
          * <p> 示例值：true
          */
      this.needBotNotify = builder.needBotNotify;
  }

    public static class Builder {
     /**
      * 检测状态
      * <p> 示例值：FINISHED
      */
        private String status;
     /**
      * 风险类型
      * <p> 示例值：RISK
      */
        private String riskTag;
     /**
      * 是否需要机器人通知
      * <p> 示例值：true
      */
        private Boolean needBotNotify;

        /**
         * 检测状态
         * <p> 示例值：FINISHED
         * @param status
         * @return
         */
        public Builder status(String status) {
             this.status = status;
             return this;
        }
        /**
         * 检测状态
         * <p> 示例值：FINISHED
         * @param status {@link com.lark.oapi.service.security_and_compliance.v1.enums.FileRiskDetectionRecordResultStatusEnum}
         * @return
         */
        public Builder status(com.lark.oapi.service.security_and_compliance.v1.enums.FileRiskDetectionRecordResultStatusEnum status) {
             this.status = status.getValue();
             return this;
        }

    

        /**
         * 风险类型
         * <p> 示例值：RISK
         * @param riskTag
         * @return
         */
        public Builder riskTag(String riskTag) {
             this.riskTag = riskTag;
             return this;
        }
        /**
         * 风险类型
         * <p> 示例值：RISK
         * @param riskTag {@link com.lark.oapi.service.security_and_compliance.v1.enums.FileRiskDetectionRecordResultRiskTagEnum}
         * @return
         */
        public Builder riskTag(com.lark.oapi.service.security_and_compliance.v1.enums.FileRiskDetectionRecordResultRiskTagEnum riskTag) {
             this.riskTag = riskTag.getValue();
             return this;
        }

    

        /**
         * 是否需要机器人通知
         * <p> 示例值：true
         * @param needBotNotify
         * @return
         */
        public Builder needBotNotify(Boolean needBotNotify) {
             this.needBotNotify = needBotNotify;
             return this;
        }

    
    
    public FileRiskDetectionRecordResult build(){
        return new FileRiskDetectionRecordResult(this);
      }
    }

    public static Builder newBuilder() {
        return new Builder();
    }
}
