// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package com.lark.oapi.service.task;

import com.lark.oapi.core.Config;
import com.lark.oapi.event.IEventHandler;
import com.lark.oapi.service.task.v1.V1;
import com.lark.oapi.service.task.v1.model.*;
import com.lark.oapi.service.task.v1.resource.Task;
import com.lark.oapi.service.task.v1.resource.TaskCollaborator;
import com.lark.oapi.service.task.v1.resource.TaskComment;
import com.lark.oapi.service.task.v1.resource.TaskFollower;
import com.lark.oapi.service.task.v1.resource.TaskReminder;
import com.lark.oapi.service.task.v2.V2;
import com.lark.oapi.service.task.v2.model.*;

public class TaskService {
    private final V1 v1;
    private final Task task; // 任务
    private final TaskCollaborator taskCollaborator; // 执行者
    private final TaskComment taskComment; // 评论
    private final TaskFollower taskFollower; // 关注人
    private final TaskReminder taskReminder; // 提醒
    private final V2 v2;

    public TaskService(Config config) {
    this.v1 = new V1(config);
    this.task = new Task(config);
    this.taskCollaborator = new TaskCollaborator(config);
    this.taskComment = new TaskComment(config);
    this.taskFollower = new TaskFollower(config);
    this.taskReminder = new TaskReminder(config);
    this.v2 = new V2(config);
    }
    public V1 v1() {
        return v1;
    }
    public Task task() {
        return task;
    }
    public TaskCollaborator taskCollaborator() {
        return taskCollaborator;
    }
    public TaskComment taskComment() {
        return taskComment;
    }
    public TaskFollower taskFollower() {
        return taskFollower;
    }
    public TaskReminder taskReminder() {
        return taskReminder;
    }
    public abstract static class P2TaskUpdateTenantV1Handler implements IEventHandler<P2TaskUpdateTenantV1> {
        @Override
        public P2TaskUpdateTenantV1 getEvent() {
            return new P2TaskUpdateTenantV1();
        }
    }
    public abstract static class P2TaskUpdatedV1Handler implements IEventHandler<P2TaskUpdatedV1> {
        @Override
        public P2TaskUpdatedV1 getEvent() {
            return new P2TaskUpdatedV1();
        }
    }
    public abstract static class P2TaskCommentUpdatedV1Handler implements IEventHandler<P2TaskCommentUpdatedV1> {
        @Override
        public P2TaskCommentUpdatedV1 getEvent() {
            return new P2TaskCommentUpdatedV1();
        }
    }
    public V2 v2() {
        return v2;
    }
}