/*
 * Decompiled with CFR 0.152.
 */
package com.lark.oapi.event;

import com.lark.oapi.core.IHandler;
import com.lark.oapi.core.exception.DecryptException;
import com.lark.oapi.core.exception.EventTypeAlreadyHasHandlerException;
import com.lark.oapi.core.exception.IncorrectChallengeException;
import com.lark.oapi.core.exception.IncorrectSignatureException;
import com.lark.oapi.core.request.EventReq;
import com.lark.oapi.core.response.EventResp;
import com.lark.oapi.core.utils.Decryptor;
import com.lark.oapi.core.utils.Jsons;
import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.event.AppTicketEventHandler;
import com.lark.oapi.event.CustomAppTicketEventHandler;
import com.lark.oapi.event.CustomEventHandler;
import com.lark.oapi.event.ICallBackHandler;
import com.lark.oapi.event.IEventHandler;
import com.lark.oapi.event.cardcallback.P2CardActionTriggerHandler;
import com.lark.oapi.event.cardcallback.P2URLPreviewGetHandler;
import com.lark.oapi.event.exception.HandlerNotFoundException;
import com.lark.oapi.event.model.BaseEvent;
import com.lark.oapi.event.model.BaseEventV2;
import com.lark.oapi.event.model.Fuzzy;
import com.lark.oapi.service.acs.AcsService;
import com.lark.oapi.service.application.ApplicationService;
import com.lark.oapi.service.approval.ApprovalService;
import com.lark.oapi.service.calendar.CalendarService;
import com.lark.oapi.service.contact.ContactService;
import com.lark.oapi.service.corehr.CorehrService;
import com.lark.oapi.service.drive.DriveService;
import com.lark.oapi.service.helpdesk.HelpdeskService;
import com.lark.oapi.service.hire.HireService;
import com.lark.oapi.service.im.ImService;
import com.lark.oapi.service.mail.MailService;
import com.lark.oapi.service.meeting_room.MeetingRoomService;
import com.lark.oapi.service.moments.MomentsService;
import com.lark.oapi.service.payroll.PayrollService;
import com.lark.oapi.service.performance.PerformanceService;
import com.lark.oapi.service.task.TaskService;
import com.lark.oapi.service.vc.VcService;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventDispatcher
implements IHandler {
    private static final Logger log = LoggerFactory.getLogger(EventDispatcher.class);
    private Map<String, IEventHandler> eventType2EventHandler = new HashMap<String, IEventHandler>();
    private Map<String, ICallBackHandler> eventType2CardCallBackHandler = new HashMap<String, ICallBackHandler>();
    private String verificationToken;
    private String encryptKey;

    public EventDispatcher(Builder builder) {
        this.verificationToken = builder.verificationToken;
        this.encryptKey = builder.encryptKey;
        this.eventType2EventHandler = builder.eventType2EventHandler;
        this.eventType2CardCallBackHandler = builder.eventType2CardCallbackHandler;
    }

    public String getVerificationToken() {
        return this.verificationToken;
    }

    public String getEncryptKey() {
        return this.encryptKey;
    }

    public String parseReq(EventReq eventReq) throws UnsupportedEncodingException {
        log.info("event req,header:{},body:{}", (Object)Jsons.LONG_TO_STR.toJson(eventReq.getHeaders()), (Object)new String(eventReq.getBody(), StandardCharsets.UTF_8));
        if (!Strings.isEmpty(this.encryptKey)) {
            Fuzzy fuzzy = (Fuzzy)Jsons.DEFAULT.fromJson(new String(eventReq.getBody(), StandardCharsets.UTF_8), Fuzzy.class);
            if (fuzzy == null || Strings.isEmpty(fuzzy.getEncrypt())) {
                throw new DecryptException("The result of event decryption failed");
            }
            return fuzzy.getEncrypt().trim();
        }
        return new String(eventReq.getBody(), StandardCharsets.UTF_8).trim();
    }

    public String decryptEvent(String cipherEventJsonStr) {
        if (!Strings.isEmpty(this.encryptKey)) {
            String plainEventJsonStr = new Decryptor(this.encryptKey).decrypt(cipherEventJsonStr);
            log.debug("plain Event: {}", (Object)plainEventJsonStr);
            return plainEventJsonStr.trim();
        }
        return cipherEventJsonStr;
    }

    private boolean verifySign(EventReq eventReq) throws NoSuchAlgorithmException {
        if (Strings.isEmpty(this.encryptKey)) {
            return true;
        }
        String cipherEventJsonStr = new String(eventReq.getBody(), StandardCharsets.UTF_8);
        String timestamp = eventReq.getHeaderFirstValue("X-Lark-Request-Timestamp");
        String nonce = eventReq.getHeaderFirstValue("X-Lark-Request-Nonce");
        String sourceSign = eventReq.getHeaderFirstValue("X-Lark-Signature");
        String targetSign = this.calculateSignature(timestamp, nonce, this.encryptKey, cipherEventJsonStr);
        return targetSign.equals(sourceSign);
    }

    protected String calculateSignature(String timestamp, String nonce, String encryptKey, String bodyString) throws NoSuchAlgorithmException {
        StringBuilder content = new StringBuilder();
        content.append(timestamp).append(nonce).append(encryptKey).append(bodyString);
        MessageDigest alg = MessageDigest.getInstance("SHA-256");
        String sign = Hex.encodeHexString((byte[])alg.digest(content.toString().getBytes()));
        return sign;
    }

    private EventResp doHandle(String plainEventJsonStr, String eventType, String reqType, String challenge, String token, EventReq req) throws Exception {
        EventResp resp = new EventResp();
        resp.setStatusCode(200);
        resp.setContentType("application/json; charset=utf-8");
        req.setPlain(plainEventJsonStr);
        if ("url_verification".equals(reqType)) {
            if (!this.verificationToken.equals(token)) {
                throw new IncorrectChallengeException();
            }
            resp.setBody(String.format("{\"challenge\":\"%s\"}", challenge).getBytes(StandardCharsets.UTF_8));
            return resp;
        }
        ICallBackHandler callBackHandler = this.eventType2CardCallBackHandler.get(eventType);
        if (callBackHandler != null) {
            Object eventMsg = callBackHandler.getEvent();
            eventMsg = callBackHandler instanceof CustomEventHandler ? req : Jsons.DEFAULT.fromJson(plainEventJsonStr, eventMsg.getClass());
            if (eventMsg instanceof BaseEventV2) {
                ((BaseEventV2)eventMsg).setEventReq(req);
            } else if (eventMsg instanceof BaseEvent) {
                ((BaseEvent)eventMsg).setEventReq(req);
            }
            Object r = callBackHandler.handle(eventMsg);
            resp.setBody(Jsons.DEFAULT.toJson(r).getBytes(StandardCharsets.UTF_8));
            return resp;
        }
        IEventHandler handler = this.eventType2EventHandler.get(eventType);
        if (handler == null) {
            throw new HandlerNotFoundException(eventType);
        }
        Object eventMsg = handler.getEvent();
        eventMsg = handler instanceof CustomEventHandler ? req : Jsons.DEFAULT.fromJson(plainEventJsonStr, eventMsg.getClass());
        if (eventMsg instanceof BaseEventV2) {
            ((BaseEventV2)eventMsg).setEventReq(req);
        } else if (eventMsg instanceof BaseEvent) {
            ((BaseEvent)eventMsg).setEventReq(req);
        }
        handler.handle(eventMsg);
        resp.setBody(String.format("{\"msg\":\"%s\"}", "success").getBytes(StandardCharsets.UTF_8));
        return resp;
    }

    public Object doWithoutValidation(byte[] payload) throws Throwable {
        ICallBackHandler callBackHandler;
        String pl = new String(payload, StandardCharsets.UTF_8);
        Fuzzy fuzzy = (Fuzzy)Jsons.DEFAULT.fromJson(pl, Fuzzy.class);
        String eventType = "";
        if (fuzzy.getEvent() != null) {
            eventType = fuzzy.getEvent().getType();
        }
        if (fuzzy.getHeader() != null) {
            eventType = fuzzy.getHeader().getEventType();
        }
        if ((callBackHandler = this.eventType2CardCallBackHandler.get(eventType)) != null) {
            EventReq req = new EventReq();
            req.setBody(payload);
            Object eventMsg = callBackHandler.getEvent();
            eventMsg = callBackHandler instanceof CustomEventHandler ? req : Jsons.DEFAULT.fromJson(pl, eventMsg.getClass());
            if (eventMsg instanceof BaseEventV2) {
                ((BaseEventV2)eventMsg).setEventReq(req);
            } else if (eventMsg instanceof BaseEvent) {
                ((BaseEvent)eventMsg).setEventReq(req);
            }
            return callBackHandler.handle(eventMsg);
        }
        IEventHandler handler = this.eventType2EventHandler.get(eventType);
        if (handler == null) {
            throw new HandlerNotFoundException(eventType);
        }
        EventReq req = new EventReq();
        req.setBody(payload);
        Object eventMsg = handler.getEvent();
        eventMsg = handler instanceof CustomEventHandler ? req : Jsons.DEFAULT.fromJson(pl, eventMsg.getClass());
        if (eventMsg instanceof BaseEventV2) {
            ((BaseEventV2)eventMsg).setEventReq(req);
        } else if (eventMsg instanceof BaseEvent) {
            ((BaseEvent)eventMsg).setEventReq(req);
        }
        handler.handle(eventMsg);
        return null;
    }

    @Override
    public EventResp handle(EventReq eventReq) throws Throwable {
        EventResp eventResp = new EventResp();
        eventResp.setStatusCode(200);
        eventResp.setContentType("application/json; charset=utf-8");
        try {
            String cipherEventJsonStr = this.parseReq(eventReq);
            String plainEventJsonStr = this.decryptEvent(cipherEventJsonStr);
            Fuzzy fuzzy = (Fuzzy)Jsons.DEFAULT.fromJson(plainEventJsonStr, Fuzzy.class);
            if (Strings.isNotEmpty(fuzzy.getEncrypt())) {
                throw new IllegalArgumentException("process encrypted msg event, need config encryptKey");
            }
            String token = fuzzy.getToken();
            String eventType = "";
            if (fuzzy.getEvent() != null) {
                eventType = fuzzy.getEvent().getType();
            }
            if (fuzzy.getHeader() != null) {
                token = fuzzy.getHeader().getToken();
                eventType = fuzzy.getHeader().getEventType();
            }
            String challenge = fuzzy.getChallenge();
            String reqType = fuzzy.getType();
            if (!"url_verification".equals(reqType) && !this.verifySign(eventReq)) {
                throw new IncorrectSignatureException();
            }
            return this.doHandle(plainEventJsonStr, eventType, reqType, challenge, token, eventReq);
        }
        catch (Throwable e) {
            log.error("handle event failed,httpPath:{},requestId:{},err:", new Object[]{eventReq.getHttpPath(), eventReq.getRequestID(), e});
            if (e instanceof HandlerNotFoundException) {
                eventResp.setBody(String.format("{\"msg\":\"%s\"}", e.getMessage()).getBytes(StandardCharsets.UTF_8));
                return eventResp;
            }
            eventResp.setStatusCode(500);
            eventResp.setBody(String.format("{\"msg\":\"%s\"}", e.getMessage()).getBytes(StandardCharsets.UTF_8));
            return eventResp;
        }
    }

    public static Builder newBuilder(String verificationToken, String encryptKey) {
        return new Builder(verificationToken, encryptKey);
    }

    public static class Builder {
        private Map<String, IEventHandler> eventType2EventHandler = new HashMap<String, IEventHandler>();
        private Map<String, ICallBackHandler> eventType2CardCallbackHandler = new HashMap<String, ICallBackHandler>();
        private String verificationToken;
        private String encryptKey;

        public Builder(String verificationToken, String encryptKey) {
            this.verificationToken = verificationToken;
            this.encryptKey = encryptKey;
            this.eventType2EventHandler.put("app_ticket", new AppTicketEventHandler());
        }

        public EventDispatcher build() {
            return new EventDispatcher(this);
        }

        public Builder onP2CardActionTrigger(P2CardActionTriggerHandler handler) {
            if (this.eventType2CardCallbackHandler.containsKey("card.action.trigger")) {
                throw new EventTypeAlreadyHasHandlerException("card.action.trigger");
            }
            this.eventType2CardCallbackHandler.put("card.action.trigger", handler);
            return this;
        }

        public Builder onP2URLPreviewGet(P2URLPreviewGetHandler handler) {
            if (this.eventType2CardCallbackHandler.containsKey("url.preview.get")) {
                throw new EventTypeAlreadyHasHandlerException("url.preview.get");
            }
            this.eventType2CardCallbackHandler.put("url.preview.get", handler);
            return this;
        }

        public Builder onP2AccessRecordCreatedV1(AcsService.P2AccessRecordCreatedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("acs.access_record.created_v1")) {
                throw new EventTypeAlreadyHasHandlerException("acs.access_record.created_v1");
            }
            this.eventType2EventHandler.put("acs.access_record.created_v1", handler);
            return this;
        }

        public Builder onP2UserUpdatedV1(AcsService.P2UserUpdatedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("acs.user.updated_v1")) {
                throw new EventTypeAlreadyHasHandlerException("acs.user.updated_v1");
            }
            this.eventType2EventHandler.put("acs.user.updated_v1", handler);
            return this;
        }

        public Builder onP2ApplicationCreatedV6(ApplicationService.P2ApplicationCreatedV6Handler handler) {
            if (this.eventType2EventHandler.containsKey("application.application.created_v6")) {
                throw new EventTypeAlreadyHasHandlerException("application.application.created_v6");
            }
            this.eventType2EventHandler.put("application.application.created_v6", handler);
            return this;
        }

        public Builder onP2ApplicationAppVersionAuditV6(ApplicationService.P2ApplicationAppVersionAuditV6Handler handler) {
            if (this.eventType2EventHandler.containsKey("application.application.app_version.audit_v6")) {
                throw new EventTypeAlreadyHasHandlerException("application.application.app_version.audit_v6");
            }
            this.eventType2EventHandler.put("application.application.app_version.audit_v6", handler);
            return this;
        }

        public Builder onP2ApplicationAppVersionPublishApplyV6(ApplicationService.P2ApplicationAppVersionPublishApplyV6Handler handler) {
            if (this.eventType2EventHandler.containsKey("application.application.app_version.publish_apply_v6")) {
                throw new EventTypeAlreadyHasHandlerException("application.application.app_version.publish_apply_v6");
            }
            this.eventType2EventHandler.put("application.application.app_version.publish_apply_v6", handler);
            return this;
        }

        public Builder onP2ApplicationAppVersionPublishRevokeV6(ApplicationService.P2ApplicationAppVersionPublishRevokeV6Handler handler) {
            if (this.eventType2EventHandler.containsKey("application.application.app_version.publish_revoke_v6")) {
                throw new EventTypeAlreadyHasHandlerException("application.application.app_version.publish_revoke_v6");
            }
            this.eventType2EventHandler.put("application.application.app_version.publish_revoke_v6", handler);
            return this;
        }

        public Builder onP2ApplicationFeedbackCreatedV6(ApplicationService.P2ApplicationFeedbackCreatedV6Handler handler) {
            if (this.eventType2EventHandler.containsKey("application.application.feedback.created_v6")) {
                throw new EventTypeAlreadyHasHandlerException("application.application.feedback.created_v6");
            }
            this.eventType2EventHandler.put("application.application.feedback.created_v6", handler);
            return this;
        }

        public Builder onP2ApplicationFeedbackUpdatedV6(ApplicationService.P2ApplicationFeedbackUpdatedV6Handler handler) {
            if (this.eventType2EventHandler.containsKey("application.application.feedback.updated_v6")) {
                throw new EventTypeAlreadyHasHandlerException("application.application.feedback.updated_v6");
            }
            this.eventType2EventHandler.put("application.application.feedback.updated_v6", handler);
            return this;
        }

        public Builder onP2ApplicationVisibilityAddedV6(ApplicationService.P2ApplicationVisibilityAddedV6Handler handler) {
            if (this.eventType2EventHandler.containsKey("application.application.visibility.added_v6")) {
                throw new EventTypeAlreadyHasHandlerException("application.application.visibility.added_v6");
            }
            this.eventType2EventHandler.put("application.application.visibility.added_v6", handler);
            return this;
        }

        public Builder onP2BotMenuV6(ApplicationService.P2BotMenuV6Handler handler) {
            if (this.eventType2EventHandler.containsKey("application.bot.menu_v6")) {
                throw new EventTypeAlreadyHasHandlerException("application.bot.menu_v6");
            }
            this.eventType2EventHandler.put("application.bot.menu_v6", handler);
            return this;
        }

        public Builder onP2ApprovalUpdatedV4(ApprovalService.P2ApprovalUpdatedV4Handler handler) {
            if (this.eventType2EventHandler.containsKey("approval.approval.updated_v4")) {
                throw new EventTypeAlreadyHasHandlerException("approval.approval.updated_v4");
            }
            this.eventType2EventHandler.put("approval.approval.updated_v4", handler);
            return this;
        }

        public Builder onP2CalendarChangedV4(CalendarService.P2CalendarChangedV4Handler handler) {
            if (this.eventType2EventHandler.containsKey("calendar.calendar.changed_v4")) {
                throw new EventTypeAlreadyHasHandlerException("calendar.calendar.changed_v4");
            }
            this.eventType2EventHandler.put("calendar.calendar.changed_v4", handler);
            return this;
        }

        public Builder onP2CalendarAclCreatedV4(CalendarService.P2CalendarAclCreatedV4Handler handler) {
            if (this.eventType2EventHandler.containsKey("calendar.calendar.acl.created_v4")) {
                throw new EventTypeAlreadyHasHandlerException("calendar.calendar.acl.created_v4");
            }
            this.eventType2EventHandler.put("calendar.calendar.acl.created_v4", handler);
            return this;
        }

        public Builder onP2CalendarAclDeletedV4(CalendarService.P2CalendarAclDeletedV4Handler handler) {
            if (this.eventType2EventHandler.containsKey("calendar.calendar.acl.deleted_v4")) {
                throw new EventTypeAlreadyHasHandlerException("calendar.calendar.acl.deleted_v4");
            }
            this.eventType2EventHandler.put("calendar.calendar.acl.deleted_v4", handler);
            return this;
        }

        public Builder onP2CalendarEventChangedV4(CalendarService.P2CalendarEventChangedV4Handler handler) {
            if (this.eventType2EventHandler.containsKey("calendar.calendar.event.changed_v4")) {
                throw new EventTypeAlreadyHasHandlerException("calendar.calendar.event.changed_v4");
            }
            this.eventType2EventHandler.put("calendar.calendar.event.changed_v4", handler);
            return this;
        }

        public Builder onP2CustomAttrEventUpdatedV3(ContactService.P2CustomAttrEventUpdatedV3Handler handler) {
            if (this.eventType2EventHandler.containsKey("contact.custom_attr_event.updated_v3")) {
                throw new EventTypeAlreadyHasHandlerException("contact.custom_attr_event.updated_v3");
            }
            this.eventType2EventHandler.put("contact.custom_attr_event.updated_v3", handler);
            return this;
        }

        public Builder onP2DepartmentCreatedV3(ContactService.P2DepartmentCreatedV3Handler handler) {
            if (this.eventType2EventHandler.containsKey("contact.department.created_v3")) {
                throw new EventTypeAlreadyHasHandlerException("contact.department.created_v3");
            }
            this.eventType2EventHandler.put("contact.department.created_v3", handler);
            return this;
        }

        public Builder onP2DepartmentDeletedV3(ContactService.P2DepartmentDeletedV3Handler handler) {
            if (this.eventType2EventHandler.containsKey("contact.department.deleted_v3")) {
                throw new EventTypeAlreadyHasHandlerException("contact.department.deleted_v3");
            }
            this.eventType2EventHandler.put("contact.department.deleted_v3", handler);
            return this;
        }

        public Builder onP2DepartmentUpdatedV3(ContactService.P2DepartmentUpdatedV3Handler handler) {
            if (this.eventType2EventHandler.containsKey("contact.department.updated_v3")) {
                throw new EventTypeAlreadyHasHandlerException("contact.department.updated_v3");
            }
            this.eventType2EventHandler.put("contact.department.updated_v3", handler);
            return this;
        }

        public Builder onP2EmployeeTypeEnumActivedV3(ContactService.P2EmployeeTypeEnumActivedV3Handler handler) {
            if (this.eventType2EventHandler.containsKey("contact.employee_type_enum.actived_v3")) {
                throw new EventTypeAlreadyHasHandlerException("contact.employee_type_enum.actived_v3");
            }
            this.eventType2EventHandler.put("contact.employee_type_enum.actived_v3", handler);
            return this;
        }

        public Builder onP2EmployeeTypeEnumCreatedV3(ContactService.P2EmployeeTypeEnumCreatedV3Handler handler) {
            if (this.eventType2EventHandler.containsKey("contact.employee_type_enum.created_v3")) {
                throw new EventTypeAlreadyHasHandlerException("contact.employee_type_enum.created_v3");
            }
            this.eventType2EventHandler.put("contact.employee_type_enum.created_v3", handler);
            return this;
        }

        public Builder onP2EmployeeTypeEnumDeactivatedV3(ContactService.P2EmployeeTypeEnumDeactivatedV3Handler handler) {
            if (this.eventType2EventHandler.containsKey("contact.employee_type_enum.deactivated_v3")) {
                throw new EventTypeAlreadyHasHandlerException("contact.employee_type_enum.deactivated_v3");
            }
            this.eventType2EventHandler.put("contact.employee_type_enum.deactivated_v3", handler);
            return this;
        }

        public Builder onP2EmployeeTypeEnumDeletedV3(ContactService.P2EmployeeTypeEnumDeletedV3Handler handler) {
            if (this.eventType2EventHandler.containsKey("contact.employee_type_enum.deleted_v3")) {
                throw new EventTypeAlreadyHasHandlerException("contact.employee_type_enum.deleted_v3");
            }
            this.eventType2EventHandler.put("contact.employee_type_enum.deleted_v3", handler);
            return this;
        }

        public Builder onP2EmployeeTypeEnumUpdatedV3(ContactService.P2EmployeeTypeEnumUpdatedV3Handler handler) {
            if (this.eventType2EventHandler.containsKey("contact.employee_type_enum.updated_v3")) {
                throw new EventTypeAlreadyHasHandlerException("contact.employee_type_enum.updated_v3");
            }
            this.eventType2EventHandler.put("contact.employee_type_enum.updated_v3", handler);
            return this;
        }

        public Builder onP2ScopeUpdatedV3(ContactService.P2ScopeUpdatedV3Handler handler) {
            if (this.eventType2EventHandler.containsKey("contact.scope.updated_v3")) {
                throw new EventTypeAlreadyHasHandlerException("contact.scope.updated_v3");
            }
            this.eventType2EventHandler.put("contact.scope.updated_v3", handler);
            return this;
        }

        public Builder onP2UserCreatedV3(ContactService.P2UserCreatedV3Handler handler) {
            if (this.eventType2EventHandler.containsKey("contact.user.created_v3")) {
                throw new EventTypeAlreadyHasHandlerException("contact.user.created_v3");
            }
            this.eventType2EventHandler.put("contact.user.created_v3", handler);
            return this;
        }

        public Builder onP2UserDeletedV3(ContactService.P2UserDeletedV3Handler handler) {
            if (this.eventType2EventHandler.containsKey("contact.user.deleted_v3")) {
                throw new EventTypeAlreadyHasHandlerException("contact.user.deleted_v3");
            }
            this.eventType2EventHandler.put("contact.user.deleted_v3", handler);
            return this;
        }

        public Builder onP2UserUpdatedV3(ContactService.P2UserUpdatedV3Handler handler) {
            if (this.eventType2EventHandler.containsKey("contact.user.updated_v3")) {
                throw new EventTypeAlreadyHasHandlerException("contact.user.updated_v3");
            }
            this.eventType2EventHandler.put("contact.user.updated_v3", handler);
            return this;
        }

        public Builder onP2CommonDataMetaDataUpdatedV1(CorehrService.P2CommonDataMetaDataUpdatedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("corehr.common_data.meta_data.updated_v1")) {
                throw new EventTypeAlreadyHasHandlerException("corehr.common_data.meta_data.updated_v1");
            }
            this.eventType2EventHandler.put("corehr.common_data.meta_data.updated_v1", handler);
            return this;
        }

        public Builder onP2ContractCreatedV1(CorehrService.P2ContractCreatedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("corehr.contract.created_v1")) {
                throw new EventTypeAlreadyHasHandlerException("corehr.contract.created_v1");
            }
            this.eventType2EventHandler.put("corehr.contract.created_v1", handler);
            return this;
        }

        public Builder onP2ContractDeletedV1(CorehrService.P2ContractDeletedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("corehr.contract.deleted_v1")) {
                throw new EventTypeAlreadyHasHandlerException("corehr.contract.deleted_v1");
            }
            this.eventType2EventHandler.put("corehr.contract.deleted_v1", handler);
            return this;
        }

        public Builder onP2ContractUpdatedV1(CorehrService.P2ContractUpdatedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("corehr.contract.updated_v1")) {
                throw new EventTypeAlreadyHasHandlerException("corehr.contract.updated_v1");
            }
            this.eventType2EventHandler.put("corehr.contract.updated_v1", handler);
            return this;
        }

        public Builder onP2DepartmentCreatedV1(CorehrService.P2DepartmentCreatedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("corehr.department.created_v1")) {
                throw new EventTypeAlreadyHasHandlerException("corehr.department.created_v1");
            }
            this.eventType2EventHandler.put("corehr.department.created_v1", handler);
            return this;
        }

        public Builder onP2DepartmentDeletedV1(CorehrService.P2DepartmentDeletedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("corehr.department.deleted_v1")) {
                throw new EventTypeAlreadyHasHandlerException("corehr.department.deleted_v1");
            }
            this.eventType2EventHandler.put("corehr.department.deleted_v1", handler);
            return this;
        }

        public Builder onP2DepartmentUpdatedV1(CorehrService.P2DepartmentUpdatedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("corehr.department.updated_v1")) {
                throw new EventTypeAlreadyHasHandlerException("corehr.department.updated_v1");
            }
            this.eventType2EventHandler.put("corehr.department.updated_v1", handler);
            return this;
        }

        public Builder onP2EmploymentConvertedV1(CorehrService.P2EmploymentConvertedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("corehr.employment.converted_v1")) {
                throw new EventTypeAlreadyHasHandlerException("corehr.employment.converted_v1");
            }
            this.eventType2EventHandler.put("corehr.employment.converted_v1", handler);
            return this;
        }

        public Builder onP2EmploymentCreatedV1(CorehrService.P2EmploymentCreatedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("corehr.employment.created_v1")) {
                throw new EventTypeAlreadyHasHandlerException("corehr.employment.created_v1");
            }
            this.eventType2EventHandler.put("corehr.employment.created_v1", handler);
            return this;
        }

        public Builder onP2EmploymentDeletedV1(CorehrService.P2EmploymentDeletedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("corehr.employment.deleted_v1")) {
                throw new EventTypeAlreadyHasHandlerException("corehr.employment.deleted_v1");
            }
            this.eventType2EventHandler.put("corehr.employment.deleted_v1", handler);
            return this;
        }

        public Builder onP2EmploymentResignedV1(CorehrService.P2EmploymentResignedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("corehr.employment.resigned_v1")) {
                throw new EventTypeAlreadyHasHandlerException("corehr.employment.resigned_v1");
            }
            this.eventType2EventHandler.put("corehr.employment.resigned_v1", handler);
            return this;
        }

        public Builder onP2EmploymentUpdatedV1(CorehrService.P2EmploymentUpdatedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("corehr.employment.updated_v1")) {
                throw new EventTypeAlreadyHasHandlerException("corehr.employment.updated_v1");
            }
            this.eventType2EventHandler.put("corehr.employment.updated_v1", handler);
            return this;
        }

        public Builder onP2JobCreatedV1(CorehrService.P2JobCreatedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("corehr.job.created_v1")) {
                throw new EventTypeAlreadyHasHandlerException("corehr.job.created_v1");
            }
            this.eventType2EventHandler.put("corehr.job.created_v1", handler);
            return this;
        }

        public Builder onP2JobDeletedV1(CorehrService.P2JobDeletedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("corehr.job.deleted_v1")) {
                throw new EventTypeAlreadyHasHandlerException("corehr.job.deleted_v1");
            }
            this.eventType2EventHandler.put("corehr.job.deleted_v1", handler);
            return this;
        }

        public Builder onP2JobUpdatedV1(CorehrService.P2JobUpdatedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("corehr.job.updated_v1")) {
                throw new EventTypeAlreadyHasHandlerException("corehr.job.updated_v1");
            }
            this.eventType2EventHandler.put("corehr.job.updated_v1", handler);
            return this;
        }

        public Builder onP2JobChangeUpdatedV1(CorehrService.P2JobChangeUpdatedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("corehr.job_change.updated_v1")) {
                throw new EventTypeAlreadyHasHandlerException("corehr.job_change.updated_v1");
            }
            this.eventType2EventHandler.put("corehr.job_change.updated_v1", handler);
            return this;
        }

        public Builder onP2JobDataChangedV1(CorehrService.P2JobDataChangedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("corehr.job_data.changed_v1")) {
                throw new EventTypeAlreadyHasHandlerException("corehr.job_data.changed_v1");
            }
            this.eventType2EventHandler.put("corehr.job_data.changed_v1", handler);
            return this;
        }

        public Builder onP2JobDataCreatedV1(CorehrService.P2JobDataCreatedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("corehr.job_data.created_v1")) {
                throw new EventTypeAlreadyHasHandlerException("corehr.job_data.created_v1");
            }
            this.eventType2EventHandler.put("corehr.job_data.created_v1", handler);
            return this;
        }

        public Builder onP2JobDataDeletedV1(CorehrService.P2JobDataDeletedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("corehr.job_data.deleted_v1")) {
                throw new EventTypeAlreadyHasHandlerException("corehr.job_data.deleted_v1");
            }
            this.eventType2EventHandler.put("corehr.job_data.deleted_v1", handler);
            return this;
        }

        public Builder onP2JobDataEmployedV1(CorehrService.P2JobDataEmployedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("corehr.job_data.employed_v1")) {
                throw new EventTypeAlreadyHasHandlerException("corehr.job_data.employed_v1");
            }
            this.eventType2EventHandler.put("corehr.job_data.employed_v1", handler);
            return this;
        }

        public Builder onP2JobDataUpdatedV1(CorehrService.P2JobDataUpdatedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("corehr.job_data.updated_v1")) {
                throw new EventTypeAlreadyHasHandlerException("corehr.job_data.updated_v1");
            }
            this.eventType2EventHandler.put("corehr.job_data.updated_v1", handler);
            return this;
        }

        public Builder onP2OffboardingUpdatedV1(CorehrService.P2OffboardingUpdatedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("corehr.offboarding.updated_v1")) {
                throw new EventTypeAlreadyHasHandlerException("corehr.offboarding.updated_v1");
            }
            this.eventType2EventHandler.put("corehr.offboarding.updated_v1", handler);
            return this;
        }

        public Builder onP2OrgRoleAuthorizationUpdatedV1(CorehrService.P2OrgRoleAuthorizationUpdatedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("corehr.org_role_authorization.updated_v1")) {
                throw new EventTypeAlreadyHasHandlerException("corehr.org_role_authorization.updated_v1");
            }
            this.eventType2EventHandler.put("corehr.org_role_authorization.updated_v1", handler);
            return this;
        }

        public Builder onP2PersonCreatedV1(CorehrService.P2PersonCreatedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("corehr.person.created_v1")) {
                throw new EventTypeAlreadyHasHandlerException("corehr.person.created_v1");
            }
            this.eventType2EventHandler.put("corehr.person.created_v1", handler);
            return this;
        }

        public Builder onP2PersonDeletedV1(CorehrService.P2PersonDeletedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("corehr.person.deleted_v1")) {
                throw new EventTypeAlreadyHasHandlerException("corehr.person.deleted_v1");
            }
            this.eventType2EventHandler.put("corehr.person.deleted_v1", handler);
            return this;
        }

        public Builder onP2PersonUpdatedV1(CorehrService.P2PersonUpdatedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("corehr.person.updated_v1")) {
                throw new EventTypeAlreadyHasHandlerException("corehr.person.updated_v1");
            }
            this.eventType2EventHandler.put("corehr.person.updated_v1", handler);
            return this;
        }

        public Builder onP2PreHireUpdatedV1(CorehrService.P2PreHireUpdatedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("corehr.pre_hire.updated_v1")) {
                throw new EventTypeAlreadyHasHandlerException("corehr.pre_hire.updated_v1");
            }
            this.eventType2EventHandler.put("corehr.pre_hire.updated_v1", handler);
            return this;
        }

        public Builder onP2ApprovalGroupsUpdatedV2(CorehrService.P2ApprovalGroupsUpdatedV2Handler handler) {
            if (this.eventType2EventHandler.containsKey("corehr.approval_groups.updated_v2")) {
                throw new EventTypeAlreadyHasHandlerException("corehr.approval_groups.updated_v2");
            }
            this.eventType2EventHandler.put("corehr.approval_groups.updated_v2", handler);
            return this;
        }

        public Builder onP2CompanyCreatedV2(CorehrService.P2CompanyCreatedV2Handler handler) {
            if (this.eventType2EventHandler.containsKey("corehr.company.created_v2")) {
                throw new EventTypeAlreadyHasHandlerException("corehr.company.created_v2");
            }
            this.eventType2EventHandler.put("corehr.company.created_v2", handler);
            return this;
        }

        public Builder onP2CompanyDeletedV2(CorehrService.P2CompanyDeletedV2Handler handler) {
            if (this.eventType2EventHandler.containsKey("corehr.company.deleted_v2")) {
                throw new EventTypeAlreadyHasHandlerException("corehr.company.deleted_v2");
            }
            this.eventType2EventHandler.put("corehr.company.deleted_v2", handler);
            return this;
        }

        public Builder onP2CompanyUpdatedV2(CorehrService.P2CompanyUpdatedV2Handler handler) {
            if (this.eventType2EventHandler.containsKey("corehr.company.updated_v2")) {
                throw new EventTypeAlreadyHasHandlerException("corehr.company.updated_v2");
            }
            this.eventType2EventHandler.put("corehr.company.updated_v2", handler);
            return this;
        }

        public Builder onP2CostCenterCreatedV2(CorehrService.P2CostCenterCreatedV2Handler handler) {
            if (this.eventType2EventHandler.containsKey("corehr.cost_center.created_v2")) {
                throw new EventTypeAlreadyHasHandlerException("corehr.cost_center.created_v2");
            }
            this.eventType2EventHandler.put("corehr.cost_center.created_v2", handler);
            return this;
        }

        public Builder onP2CostCenterDeletedV2(CorehrService.P2CostCenterDeletedV2Handler handler) {
            if (this.eventType2EventHandler.containsKey("corehr.cost_center.deleted_v2")) {
                throw new EventTypeAlreadyHasHandlerException("corehr.cost_center.deleted_v2");
            }
            this.eventType2EventHandler.put("corehr.cost_center.deleted_v2", handler);
            return this;
        }

        public Builder onP2CostCenterUpdatedV2(CorehrService.P2CostCenterUpdatedV2Handler handler) {
            if (this.eventType2EventHandler.containsKey("corehr.cost_center.updated_v2")) {
                throw new EventTypeAlreadyHasHandlerException("corehr.cost_center.updated_v2");
            }
            this.eventType2EventHandler.put("corehr.cost_center.updated_v2", handler);
            return this;
        }

        public Builder onP2CustomOrgCreatedV2(CorehrService.P2CustomOrgCreatedV2Handler handler) {
            if (this.eventType2EventHandler.containsKey("corehr.custom_org.created_v2")) {
                throw new EventTypeAlreadyHasHandlerException("corehr.custom_org.created_v2");
            }
            this.eventType2EventHandler.put("corehr.custom_org.created_v2", handler);
            return this;
        }

        public Builder onP2CustomOrgDeletedV2(CorehrService.P2CustomOrgDeletedV2Handler handler) {
            if (this.eventType2EventHandler.containsKey("corehr.custom_org.deleted_v2")) {
                throw new EventTypeAlreadyHasHandlerException("corehr.custom_org.deleted_v2");
            }
            this.eventType2EventHandler.put("corehr.custom_org.deleted_v2", handler);
            return this;
        }

        public Builder onP2CustomOrgUpdatedV2(CorehrService.P2CustomOrgUpdatedV2Handler handler) {
            if (this.eventType2EventHandler.containsKey("corehr.custom_org.updated_v2")) {
                throw new EventTypeAlreadyHasHandlerException("corehr.custom_org.updated_v2");
            }
            this.eventType2EventHandler.put("corehr.custom_org.updated_v2", handler);
            return this;
        }

        public Builder onP2DepartmentCreatedV2(CorehrService.P2DepartmentCreatedV2Handler handler) {
            if (this.eventType2EventHandler.containsKey("corehr.department.created_v2")) {
                throw new EventTypeAlreadyHasHandlerException("corehr.department.created_v2");
            }
            this.eventType2EventHandler.put("corehr.department.created_v2", handler);
            return this;
        }

        public Builder onP2DepartmentUpdatedV2(CorehrService.P2DepartmentUpdatedV2Handler handler) {
            if (this.eventType2EventHandler.containsKey("corehr.department.updated_v2")) {
                throw new EventTypeAlreadyHasHandlerException("corehr.department.updated_v2");
            }
            this.eventType2EventHandler.put("corehr.department.updated_v2", handler);
            return this;
        }

        public Builder onP2EmployeeDomainEventV2(CorehrService.P2EmployeeDomainEventV2Handler handler) {
            if (this.eventType2EventHandler.containsKey("corehr.employee.domain_event_v2")) {
                throw new EventTypeAlreadyHasHandlerException("corehr.employee.domain_event_v2");
            }
            this.eventType2EventHandler.put("corehr.employee.domain_event_v2", handler);
            return this;
        }

        public Builder onP2JobChangeStatusUpdatedV2(CorehrService.P2JobChangeStatusUpdatedV2Handler handler) {
            if (this.eventType2EventHandler.containsKey("corehr.job_change.status_updated_v2")) {
                throw new EventTypeAlreadyHasHandlerException("corehr.job_change.status_updated_v2");
            }
            this.eventType2EventHandler.put("corehr.job_change.status_updated_v2", handler);
            return this;
        }

        public Builder onP2JobChangeUpdatedV2(CorehrService.P2JobChangeUpdatedV2Handler handler) {
            if (this.eventType2EventHandler.containsKey("corehr.job_change.updated_v2")) {
                throw new EventTypeAlreadyHasHandlerException("corehr.job_change.updated_v2");
            }
            this.eventType2EventHandler.put("corehr.job_change.updated_v2", handler);
            return this;
        }

        public Builder onP2JobFamilyCreatedV2(CorehrService.P2JobFamilyCreatedV2Handler handler) {
            if (this.eventType2EventHandler.containsKey("corehr.job_family.created_v2")) {
                throw new EventTypeAlreadyHasHandlerException("corehr.job_family.created_v2");
            }
            this.eventType2EventHandler.put("corehr.job_family.created_v2", handler);
            return this;
        }

        public Builder onP2JobFamilyDeletedV2(CorehrService.P2JobFamilyDeletedV2Handler handler) {
            if (this.eventType2EventHandler.containsKey("corehr.job_family.deleted_v2")) {
                throw new EventTypeAlreadyHasHandlerException("corehr.job_family.deleted_v2");
            }
            this.eventType2EventHandler.put("corehr.job_family.deleted_v2", handler);
            return this;
        }

        public Builder onP2JobFamilyUpdatedV2(CorehrService.P2JobFamilyUpdatedV2Handler handler) {
            if (this.eventType2EventHandler.containsKey("corehr.job_family.updated_v2")) {
                throw new EventTypeAlreadyHasHandlerException("corehr.job_family.updated_v2");
            }
            this.eventType2EventHandler.put("corehr.job_family.updated_v2", handler);
            return this;
        }

        public Builder onP2JobGradeCreatedV2(CorehrService.P2JobGradeCreatedV2Handler handler) {
            if (this.eventType2EventHandler.containsKey("corehr.job_grade.created_v2")) {
                throw new EventTypeAlreadyHasHandlerException("corehr.job_grade.created_v2");
            }
            this.eventType2EventHandler.put("corehr.job_grade.created_v2", handler);
            return this;
        }

        public Builder onP2JobGradeDeletedV2(CorehrService.P2JobGradeDeletedV2Handler handler) {
            if (this.eventType2EventHandler.containsKey("corehr.job_grade.deleted_v2")) {
                throw new EventTypeAlreadyHasHandlerException("corehr.job_grade.deleted_v2");
            }
            this.eventType2EventHandler.put("corehr.job_grade.deleted_v2", handler);
            return this;
        }

        public Builder onP2JobGradeUpdatedV2(CorehrService.P2JobGradeUpdatedV2Handler handler) {
            if (this.eventType2EventHandler.containsKey("corehr.job_grade.updated_v2")) {
                throw new EventTypeAlreadyHasHandlerException("corehr.job_grade.updated_v2");
            }
            this.eventType2EventHandler.put("corehr.job_grade.updated_v2", handler);
            return this;
        }

        public Builder onP2JobLevelCreatedV2(CorehrService.P2JobLevelCreatedV2Handler handler) {
            if (this.eventType2EventHandler.containsKey("corehr.job_level.created_v2")) {
                throw new EventTypeAlreadyHasHandlerException("corehr.job_level.created_v2");
            }
            this.eventType2EventHandler.put("corehr.job_level.created_v2", handler);
            return this;
        }

        public Builder onP2JobLevelDeletedV2(CorehrService.P2JobLevelDeletedV2Handler handler) {
            if (this.eventType2EventHandler.containsKey("corehr.job_level.deleted_v2")) {
                throw new EventTypeAlreadyHasHandlerException("corehr.job_level.deleted_v2");
            }
            this.eventType2EventHandler.put("corehr.job_level.deleted_v2", handler);
            return this;
        }

        public Builder onP2JobLevelUpdatedV2(CorehrService.P2JobLevelUpdatedV2Handler handler) {
            if (this.eventType2EventHandler.containsKey("corehr.job_level.updated_v2")) {
                throw new EventTypeAlreadyHasHandlerException("corehr.job_level.updated_v2");
            }
            this.eventType2EventHandler.put("corehr.job_level.updated_v2", handler);
            return this;
        }

        public Builder onP2LocationCreatedV2(CorehrService.P2LocationCreatedV2Handler handler) {
            if (this.eventType2EventHandler.containsKey("corehr.location.created_v2")) {
                throw new EventTypeAlreadyHasHandlerException("corehr.location.created_v2");
            }
            this.eventType2EventHandler.put("corehr.location.created_v2", handler);
            return this;
        }

        public Builder onP2LocationDeletedV2(CorehrService.P2LocationDeletedV2Handler handler) {
            if (this.eventType2EventHandler.containsKey("corehr.location.deleted_v2")) {
                throw new EventTypeAlreadyHasHandlerException("corehr.location.deleted_v2");
            }
            this.eventType2EventHandler.put("corehr.location.deleted_v2", handler);
            return this;
        }

        public Builder onP2LocationUpdatedV2(CorehrService.P2LocationUpdatedV2Handler handler) {
            if (this.eventType2EventHandler.containsKey("corehr.location.updated_v2")) {
                throw new EventTypeAlreadyHasHandlerException("corehr.location.updated_v2");
            }
            this.eventType2EventHandler.put("corehr.location.updated_v2", handler);
            return this;
        }

        public Builder onP2OffboardingChecklistUpdatedV2(CorehrService.P2OffboardingChecklistUpdatedV2Handler handler) {
            if (this.eventType2EventHandler.containsKey("corehr.offboarding.checklist_updated_v2")) {
                throw new EventTypeAlreadyHasHandlerException("corehr.offboarding.checklist_updated_v2");
            }
            this.eventType2EventHandler.put("corehr.offboarding.checklist_updated_v2", handler);
            return this;
        }

        public Builder onP2OffboardingStatusUpdatedV2(CorehrService.P2OffboardingStatusUpdatedV2Handler handler) {
            if (this.eventType2EventHandler.containsKey("corehr.offboarding.status_updated_v2")) {
                throw new EventTypeAlreadyHasHandlerException("corehr.offboarding.status_updated_v2");
            }
            this.eventType2EventHandler.put("corehr.offboarding.status_updated_v2", handler);
            return this;
        }

        public Builder onP2OffboardingUpdatedV2(CorehrService.P2OffboardingUpdatedV2Handler handler) {
            if (this.eventType2EventHandler.containsKey("corehr.offboarding.updated_v2")) {
                throw new EventTypeAlreadyHasHandlerException("corehr.offboarding.updated_v2");
            }
            this.eventType2EventHandler.put("corehr.offboarding.updated_v2", handler);
            return this;
        }

        public Builder onP2PreHireOnboardingTaskChangedV2(CorehrService.P2PreHireOnboardingTaskChangedV2Handler handler) {
            if (this.eventType2EventHandler.containsKey("corehr.pre_hire.onboarding_task_changed_v2")) {
                throw new EventTypeAlreadyHasHandlerException("corehr.pre_hire.onboarding_task_changed_v2");
            }
            this.eventType2EventHandler.put("corehr.pre_hire.onboarding_task_changed_v2", handler);
            return this;
        }

        public Builder onP2ProbationUpdatedV2(CorehrService.P2ProbationUpdatedV2Handler handler) {
            if (this.eventType2EventHandler.containsKey("corehr.probation.updated_v2")) {
                throw new EventTypeAlreadyHasHandlerException("corehr.probation.updated_v2");
            }
            this.eventType2EventHandler.put("corehr.probation.updated_v2", handler);
            return this;
        }

        public Builder onP2ProcessUpdatedV2(CorehrService.P2ProcessUpdatedV2Handler handler) {
            if (this.eventType2EventHandler.containsKey("corehr.process.updated_v2")) {
                throw new EventTypeAlreadyHasHandlerException("corehr.process.updated_v2");
            }
            this.eventType2EventHandler.put("corehr.process.updated_v2", handler);
            return this;
        }

        public Builder onP2ProcessApproverUpdatedV2(CorehrService.P2ProcessApproverUpdatedV2Handler handler) {
            if (this.eventType2EventHandler.containsKey("corehr.process.approver.updated_v2")) {
                throw new EventTypeAlreadyHasHandlerException("corehr.process.approver.updated_v2");
            }
            this.eventType2EventHandler.put("corehr.process.approver.updated_v2", handler);
            return this;
        }

        public Builder onP2ProcessCcUpdatedV2(CorehrService.P2ProcessCcUpdatedV2Handler handler) {
            if (this.eventType2EventHandler.containsKey("corehr.process.cc.updated_v2")) {
                throw new EventTypeAlreadyHasHandlerException("corehr.process.cc.updated_v2");
            }
            this.eventType2EventHandler.put("corehr.process.cc.updated_v2", handler);
            return this;
        }

        public Builder onP2ProcessNodeUpdatedV2(CorehrService.P2ProcessNodeUpdatedV2Handler handler) {
            if (this.eventType2EventHandler.containsKey("corehr.process.node.updated_v2")) {
                throw new EventTypeAlreadyHasHandlerException("corehr.process.node.updated_v2");
            }
            this.eventType2EventHandler.put("corehr.process.node.updated_v2", handler);
            return this;
        }

        public Builder onP2ProcessStatusUpdateV2(CorehrService.P2ProcessStatusUpdateV2Handler handler) {
            if (this.eventType2EventHandler.containsKey("corehr.process.status.update_v2")) {
                throw new EventTypeAlreadyHasHandlerException("corehr.process.status.update_v2");
            }
            this.eventType2EventHandler.put("corehr.process.status.update_v2", handler);
            return this;
        }

        public Builder onP2FileBitableFieldChangedV1(DriveService.P2FileBitableFieldChangedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("drive.file.bitable_field_changed_v1")) {
                throw new EventTypeAlreadyHasHandlerException("drive.file.bitable_field_changed_v1");
            }
            this.eventType2EventHandler.put("drive.file.bitable_field_changed_v1", handler);
            return this;
        }

        public Builder onP2FileBitableRecordChangedV1(DriveService.P2FileBitableRecordChangedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("drive.file.bitable_record_changed_v1")) {
                throw new EventTypeAlreadyHasHandlerException("drive.file.bitable_record_changed_v1");
            }
            this.eventType2EventHandler.put("drive.file.bitable_record_changed_v1", handler);
            return this;
        }

        public Builder onP2FileCreatedInFolderV1(DriveService.P2FileCreatedInFolderV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("drive.file.created_in_folder_v1")) {
                throw new EventTypeAlreadyHasHandlerException("drive.file.created_in_folder_v1");
            }
            this.eventType2EventHandler.put("drive.file.created_in_folder_v1", handler);
            return this;
        }

        public Builder onP2FileDeletedV1(DriveService.P2FileDeletedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("drive.file.deleted_v1")) {
                throw new EventTypeAlreadyHasHandlerException("drive.file.deleted_v1");
            }
            this.eventType2EventHandler.put("drive.file.deleted_v1", handler);
            return this;
        }

        public Builder onP2FileEditV1(DriveService.P2FileEditV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("drive.file.edit_v1")) {
                throw new EventTypeAlreadyHasHandlerException("drive.file.edit_v1");
            }
            this.eventType2EventHandler.put("drive.file.edit_v1", handler);
            return this;
        }

        public Builder onP2FilePermissionMemberAddedV1(DriveService.P2FilePermissionMemberAddedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("drive.file.permission_member_added_v1")) {
                throw new EventTypeAlreadyHasHandlerException("drive.file.permission_member_added_v1");
            }
            this.eventType2EventHandler.put("drive.file.permission_member_added_v1", handler);
            return this;
        }

        public Builder onP2FilePermissionMemberAppliedV1(DriveService.P2FilePermissionMemberAppliedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("drive.file.permission_member_applied_v1")) {
                throw new EventTypeAlreadyHasHandlerException("drive.file.permission_member_applied_v1");
            }
            this.eventType2EventHandler.put("drive.file.permission_member_applied_v1", handler);
            return this;
        }

        public Builder onP2FilePermissionMemberRemovedV1(DriveService.P2FilePermissionMemberRemovedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("drive.file.permission_member_removed_v1")) {
                throw new EventTypeAlreadyHasHandlerException("drive.file.permission_member_removed_v1");
            }
            this.eventType2EventHandler.put("drive.file.permission_member_removed_v1", handler);
            return this;
        }

        public Builder onP2FileReadV1(DriveService.P2FileReadV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("drive.file.read_v1")) {
                throw new EventTypeAlreadyHasHandlerException("drive.file.read_v1");
            }
            this.eventType2EventHandler.put("drive.file.read_v1", handler);
            return this;
        }

        public Builder onP2FileTitleUpdatedV1(DriveService.P2FileTitleUpdatedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("drive.file.title_updated_v1")) {
                throw new EventTypeAlreadyHasHandlerException("drive.file.title_updated_v1");
            }
            this.eventType2EventHandler.put("drive.file.title_updated_v1", handler);
            return this;
        }

        public Builder onP2FileTrashedV1(DriveService.P2FileTrashedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("drive.file.trashed_v1")) {
                throw new EventTypeAlreadyHasHandlerException("drive.file.trashed_v1");
            }
            this.eventType2EventHandler.put("drive.file.trashed_v1", handler);
            return this;
        }

        public Builder onP2NotificationApproveV1(HelpdeskService.P2NotificationApproveV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("helpdesk.notification.approve_v1")) {
                throw new EventTypeAlreadyHasHandlerException("helpdesk.notification.approve_v1");
            }
            this.eventType2EventHandler.put("helpdesk.notification.approve_v1", handler);
            return this;
        }

        public Builder onP2TicketCreatedV1(HelpdeskService.P2TicketCreatedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("helpdesk.ticket.created_v1")) {
                throw new EventTypeAlreadyHasHandlerException("helpdesk.ticket.created_v1");
            }
            this.eventType2EventHandler.put("helpdesk.ticket.created_v1", handler);
            return this;
        }

        public Builder onP2TicketUpdatedV1(HelpdeskService.P2TicketUpdatedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("helpdesk.ticket.updated_v1")) {
                throw new EventTypeAlreadyHasHandlerException("helpdesk.ticket.updated_v1");
            }
            this.eventType2EventHandler.put("helpdesk.ticket.updated_v1", handler);
            return this;
        }

        public Builder onP2TicketMessageCreatedV1(HelpdeskService.P2TicketMessageCreatedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("helpdesk.ticket_message.created_v1")) {
                throw new EventTypeAlreadyHasHandlerException("helpdesk.ticket_message.created_v1");
            }
            this.eventType2EventHandler.put("helpdesk.ticket_message.created_v1", handler);
            return this;
        }

        public Builder onP2ApplicationDeletedV1(HireService.P2ApplicationDeletedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("hire.application.deleted_v1")) {
                throw new EventTypeAlreadyHasHandlerException("hire.application.deleted_v1");
            }
            this.eventType2EventHandler.put("hire.application.deleted_v1", handler);
            return this;
        }

        public Builder onP2ApplicationStageChangedV1(HireService.P2ApplicationStageChangedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("hire.application.stage_changed_v1")) {
                throw new EventTypeAlreadyHasHandlerException("hire.application.stage_changed_v1");
            }
            this.eventType2EventHandler.put("hire.application.stage_changed_v1", handler);
            return this;
        }

        public Builder onP2EcoAccountCreatedV1(HireService.P2EcoAccountCreatedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("hire.eco_account.created_v1")) {
                throw new EventTypeAlreadyHasHandlerException("hire.eco_account.created_v1");
            }
            this.eventType2EventHandler.put("hire.eco_account.created_v1", handler);
            return this;
        }

        public Builder onP2EcoBackgroundCheckCanceledV1(HireService.P2EcoBackgroundCheckCanceledV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("hire.eco_background_check.canceled_v1")) {
                throw new EventTypeAlreadyHasHandlerException("hire.eco_background_check.canceled_v1");
            }
            this.eventType2EventHandler.put("hire.eco_background_check.canceled_v1", handler);
            return this;
        }

        public Builder onP2EcoBackgroundCheckCreatedV1(HireService.P2EcoBackgroundCheckCreatedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("hire.eco_background_check.created_v1")) {
                throw new EventTypeAlreadyHasHandlerException("hire.eco_background_check.created_v1");
            }
            this.eventType2EventHandler.put("hire.eco_background_check.created_v1", handler);
            return this;
        }

        public Builder onP2EcoExamCreatedV1(HireService.P2EcoExamCreatedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("hire.eco_exam.created_v1")) {
                throw new EventTypeAlreadyHasHandlerException("hire.eco_exam.created_v1");
            }
            this.eventType2EventHandler.put("hire.eco_exam.created_v1", handler);
            return this;
        }

        public Builder onP2EhrImportTaskImportedV1(HireService.P2EhrImportTaskImportedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("hire.ehr_import_task.imported_v1")) {
                throw new EventTypeAlreadyHasHandlerException("hire.ehr_import_task.imported_v1");
            }
            this.eventType2EventHandler.put("hire.ehr_import_task.imported_v1", handler);
            return this;
        }

        public Builder onP2EhrImportTaskForInternshipOfferImportedV1(HireService.P2EhrImportTaskForInternshipOfferImportedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("hire.ehr_import_task_for_internship_offer.imported_v1")) {
                throw new EventTypeAlreadyHasHandlerException("hire.ehr_import_task_for_internship_offer.imported_v1");
            }
            this.eventType2EventHandler.put("hire.ehr_import_task_for_internship_offer.imported_v1", handler);
            return this;
        }

        public Builder onP2OfferStatusChangedV1(HireService.P2OfferStatusChangedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("hire.offer.status_changed_v1")) {
                throw new EventTypeAlreadyHasHandlerException("hire.offer.status_changed_v1");
            }
            this.eventType2EventHandler.put("hire.offer.status_changed_v1", handler);
            return this;
        }

        public Builder onP2ReferralAccountAssetsUpdateV1(HireService.P2ReferralAccountAssetsUpdateV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("hire.referral_account.assets_update_v1")) {
                throw new EventTypeAlreadyHasHandlerException("hire.referral_account.assets_update_v1");
            }
            this.eventType2EventHandler.put("hire.referral_account.assets_update_v1", handler);
            return this;
        }

        public Builder onP2TalentDeletedV1(HireService.P2TalentDeletedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("hire.talent.deleted_v1")) {
                throw new EventTypeAlreadyHasHandlerException("hire.talent.deleted_v1");
            }
            this.eventType2EventHandler.put("hire.talent.deleted_v1", handler);
            return this;
        }

        public Builder onP2TalentTagSubscriptionV1(HireService.P2TalentTagSubscriptionV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("hire.talent.tag_subscription_v1")) {
                throw new EventTypeAlreadyHasHandlerException("hire.talent.tag_subscription_v1");
            }
            this.eventType2EventHandler.put("hire.talent.tag_subscription_v1", handler);
            return this;
        }

        public Builder onP2ChatDisbandedV1(ImService.P2ChatDisbandedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("im.chat.disbanded_v1")) {
                throw new EventTypeAlreadyHasHandlerException("im.chat.disbanded_v1");
            }
            this.eventType2EventHandler.put("im.chat.disbanded_v1", handler);
            return this;
        }

        public Builder onP2ChatUpdatedV1(ImService.P2ChatUpdatedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("im.chat.updated_v1")) {
                throw new EventTypeAlreadyHasHandlerException("im.chat.updated_v1");
            }
            this.eventType2EventHandler.put("im.chat.updated_v1", handler);
            return this;
        }

        public Builder onP2ChatAccessEventBotP2pChatEnteredV1(ImService.P2ChatAccessEventBotP2pChatEnteredV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("im.chat.access_event.bot_p2p_chat_entered_v1")) {
                throw new EventTypeAlreadyHasHandlerException("im.chat.access_event.bot_p2p_chat_entered_v1");
            }
            this.eventType2EventHandler.put("im.chat.access_event.bot_p2p_chat_entered_v1", handler);
            return this;
        }

        public Builder onP2ChatMemberBotAddedV1(ImService.P2ChatMemberBotAddedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("im.chat.member.bot.added_v1")) {
                throw new EventTypeAlreadyHasHandlerException("im.chat.member.bot.added_v1");
            }
            this.eventType2EventHandler.put("im.chat.member.bot.added_v1", handler);
            return this;
        }

        public Builder onP2ChatMemberBotDeletedV1(ImService.P2ChatMemberBotDeletedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("im.chat.member.bot.deleted_v1")) {
                throw new EventTypeAlreadyHasHandlerException("im.chat.member.bot.deleted_v1");
            }
            this.eventType2EventHandler.put("im.chat.member.bot.deleted_v1", handler);
            return this;
        }

        public Builder onP2ChatMemberUserAddedV1(ImService.P2ChatMemberUserAddedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("im.chat.member.user.added_v1")) {
                throw new EventTypeAlreadyHasHandlerException("im.chat.member.user.added_v1");
            }
            this.eventType2EventHandler.put("im.chat.member.user.added_v1", handler);
            return this;
        }

        public Builder onP2ChatMemberUserDeletedV1(ImService.P2ChatMemberUserDeletedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("im.chat.member.user.deleted_v1")) {
                throw new EventTypeAlreadyHasHandlerException("im.chat.member.user.deleted_v1");
            }
            this.eventType2EventHandler.put("im.chat.member.user.deleted_v1", handler);
            return this;
        }

        public Builder onP2ChatMemberUserWithdrawnV1(ImService.P2ChatMemberUserWithdrawnV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("im.chat.member.user.withdrawn_v1")) {
                throw new EventTypeAlreadyHasHandlerException("im.chat.member.user.withdrawn_v1");
            }
            this.eventType2EventHandler.put("im.chat.member.user.withdrawn_v1", handler);
            return this;
        }

        public Builder onP2MessageReadV1(ImService.P2MessageReadV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("im.message.message_read_v1")) {
                throw new EventTypeAlreadyHasHandlerException("im.message.message_read_v1");
            }
            this.eventType2EventHandler.put("im.message.message_read_v1", handler);
            return this;
        }

        public Builder onP2MessageRecalledV1(ImService.P2MessageRecalledV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("im.message.recalled_v1")) {
                throw new EventTypeAlreadyHasHandlerException("im.message.recalled_v1");
            }
            this.eventType2EventHandler.put("im.message.recalled_v1", handler);
            return this;
        }

        public Builder onP2MessageReceiveV1(ImService.P2MessageReceiveV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("im.message.receive_v1")) {
                throw new EventTypeAlreadyHasHandlerException("im.message.receive_v1");
            }
            this.eventType2EventHandler.put("im.message.receive_v1", handler);
            return this;
        }

        public Builder onP2MessageReactionCreatedV1(ImService.P2MessageReactionCreatedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("im.message.reaction.created_v1")) {
                throw new EventTypeAlreadyHasHandlerException("im.message.reaction.created_v1");
            }
            this.eventType2EventHandler.put("im.message.reaction.created_v1", handler);
            return this;
        }

        public Builder onP2MessageReactionDeletedV1(ImService.P2MessageReactionDeletedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("im.message.reaction.deleted_v1")) {
                throw new EventTypeAlreadyHasHandlerException("im.message.reaction.deleted_v1");
            }
            this.eventType2EventHandler.put("im.message.reaction.deleted_v1", handler);
            return this;
        }

        public Builder onP2UserMailboxEventMessageReceivedV1(MailService.P2UserMailboxEventMessageReceivedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("mail.user_mailbox.event.message_received_v1")) {
                throw new EventTypeAlreadyHasHandlerException("mail.user_mailbox.event.message_received_v1");
            }
            this.eventType2EventHandler.put("mail.user_mailbox.event.message_received_v1", handler);
            return this;
        }

        public Builder onP2MeetingRoomCreatedV1(MeetingRoomService.P2MeetingRoomCreatedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("meeting_room.meeting_room.created_v1")) {
                throw new EventTypeAlreadyHasHandlerException("meeting_room.meeting_room.created_v1");
            }
            this.eventType2EventHandler.put("meeting_room.meeting_room.created_v1", handler);
            return this;
        }

        public Builder onP2MeetingRoomDeletedV1(MeetingRoomService.P2MeetingRoomDeletedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("meeting_room.meeting_room.deleted_v1")) {
                throw new EventTypeAlreadyHasHandlerException("meeting_room.meeting_room.deleted_v1");
            }
            this.eventType2EventHandler.put("meeting_room.meeting_room.deleted_v1", handler);
            return this;
        }

        public Builder onP2MeetingRoomStatusChangedV1(MeetingRoomService.P2MeetingRoomStatusChangedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("meeting_room.meeting_room.status_changed_v1")) {
                throw new EventTypeAlreadyHasHandlerException("meeting_room.meeting_room.status_changed_v1");
            }
            this.eventType2EventHandler.put("meeting_room.meeting_room.status_changed_v1", handler);
            return this;
        }

        public Builder onP2MeetingRoomUpdatedV1(MeetingRoomService.P2MeetingRoomUpdatedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("meeting_room.meeting_room.updated_v1")) {
                throw new EventTypeAlreadyHasHandlerException("meeting_room.meeting_room.updated_v1");
            }
            this.eventType2EventHandler.put("meeting_room.meeting_room.updated_v1", handler);
            return this;
        }

        public Builder onP2CommentCreatedV1(MomentsService.P2CommentCreatedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("moments.comment.created_v1")) {
                throw new EventTypeAlreadyHasHandlerException("moments.comment.created_v1");
            }
            this.eventType2EventHandler.put("moments.comment.created_v1", handler);
            return this;
        }

        public Builder onP2CommentDeletedV1(MomentsService.P2CommentDeletedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("moments.comment.deleted_v1")) {
                throw new EventTypeAlreadyHasHandlerException("moments.comment.deleted_v1");
            }
            this.eventType2EventHandler.put("moments.comment.deleted_v1", handler);
            return this;
        }

        public Builder onP2PostCreatedV1(MomentsService.P2PostCreatedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("moments.post.created_v1")) {
                throw new EventTypeAlreadyHasHandlerException("moments.post.created_v1");
            }
            this.eventType2EventHandler.put("moments.post.created_v1", handler);
            return this;
        }

        public Builder onP2PostDeletedV1(MomentsService.P2PostDeletedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("moments.post.deleted_v1")) {
                throw new EventTypeAlreadyHasHandlerException("moments.post.deleted_v1");
            }
            this.eventType2EventHandler.put("moments.post.deleted_v1", handler);
            return this;
        }

        public Builder onP2PostStatisticsUpdatedV1(MomentsService.P2PostStatisticsUpdatedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("moments.post_statistics.updated_v1")) {
                throw new EventTypeAlreadyHasHandlerException("moments.post_statistics.updated_v1");
            }
            this.eventType2EventHandler.put("moments.post_statistics.updated_v1", handler);
            return this;
        }

        public Builder onP2ReactionCreatedV1(MomentsService.P2ReactionCreatedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("moments.reaction.created_v1")) {
                throw new EventTypeAlreadyHasHandlerException("moments.reaction.created_v1");
            }
            this.eventType2EventHandler.put("moments.reaction.created_v1", handler);
            return this;
        }

        public Builder onP2ReactionDeletedV1(MomentsService.P2ReactionDeletedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("moments.reaction.deleted_v1")) {
                throw new EventTypeAlreadyHasHandlerException("moments.reaction.deleted_v1");
            }
            this.eventType2EventHandler.put("moments.reaction.deleted_v1", handler);
            return this;
        }

        public Builder onP2PaymentActivityApprovedV1(PayrollService.P2PaymentActivityApprovedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("payroll.payment_activity.approved_v1")) {
                throw new EventTypeAlreadyHasHandlerException("payroll.payment_activity.approved_v1");
            }
            this.eventType2EventHandler.put("payroll.payment_activity.approved_v1", handler);
            return this;
        }

        public Builder onP2PaymentActivityStatusChangedV1(PayrollService.P2PaymentActivityStatusChangedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("payroll.payment_activity.status_changed_v1")) {
                throw new EventTypeAlreadyHasHandlerException("payroll.payment_activity.status_changed_v1");
            }
            this.eventType2EventHandler.put("payroll.payment_activity.status_changed_v1", handler);
            return this;
        }

        public Builder onP2ReviewDataChangedV2(PerformanceService.P2ReviewDataChangedV2Handler handler) {
            if (this.eventType2EventHandler.containsKey("performance.review_data.changed_v2")) {
                throw new EventTypeAlreadyHasHandlerException("performance.review_data.changed_v2");
            }
            this.eventType2EventHandler.put("performance.review_data.changed_v2", handler);
            return this;
        }

        public Builder onP2StageTaskOpenResultV2(PerformanceService.P2StageTaskOpenResultV2Handler handler) {
            if (this.eventType2EventHandler.containsKey("performance.stage_task.open_result_v2")) {
                throw new EventTypeAlreadyHasHandlerException("performance.stage_task.open_result_v2");
            }
            this.eventType2EventHandler.put("performance.stage_task.open_result_v2", handler);
            return this;
        }

        public Builder onP2TaskUpdateTenantV1(TaskService.P2TaskUpdateTenantV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("task.task.update_tenant_v1")) {
                throw new EventTypeAlreadyHasHandlerException("task.task.update_tenant_v1");
            }
            this.eventType2EventHandler.put("task.task.update_tenant_v1", handler);
            return this;
        }

        public Builder onP2TaskUpdatedV1(TaskService.P2TaskUpdatedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("task.task.updated_v1")) {
                throw new EventTypeAlreadyHasHandlerException("task.task.updated_v1");
            }
            this.eventType2EventHandler.put("task.task.updated_v1", handler);
            return this;
        }

        public Builder onP2TaskCommentUpdatedV1(TaskService.P2TaskCommentUpdatedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("task.task.comment.updated_v1")) {
                throw new EventTypeAlreadyHasHandlerException("task.task.comment.updated_v1");
            }
            this.eventType2EventHandler.put("task.task.comment.updated_v1", handler);
            return this;
        }

        public Builder onP2MeetingAllMeetingEndedV1(VcService.P2MeetingAllMeetingEndedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("vc.meeting.all_meeting_ended_v1")) {
                throw new EventTypeAlreadyHasHandlerException("vc.meeting.all_meeting_ended_v1");
            }
            this.eventType2EventHandler.put("vc.meeting.all_meeting_ended_v1", handler);
            return this;
        }

        public Builder onP2MeetingAllMeetingStartedV1(VcService.P2MeetingAllMeetingStartedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("vc.meeting.all_meeting_started_v1")) {
                throw new EventTypeAlreadyHasHandlerException("vc.meeting.all_meeting_started_v1");
            }
            this.eventType2EventHandler.put("vc.meeting.all_meeting_started_v1", handler);
            return this;
        }

        public Builder onP2MeetingJoinMeetingV1(VcService.P2MeetingJoinMeetingV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("vc.meeting.join_meeting_v1")) {
                throw new EventTypeAlreadyHasHandlerException("vc.meeting.join_meeting_v1");
            }
            this.eventType2EventHandler.put("vc.meeting.join_meeting_v1", handler);
            return this;
        }

        public Builder onP2MeetingLeaveMeetingV1(VcService.P2MeetingLeaveMeetingV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("vc.meeting.leave_meeting_v1")) {
                throw new EventTypeAlreadyHasHandlerException("vc.meeting.leave_meeting_v1");
            }
            this.eventType2EventHandler.put("vc.meeting.leave_meeting_v1", handler);
            return this;
        }

        public Builder onP2MeetingEndedV1(VcService.P2MeetingEndedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("vc.meeting.meeting_ended_v1")) {
                throw new EventTypeAlreadyHasHandlerException("vc.meeting.meeting_ended_v1");
            }
            this.eventType2EventHandler.put("vc.meeting.meeting_ended_v1", handler);
            return this;
        }

        public Builder onP2MeetingStartedV1(VcService.P2MeetingStartedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("vc.meeting.meeting_started_v1")) {
                throw new EventTypeAlreadyHasHandlerException("vc.meeting.meeting_started_v1");
            }
            this.eventType2EventHandler.put("vc.meeting.meeting_started_v1", handler);
            return this;
        }

        public Builder onP2MeetingRecordingEndedV1(VcService.P2MeetingRecordingEndedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("vc.meeting.recording_ended_v1")) {
                throw new EventTypeAlreadyHasHandlerException("vc.meeting.recording_ended_v1");
            }
            this.eventType2EventHandler.put("vc.meeting.recording_ended_v1", handler);
            return this;
        }

        public Builder onP2MeetingRecordingReadyV1(VcService.P2MeetingRecordingReadyV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("vc.meeting.recording_ready_v1")) {
                throw new EventTypeAlreadyHasHandlerException("vc.meeting.recording_ready_v1");
            }
            this.eventType2EventHandler.put("vc.meeting.recording_ready_v1", handler);
            return this;
        }

        public Builder onP2MeetingRecordingStartedV1(VcService.P2MeetingRecordingStartedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("vc.meeting.recording_started_v1")) {
                throw new EventTypeAlreadyHasHandlerException("vc.meeting.recording_started_v1");
            }
            this.eventType2EventHandler.put("vc.meeting.recording_started_v1", handler);
            return this;
        }

        public Builder onP2MeetingShareEndedV1(VcService.P2MeetingShareEndedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("vc.meeting.share_ended_v1")) {
                throw new EventTypeAlreadyHasHandlerException("vc.meeting.share_ended_v1");
            }
            this.eventType2EventHandler.put("vc.meeting.share_ended_v1", handler);
            return this;
        }

        public Builder onP2MeetingShareStartedV1(VcService.P2MeetingShareStartedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("vc.meeting.share_started_v1")) {
                throw new EventTypeAlreadyHasHandlerException("vc.meeting.share_started_v1");
            }
            this.eventType2EventHandler.put("vc.meeting.share_started_v1", handler);
            return this;
        }

        public Builder onP2ReserveConfigUpdatedV1(VcService.P2ReserveConfigUpdatedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("vc.reserve_config.updated_v1")) {
                throw new EventTypeAlreadyHasHandlerException("vc.reserve_config.updated_v1");
            }
            this.eventType2EventHandler.put("vc.reserve_config.updated_v1", handler);
            return this;
        }

        public Builder onP2RoomCreatedV1(VcService.P2RoomCreatedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("vc.room.created_v1")) {
                throw new EventTypeAlreadyHasHandlerException("vc.room.created_v1");
            }
            this.eventType2EventHandler.put("vc.room.created_v1", handler);
            return this;
        }

        public Builder onP2RoomDeletedV1(VcService.P2RoomDeletedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("vc.room.deleted_v1")) {
                throw new EventTypeAlreadyHasHandlerException("vc.room.deleted_v1");
            }
            this.eventType2EventHandler.put("vc.room.deleted_v1", handler);
            return this;
        }

        public Builder onP2RoomUpdatedV1(VcService.P2RoomUpdatedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("vc.room.updated_v1")) {
                throw new EventTypeAlreadyHasHandlerException("vc.room.updated_v1");
            }
            this.eventType2EventHandler.put("vc.room.updated_v1", handler);
            return this;
        }

        public Builder onP2RoomLevelCreatedV1(VcService.P2RoomLevelCreatedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("vc.room_level.created_v1")) {
                throw new EventTypeAlreadyHasHandlerException("vc.room_level.created_v1");
            }
            this.eventType2EventHandler.put("vc.room_level.created_v1", handler);
            return this;
        }

        public Builder onP2RoomLevelDeletedV1(VcService.P2RoomLevelDeletedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("vc.room_level.deleted_v1")) {
                throw new EventTypeAlreadyHasHandlerException("vc.room_level.deleted_v1");
            }
            this.eventType2EventHandler.put("vc.room_level.deleted_v1", handler);
            return this;
        }

        public Builder onP2RoomLevelUpdatedV1(VcService.P2RoomLevelUpdatedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("vc.room_level.updated_v1")) {
                throw new EventTypeAlreadyHasHandlerException("vc.room_level.updated_v1");
            }
            this.eventType2EventHandler.put("vc.room_level.updated_v1", handler);
            return this;
        }

        public Builder onCustomizedEvent(String eventType, CustomEventHandler handler) {
            if (this.eventType2EventHandler.containsKey(eventType)) {
                throw new EventTypeAlreadyHasHandlerException(eventType);
            }
            this.eventType2EventHandler.put(eventType, handler);
            return this;
        }

        public Builder onP1MessageReadV1(ImService.P1MessageReadV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("message_read")) {
                throw new EventTypeAlreadyHasHandlerException("message_read");
            }
            this.eventType2EventHandler.put("message_read", handler);
            return this;
        }

        public Builder onP1MessageReceivedV1(ImService.P1MessageReceivedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("message")) {
                throw new EventTypeAlreadyHasHandlerException("message");
            }
            this.eventType2EventHandler.put("message", handler);
            return this;
        }

        public Builder onP1UserChangedV3(ContactService.P1UserChangedV3Handler handler) {
            if (this.eventType2EventHandler.containsKey("user_add")) {
                throw new EventTypeAlreadyHasHandlerException("user_add");
            }
            this.eventType2EventHandler.put("user_add", handler);
            if (this.eventType2EventHandler.containsKey("user_leave")) {
                throw new EventTypeAlreadyHasHandlerException("user_leave");
            }
            this.eventType2EventHandler.put("user_leave", handler);
            if (this.eventType2EventHandler.containsKey("user_update")) {
                throw new EventTypeAlreadyHasHandlerException("user_update");
            }
            this.eventType2EventHandler.put("user_update", handler);
            return this;
        }

        public Builder onP1UserStatusChangedV3(ContactService.P1UserStatusChangedV3Handler handler) {
            if (this.eventType2EventHandler.containsKey("user_status_change")) {
                throw new EventTypeAlreadyHasHandlerException("user_status_change");
            }
            this.eventType2EventHandler.put("user_status_change", handler);
            return this;
        }

        public Builder onP1ContactScopeChangedV3(ContactService.P1ContactScopeChangedV3Handler handler) {
            if (this.eventType2EventHandler.containsKey("contact_scope_change")) {
                throw new EventTypeAlreadyHasHandlerException("contact_scope_change");
            }
            this.eventType2EventHandler.put("contact_scope_change", handler);
            return this;
        }

        public Builder onP1DepartmentChangedV3(ContactService.P1DepartmentChangedV3Handler handler) {
            if (this.eventType2EventHandler.containsKey("dept_add")) {
                throw new EventTypeAlreadyHasHandlerException("dept_add");
            }
            this.eventType2EventHandler.put("dept_add", handler);
            if (this.eventType2EventHandler.containsKey("dept_update")) {
                throw new EventTypeAlreadyHasHandlerException("dept_update");
            }
            this.eventType2EventHandler.put("dept_update", handler);
            if (this.eventType2EventHandler.containsKey("dept_delete")) {
                throw new EventTypeAlreadyHasHandlerException("dept_delete");
            }
            this.eventType2EventHandler.put("dept_delete", handler);
            return this;
        }

        public Builder onP1P2PChatCreatedV1(ImService.P1P2PChatCreatedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("p2p_chat_create")) {
                throw new EventTypeAlreadyHasHandlerException("p2p_chat_create");
            }
            this.eventType2EventHandler.put("p2p_chat_create", handler);
            return this;
        }

        public Builder onP1ThirdPartyMeetingRoomChangedV1(MeetingRoomService.P1ThirdPartyMeetingRoomChangedV1Handler handler) {
            if (this.eventType2EventHandler.containsKey("third_party_meeting_room_event_created")) {
                throw new EventTypeAlreadyHasHandlerException("third_party_meeting_room_event_created");
            }
            this.eventType2EventHandler.put("third_party_meeting_room_event_created", handler);
            if (this.eventType2EventHandler.containsKey("third_party_meeting_room_event_updated")) {
                throw new EventTypeAlreadyHasHandlerException("third_party_meeting_room_event_updated");
            }
            this.eventType2EventHandler.put("third_party_meeting_room_event_updated", handler);
            if (this.eventType2EventHandler.containsKey("third_party_meeting_room_event_deleted")) {
                throw new EventTypeAlreadyHasHandlerException("third_party_meeting_room_event_deleted");
            }
            this.eventType2EventHandler.put("third_party_meeting_room_event_deleted", handler);
            return this;
        }

        public Builder onP1LeaveApprovalV4(ApprovalService.P1LeaveApprovalV4Handler handler) {
            if (this.eventType2EventHandler.containsKey("leave_approvalV2")) {
                throw new EventTypeAlreadyHasHandlerException("leave_approvalV2");
            }
            this.eventType2EventHandler.put("leave_approvalV2", handler);
            return this;
        }

        public Builder onP1WorkApprovalV4(ApprovalService.P1WorkApprovalV4Handler handler) {
            if (this.eventType2EventHandler.containsKey("work_approval")) {
                throw new EventTypeAlreadyHasHandlerException("work_approval");
            }
            this.eventType2EventHandler.put("work_approval", handler);
            return this;
        }

        public Builder onP1ShiftApprovalV4(ApprovalService.P1ShiftApprovalV4Handler handler) {
            if (this.eventType2EventHandler.containsKey("shift_approval")) {
                throw new EventTypeAlreadyHasHandlerException("shift_approval");
            }
            this.eventType2EventHandler.put("shift_approval", handler);
            return this;
        }

        public Builder onP1RemedyApprovalV4(ApprovalService.P1RemedyApprovalV4Handler handler) {
            if (this.eventType2EventHandler.containsKey("remedy_approval")) {
                throw new EventTypeAlreadyHasHandlerException("remedy_approval");
            }
            this.eventType2EventHandler.put("remedy_approval", handler);
            return this;
        }

        public Builder onP1TripApprovalV4(ApprovalService.P1TripApprovalV4Handler handler) {
            if (this.eventType2EventHandler.containsKey("trip_approval")) {
                throw new EventTypeAlreadyHasHandlerException("trip_approval");
            }
            this.eventType2EventHandler.put("trip_approval", handler);
            return this;
        }

        public Builder onP1OutApprovalV4(ApprovalService.P1OutApprovalV4Handler handler) {
            if (this.eventType2EventHandler.containsKey("out_approval")) {
                throw new EventTypeAlreadyHasHandlerException("out_approval");
            }
            this.eventType2EventHandler.put("out_approval", handler);
            return this;
        }

        public Builder onP1AppOpenV6(ApplicationService.P1AppOpenV6Handler handler) {
            if (this.eventType2EventHandler.containsKey("app_open")) {
                throw new EventTypeAlreadyHasHandlerException("app_open");
            }
            this.eventType2EventHandler.put("app_open", handler);
            return this;
        }

        public Builder onP1AppStatusChangedV6(ApplicationService.P1AppStatusChangedV6Handler handler) {
            if (this.eventType2EventHandler.containsKey("app_status_change")) {
                throw new EventTypeAlreadyHasHandlerException("app_status_change");
            }
            this.eventType2EventHandler.put("app_status_change", handler);
            return this;
        }

        public Builder onP1OrderPaidV6(ApplicationService.P1OrderPaidV6Handler handler) {
            if (this.eventType2EventHandler.containsKey("order_paid")) {
                throw new EventTypeAlreadyHasHandlerException("order_paid");
            }
            this.eventType2EventHandler.put("order_paid", handler);
            return this;
        }

        public Builder onP1AppUninstalledV6(ApplicationService.P1AppUninstalledV6Handler handler) {
            if (this.eventType2EventHandler.containsKey("app_uninstalled")) {
                throw new EventTypeAlreadyHasHandlerException("app_uninstalled");
            }
            this.eventType2EventHandler.put("app_uninstalled", handler);
            return this;
        }

        public Builder onAppTicketEvent(CustomAppTicketEventHandler handler) {
            this.eventType2EventHandler.put("app_ticket", handler);
            return this;
        }
    }
}

