// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.attendance.v1.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.attendance.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class WorkTime {
    /**
     * 加班开始时间,时间格式为 yyyy-MM-dd HH:mm
     * <p> 示例值：2025-01-01 00:00
     */
    @SerializedName("work_start_time")
    private String workStartTime;
    /**
     * 加班结束时间,时间格式为 yyyy-MM-dd HH:mm
     * <p> 示例值：2025-01-01 00:00
     */
    @SerializedName("work_end_time")
    private String workEndTime;
    /**
     * 结算方式,overtime_pay:加班费;compensatory_leave:调休 假;records_only仅记录
     * <p> 示例值：overtime_pay
     */
    @SerializedName("settlement_type")
    private String settlementType;
    /**
     * 请求校验错误原因
     * <p> 示例值：校验没通过
     */
    @SerializedName("check_fail_reason")
    private String checkFailReason;

    // builder 开始
    public WorkTime() {
    }

    public WorkTime(Builder builder) {
        /**
         * 加班开始时间,时间格式为 yyyy-MM-dd HH:mm
         * <p> 示例值：2025-01-01 00:00
         */
        this.workStartTime = builder.workStartTime;
        /**
         * 加班结束时间,时间格式为 yyyy-MM-dd HH:mm
         * <p> 示例值：2025-01-01 00:00
         */
        this.workEndTime = builder.workEndTime;
        /**
         * 结算方式,overtime_pay:加班费;compensatory_leave:调休 假;records_only仅记录
         * <p> 示例值：overtime_pay
         */
        this.settlementType = builder.settlementType;
        /**
         * 请求校验错误原因
         * <p> 示例值：校验没通过
         */
        this.checkFailReason = builder.checkFailReason;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getWorkStartTime() {
        return this.workStartTime;
    }

    public void setWorkStartTime(String workStartTime) {
        this.workStartTime = workStartTime;
    }

    public String getWorkEndTime() {
        return this.workEndTime;
    }

    public void setWorkEndTime(String workEndTime) {
        this.workEndTime = workEndTime;
    }

    public String getSettlementType() {
        return this.settlementType;
    }

    public void setSettlementType(String settlementType) {
        this.settlementType = settlementType;
    }

    public String getCheckFailReason() {
        return this.checkFailReason;
    }

    public void setCheckFailReason(String checkFailReason) {
        this.checkFailReason = checkFailReason;
    }

    public static class Builder {
        /**
         * 加班开始时间,时间格式为 yyyy-MM-dd HH:mm
         * <p> 示例值：2025-01-01 00:00
         */
        private String workStartTime;
        /**
         * 加班结束时间,时间格式为 yyyy-MM-dd HH:mm
         * <p> 示例值：2025-01-01 00:00
         */
        private String workEndTime;
        /**
         * 结算方式,overtime_pay:加班费;compensatory_leave:调休 假;records_only仅记录
         * <p> 示例值：overtime_pay
         */
        private String settlementType;
        /**
         * 请求校验错误原因
         * <p> 示例值：校验没通过
         */
        private String checkFailReason;

        /**
         * 加班开始时间,时间格式为 yyyy-MM-dd HH:mm
         * <p> 示例值：2025-01-01 00:00
         *
         * @param workStartTime
         * @return
         */
        public Builder workStartTime(String workStartTime) {
            this.workStartTime = workStartTime;
            return this;
        }


        /**
         * 加班结束时间,时间格式为 yyyy-MM-dd HH:mm
         * <p> 示例值：2025-01-01 00:00
         *
         * @param workEndTime
         * @return
         */
        public Builder workEndTime(String workEndTime) {
            this.workEndTime = workEndTime;
            return this;
        }


        /**
         * 结算方式,overtime_pay:加班费;compensatory_leave:调休 假;records_only仅记录
         * <p> 示例值：overtime_pay
         *
         * @param settlementType
         * @return
         */
        public Builder settlementType(String settlementType) {
            this.settlementType = settlementType;
            return this;
        }


        /**
         * 请求校验错误原因
         * <p> 示例值：校验没通过
         *
         * @param checkFailReason
         * @return
         */
        public Builder checkFailReason(String checkFailReason) {
            this.checkFailReason = checkFailReason;
            return this;
        }


        public WorkTime build() {
            return new WorkTime(this);
        }
    }
}
