// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.docx.v1.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.docx.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class UpdateTablePropertyRequest {
    /**
     * 表格列宽
     * <p> 示例值：100
     */
    @SerializedName("column_width")
    private Integer columnWidth;
    /**
     * 需要修改列宽的表格列的索引
     * <p> 示例值：0
     */
    @SerializedName("column_index")
    private Integer columnIndex;
    /**
     * 设置首行为标题行
     * <p> 示例值：false
     */
    @SerializedName("header_row")
    private Boolean headerRow;
    /**
     * 设置首列为标题列
     * <p> 示例值：false
     */
    @SerializedName("header_column")
    private Boolean headerColumn;

    // builder 开始
    public UpdateTablePropertyRequest() {
    }

    public UpdateTablePropertyRequest(Builder builder) {
        /**
         * 表格列宽
         * <p> 示例值：100
         */
        this.columnWidth = builder.columnWidth;
        /**
         * 需要修改列宽的表格列的索引
         * <p> 示例值：0
         */
        this.columnIndex = builder.columnIndex;
        /**
         * 设置首行为标题行
         * <p> 示例值：false
         */
        this.headerRow = builder.headerRow;
        /**
         * 设置首列为标题列
         * <p> 示例值：false
         */
        this.headerColumn = builder.headerColumn;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Integer getColumnWidth() {
        return this.columnWidth;
    }

    public void setColumnWidth(Integer columnWidth) {
        this.columnWidth = columnWidth;
    }

    public Integer getColumnIndex() {
        return this.columnIndex;
    }

    public void setColumnIndex(Integer columnIndex) {
        this.columnIndex = columnIndex;
    }

    public Boolean getHeaderRow() {
        return this.headerRow;
    }

    public void setHeaderRow(Boolean headerRow) {
        this.headerRow = headerRow;
    }

    public Boolean getHeaderColumn() {
        return this.headerColumn;
    }

    public void setHeaderColumn(Boolean headerColumn) {
        this.headerColumn = headerColumn;
    }

    public static class Builder {
        /**
         * 表格列宽
         * <p> 示例值：100
         */
        private Integer columnWidth;
        /**
         * 需要修改列宽的表格列的索引
         * <p> 示例值：0
         */
        private Integer columnIndex;
        /**
         * 设置首行为标题行
         * <p> 示例值：false
         */
        private Boolean headerRow;
        /**
         * 设置首列为标题列
         * <p> 示例值：false
         */
        private Boolean headerColumn;

        /**
         * 表格列宽
         * <p> 示例值：100
         *
         * @param columnWidth
         * @return
         */
        public Builder columnWidth(Integer columnWidth) {
            this.columnWidth = columnWidth;
            return this;
        }


        /**
         * 需要修改列宽的表格列的索引
         * <p> 示例值：0
         *
         * @param columnIndex
         * @return
         */
        public Builder columnIndex(Integer columnIndex) {
            this.columnIndex = columnIndex;
            return this;
        }


        /**
         * 设置首行为标题行
         * <p> 示例值：false
         *
         * @param headerRow
         * @return
         */
        public Builder headerRow(Boolean headerRow) {
            this.headerRow = headerRow;
            return this;
        }


        /**
         * 设置首列为标题列
         * <p> 示例值：false
         *
         * @param headerColumn
         * @return
         */
        public Builder headerColumn(Boolean headerColumn) {
            this.headerColumn = headerColumn;
            return this;
        }


        public UpdateTablePropertyRequest build() {
            return new UpdateTablePropertyRequest(this);
        }
    }
}
