// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.performance.v2.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.performance.v2.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class Indicator {
    /**
     * 评估项 ID
     * <p> 示例值：7343513161666707459
     */
    @SerializedName("id")
    private String id;
    /**
     * 评估项名称
     * <p> 示例值：
     */
    @SerializedName("name")
    private I18n name;
    /**
     * 评估项类型
     * <p> 示例值：plus
     */
    @SerializedName("type")
    private String type;
    /**
     * 评估项等级列表
     * <p> 示例值：
     */
    @SerializedName("options")
    private IndicatorOption[] options;

    // builder 开始
    public Indicator() {
    }

    public Indicator(Builder builder) {
        /**
         * 评估项 ID
         * <p> 示例值：7343513161666707459
         */
        this.id = builder.id;
        /**
         * 评估项名称
         * <p> 示例值：
         */
        this.name = builder.name;
        /**
         * 评估项类型
         * <p> 示例值：plus
         */
        this.type = builder.type;
        /**
         * 评估项等级列表
         * <p> 示例值：
         */
        this.options = builder.options;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public I18n getName() {
        return this.name;
    }

    public void setName(I18n name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public IndicatorOption[] getOptions() {
        return this.options;
    }

    public void setOptions(IndicatorOption[] options) {
        this.options = options;
    }

    public static class Builder {
        /**
         * 评估项 ID
         * <p> 示例值：7343513161666707459
         */
        private String id;
        /**
         * 评估项名称
         * <p> 示例值：
         */
        private I18n name;
        /**
         * 评估项类型
         * <p> 示例值：plus
         */
        private String type;
        /**
         * 评估项等级列表
         * <p> 示例值：
         */
        private IndicatorOption[] options;

        /**
         * 评估项 ID
         * <p> 示例值：7343513161666707459
         *
         * @param id
         * @return
         */
        public Builder id(String id) {
            this.id = id;
            return this;
        }


        /**
         * 评估项名称
         * <p> 示例值：
         *
         * @param name
         * @return
         */
        public Builder name(I18n name) {
            this.name = name;
            return this;
        }


        /**
         * 评估项类型
         * <p> 示例值：plus
         *
         * @param type
         * @return
         */
        public Builder type(String type) {
            this.type = type;
            return this;
        }

        /**
         * 评估项类型
         * <p> 示例值：plus
         *
         * @param type {@link com.lark.oapi.service.performance.v2.enums.IndicatorTypeEnum}
         * @return
         */
        public Builder type(com.lark.oapi.service.performance.v2.enums.IndicatorTypeEnum type) {
            this.type = type.getValue();
            return this;
        }


        /**
         * 评估项等级列表
         * <p> 示例值：
         *
         * @param options
         * @return
         */
        public Builder options(IndicatorOption[] options) {
            this.options = options;
            return this;
        }


        public Indicator build() {
            return new Indicator(this);
        }
    }
}
