// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package com.lark.oapi.service.wiki;

import com.lark.oapi.core.Config;
import com.lark.oapi.event.IEventHandler;
import com.lark.oapi.service.wiki.v1.V1;
import com.lark.oapi.service.wiki.v1.model.*;
import com.lark.oapi.service.wiki.v2.V2;
import com.lark.oapi.service.wiki.v2.model.*;
import com.lark.oapi.service.wiki.v2.resource.Space;
import com.lark.oapi.service.wiki.v2.resource.SpaceMember;
import com.lark.oapi.service.wiki.v2.resource.SpaceNode;
import com.lark.oapi.service.wiki.v2.resource.SpaceSetting;
import com.lark.oapi.service.wiki.v2.resource.Task;

public class WikiService {
    private final V1 v1;
    private final V2 v2;
    private final Space space; // 知识空间
    private final SpaceMember spaceMember; // 空间成员
    private final SpaceNode spaceNode; // 节点
    private final SpaceSetting spaceSetting; // 空间设置
    private final Task task; // 云文档

    public WikiService(Config config) {
        this.v1 = new V1(config);
        this.v2 = new V2(config);
        this.space = new Space(config);
        this.spaceMember = new SpaceMember(config);
        this.spaceNode = new SpaceNode(config);
        this.spaceSetting = new SpaceSetting(config);
        this.task = new Task(config);
    }

    public V1 v1() {
        return v1;
    }

    public V2 v2() {
        return v2;
    }

    public Space space() {
        return space;
    }

    public SpaceMember spaceMember() {
        return spaceMember;
    }

    public SpaceNode spaceNode() {
        return spaceNode;
    }

    public SpaceSetting spaceSetting() {
        return spaceSetting;
    }

    public Task task() {
        return task;
    }
}