// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.hire.v2.model;

import com.lark.oapi.core.response.EmptyData;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class CompositeTalent {
    /**
     * ID
     * <p> 示例值：6761694410053798151
     */
    @SerializedName("talent_id")
    private String talentId;
    /**
     * 基础信息
     * <p> 示例值：
     */
    @SerializedName("basic_info")
    private CompositeTalentBasicInfo basicInfo;
    /**
     * 教育经历
     * <p> 示例值：
     */
    @SerializedName("education_list")
    private CompositeTalentEducationInfo[] educationList;
    /**
     * 工作经历
     * <p> 示例值：
     */
    @SerializedName("career_list")
    private CompositeTalentCareerInfo[] careerList;
    /**
     * 项目经历
     * <p> 示例值：
     */
    @SerializedName("project_list")
    private CompositeTalentProjectInfo[] projectList;
    /**
     * 作品集
     * <p> 示例值：
     */
    @SerializedName("works_list")
    private CompositeTalentWorksInfo[] worksList;
    /**
     * 获奖列表
     * <p> 示例值：
     */
    @SerializedName("award_list")
    private CompositeTalentAwardInfo[] awardList;
    /**
     * 语言列表
     * <p> 示例值：
     */
    @SerializedName("language_list")
    private CompositeTalentLanguageInfo[] languageList;
    /**
     * SNS列表
     * <p> 示例值：
     */
    @SerializedName("sns_list")
    private CompositeTalentSnsInfo[] snsList;
    /**
     * 简历来源
     * <p> 示例值：
     */
    @SerializedName("resume_source_list")
    private TalentResumeSource[] resumeSourceList;
    /**
     * 实习经历
     * <p> 示例值：
     */
    @SerializedName("internship_list")
    private CompositeTalentInternshipInfo[] internshipList;
    /**
     * 自定义字段
     * <p> 示例值：
     */
    @SerializedName("customized_data_list")
    private CompositeTalentCustomizedData[] customizedDataList;
    /**
     * 简历附件id列表（按照简历创建时间降序）
     * <p> 示例值：
     */
    @SerializedName("resume_attachment_id_list")
    private String[] resumeAttachmentIdList;
    /**
     * 简历附件列表（按照简历创建时间降序）
     * <p> 示例值：
     */
    @SerializedName("resume_attachment_list")
    private TalentResumeAttachment[] resumeAttachmentList;
    /**
     * 面试登记表
     * <p> 示例值：
     */
    @SerializedName("interview_registration_list")
    private TalentInterviewRegistrationSimple[] interviewRegistrationList;
    /**
     * 登记表列表
     * <p> 示例值：
     */
    @SerializedName("registration_list")
    private RegistrationBasicInfo[] registrationList;
    /**
     * 是否已入职
     * <p> 示例值：true
     */
    @SerializedName("is_onboarded")
    private Boolean isOnboarded;
    /**
     * 是否在猎头保护期
     * <p> 示例值：true
     */
    @SerializedName("is_in_agency_period")
    private Boolean isInAgencyPeriod;
    /**
     * 最高学历 参考 DegreeType 枚举
     * <p> 示例值：1
     */
    @SerializedName("top_degree")
    private Integer topDegree;
    /**
     * 人才已加入的人才库列表
     * <p> 示例值：
     */
    @SerializedName("talent_pool_id_list")
    private String[] talentPoolIdList;
    /**
     * 文件夹列表
     * <p> 示例值：
     */
    @SerializedName("talent_folder_ref_list_v2")
    private TalentFolder[] talentFolderRefListV2;
    /**
     * 标签列表
     * <p> 示例值：
     */
    @SerializedName("tag_list")
    private TalentTag[] tagList;
    /**
     * 相似人才信息
     * <p> 示例值：
     */
    @SerializedName("similar_info_v2")
    private TalentSimilar similarInfoV2;
    /**
     * 人才黑名单详情
     * <p> 示例值：
     */
    @SerializedName("block_info")
    private TalentBlock blockInfo;
    /**
     * 人才已经加入的人才库列表
     * <p> 示例值：
     */
    @SerializedName("talent_pool_ref_list_v2")
    private TalentPool[] talentPoolRefListV2;
    /**
     * 备注列表
     * <p> 示例值：
     */
    @SerializedName("note_list_v2")
    private TalentNote[] noteListV2;

    // builder 开始
    public CompositeTalent() {
    }

    public CompositeTalent(Builder builder) {
        /**
         * ID
         * <p> 示例值：6761694410053798151
         */
        this.talentId = builder.talentId;
        /**
         * 基础信息
         * <p> 示例值：
         */
        this.basicInfo = builder.basicInfo;
        /**
         * 教育经历
         * <p> 示例值：
         */
        this.educationList = builder.educationList;
        /**
         * 工作经历
         * <p> 示例值：
         */
        this.careerList = builder.careerList;
        /**
         * 项目经历
         * <p> 示例值：
         */
        this.projectList = builder.projectList;
        /**
         * 作品集
         * <p> 示例值：
         */
        this.worksList = builder.worksList;
        /**
         * 获奖列表
         * <p> 示例值：
         */
        this.awardList = builder.awardList;
        /**
         * 语言列表
         * <p> 示例值：
         */
        this.languageList = builder.languageList;
        /**
         * SNS列表
         * <p> 示例值：
         */
        this.snsList = builder.snsList;
        /**
         * 简历来源
         * <p> 示例值：
         */
        this.resumeSourceList = builder.resumeSourceList;
        /**
         * 实习经历
         * <p> 示例值：
         */
        this.internshipList = builder.internshipList;
        /**
         * 自定义字段
         * <p> 示例值：
         */
        this.customizedDataList = builder.customizedDataList;
        /**
         * 简历附件id列表（按照简历创建时间降序）
         * <p> 示例值：
         */
        this.resumeAttachmentIdList = builder.resumeAttachmentIdList;
        /**
         * 简历附件列表（按照简历创建时间降序）
         * <p> 示例值：
         */
        this.resumeAttachmentList = builder.resumeAttachmentList;
        /**
         * 面试登记表
         * <p> 示例值：
         */
        this.interviewRegistrationList = builder.interviewRegistrationList;
        /**
         * 登记表列表
         * <p> 示例值：
         */
        this.registrationList = builder.registrationList;
        /**
         * 是否已入职
         * <p> 示例值：true
         */
        this.isOnboarded = builder.isOnboarded;
        /**
         * 是否在猎头保护期
         * <p> 示例值：true
         */
        this.isInAgencyPeriod = builder.isInAgencyPeriod;
        /**
         * 最高学历 参考 DegreeType 枚举
         * <p> 示例值：1
         */
        this.topDegree = builder.topDegree;
        /**
         * 人才已加入的人才库列表
         * <p> 示例值：
         */
        this.talentPoolIdList = builder.talentPoolIdList;
        /**
         * 文件夹列表
         * <p> 示例值：
         */
        this.talentFolderRefListV2 = builder.talentFolderRefListV2;
        /**
         * 标签列表
         * <p> 示例值：
         */
        this.tagList = builder.tagList;
        /**
         * 相似人才信息
         * <p> 示例值：
         */
        this.similarInfoV2 = builder.similarInfoV2;
        /**
         * 人才黑名单详情
         * <p> 示例值：
         */
        this.blockInfo = builder.blockInfo;
        /**
         * 人才已经加入的人才库列表
         * <p> 示例值：
         */
        this.talentPoolRefListV2 = builder.talentPoolRefListV2;
        /**
         * 备注列表
         * <p> 示例值：
         */
        this.noteListV2 = builder.noteListV2;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getTalentId() {
        return this.talentId;
    }

    public void setTalentId(String talentId) {
        this.talentId = talentId;
    }

    public CompositeTalentBasicInfo getBasicInfo() {
        return this.basicInfo;
    }

    public void setBasicInfo(CompositeTalentBasicInfo basicInfo) {
        this.basicInfo = basicInfo;
    }

    public CompositeTalentEducationInfo[] getEducationList() {
        return this.educationList;
    }

    public void setEducationList(CompositeTalentEducationInfo[] educationList) {
        this.educationList = educationList;
    }

    public CompositeTalentCareerInfo[] getCareerList() {
        return this.careerList;
    }

    public void setCareerList(CompositeTalentCareerInfo[] careerList) {
        this.careerList = careerList;
    }

    public CompositeTalentProjectInfo[] getProjectList() {
        return this.projectList;
    }

    public void setProjectList(CompositeTalentProjectInfo[] projectList) {
        this.projectList = projectList;
    }

    public CompositeTalentWorksInfo[] getWorksList() {
        return this.worksList;
    }

    public void setWorksList(CompositeTalentWorksInfo[] worksList) {
        this.worksList = worksList;
    }

    public CompositeTalentAwardInfo[] getAwardList() {
        return this.awardList;
    }

    public void setAwardList(CompositeTalentAwardInfo[] awardList) {
        this.awardList = awardList;
    }

    public CompositeTalentLanguageInfo[] getLanguageList() {
        return this.languageList;
    }

    public void setLanguageList(CompositeTalentLanguageInfo[] languageList) {
        this.languageList = languageList;
    }

    public CompositeTalentSnsInfo[] getSnsList() {
        return this.snsList;
    }

    public void setSnsList(CompositeTalentSnsInfo[] snsList) {
        this.snsList = snsList;
    }

    public TalentResumeSource[] getResumeSourceList() {
        return this.resumeSourceList;
    }

    public void setResumeSourceList(TalentResumeSource[] resumeSourceList) {
        this.resumeSourceList = resumeSourceList;
    }

    public CompositeTalentInternshipInfo[] getInternshipList() {
        return this.internshipList;
    }

    public void setInternshipList(CompositeTalentInternshipInfo[] internshipList) {
        this.internshipList = internshipList;
    }

    public CompositeTalentCustomizedData[] getCustomizedDataList() {
        return this.customizedDataList;
    }

    public void setCustomizedDataList(CompositeTalentCustomizedData[] customizedDataList) {
        this.customizedDataList = customizedDataList;
    }

    public String[] getResumeAttachmentIdList() {
        return this.resumeAttachmentIdList;
    }

    public void setResumeAttachmentIdList(String[] resumeAttachmentIdList) {
        this.resumeAttachmentIdList = resumeAttachmentIdList;
    }

    public TalentResumeAttachment[] getResumeAttachmentList() {
        return this.resumeAttachmentList;
    }

    public void setResumeAttachmentList(TalentResumeAttachment[] resumeAttachmentList) {
        this.resumeAttachmentList = resumeAttachmentList;
    }

    public TalentInterviewRegistrationSimple[] getInterviewRegistrationList() {
        return this.interviewRegistrationList;
    }

    public void setInterviewRegistrationList(TalentInterviewRegistrationSimple[] interviewRegistrationList) {
        this.interviewRegistrationList = interviewRegistrationList;
    }

    public RegistrationBasicInfo[] getRegistrationList() {
        return this.registrationList;
    }

    public void setRegistrationList(RegistrationBasicInfo[] registrationList) {
        this.registrationList = registrationList;
    }

    public Boolean getIsOnboarded() {
        return this.isOnboarded;
    }

    public void setIsOnboarded(Boolean isOnboarded) {
        this.isOnboarded = isOnboarded;
    }

    public Boolean getIsInAgencyPeriod() {
        return this.isInAgencyPeriod;
    }

    public void setIsInAgencyPeriod(Boolean isInAgencyPeriod) {
        this.isInAgencyPeriod = isInAgencyPeriod;
    }

    public Integer getTopDegree() {
        return this.topDegree;
    }

    public void setTopDegree(Integer topDegree) {
        this.topDegree = topDegree;
    }

    public String[] getTalentPoolIdList() {
        return this.talentPoolIdList;
    }

    public void setTalentPoolIdList(String[] talentPoolIdList) {
        this.talentPoolIdList = talentPoolIdList;
    }

    public TalentFolder[] getTalentFolderRefListV2() {
        return this.talentFolderRefListV2;
    }

    public void setTalentFolderRefListV2(TalentFolder[] talentFolderRefListV2) {
        this.talentFolderRefListV2 = talentFolderRefListV2;
    }

    public TalentTag[] getTagList() {
        return this.tagList;
    }

    public void setTagList(TalentTag[] tagList) {
        this.tagList = tagList;
    }

    public TalentSimilar getSimilarInfoV2() {
        return this.similarInfoV2;
    }

    public void setSimilarInfoV2(TalentSimilar similarInfoV2) {
        this.similarInfoV2 = similarInfoV2;
    }

    public TalentBlock getBlockInfo() {
        return this.blockInfo;
    }

    public void setBlockInfo(TalentBlock blockInfo) {
        this.blockInfo = blockInfo;
    }

    public TalentPool[] getTalentPoolRefListV2() {
        return this.talentPoolRefListV2;
    }

    public void setTalentPoolRefListV2(TalentPool[] talentPoolRefListV2) {
        this.talentPoolRefListV2 = talentPoolRefListV2;
    }

    public TalentNote[] getNoteListV2() {
        return this.noteListV2;
    }

    public void setNoteListV2(TalentNote[] noteListV2) {
        this.noteListV2 = noteListV2;
    }

    public static class Builder {
        /**
         * ID
         * <p> 示例值：6761694410053798151
         */
        private String talentId;
        /**
         * 基础信息
         * <p> 示例值：
         */
        private CompositeTalentBasicInfo basicInfo;
        /**
         * 教育经历
         * <p> 示例值：
         */
        private CompositeTalentEducationInfo[] educationList;
        /**
         * 工作经历
         * <p> 示例值：
         */
        private CompositeTalentCareerInfo[] careerList;
        /**
         * 项目经历
         * <p> 示例值：
         */
        private CompositeTalentProjectInfo[] projectList;
        /**
         * 作品集
         * <p> 示例值：
         */
        private CompositeTalentWorksInfo[] worksList;
        /**
         * 获奖列表
         * <p> 示例值：
         */
        private CompositeTalentAwardInfo[] awardList;
        /**
         * 语言列表
         * <p> 示例值：
         */
        private CompositeTalentLanguageInfo[] languageList;
        /**
         * SNS列表
         * <p> 示例值：
         */
        private CompositeTalentSnsInfo[] snsList;
        /**
         * 简历来源
         * <p> 示例值：
         */
        private TalentResumeSource[] resumeSourceList;
        /**
         * 实习经历
         * <p> 示例值：
         */
        private CompositeTalentInternshipInfo[] internshipList;
        /**
         * 自定义字段
         * <p> 示例值：
         */
        private CompositeTalentCustomizedData[] customizedDataList;
        /**
         * 简历附件id列表（按照简历创建时间降序）
         * <p> 示例值：
         */
        private String[] resumeAttachmentIdList;
        /**
         * 简历附件列表（按照简历创建时间降序）
         * <p> 示例值：
         */
        private TalentResumeAttachment[] resumeAttachmentList;
        /**
         * 面试登记表
         * <p> 示例值：
         */
        private TalentInterviewRegistrationSimple[] interviewRegistrationList;
        /**
         * 登记表列表
         * <p> 示例值：
         */
        private RegistrationBasicInfo[] registrationList;
        /**
         * 是否已入职
         * <p> 示例值：true
         */
        private Boolean isOnboarded;
        /**
         * 是否在猎头保护期
         * <p> 示例值：true
         */
        private Boolean isInAgencyPeriod;
        /**
         * 最高学历 参考 DegreeType 枚举
         * <p> 示例值：1
         */
        private Integer topDegree;
        /**
         * 人才已加入的人才库列表
         * <p> 示例值：
         */
        private String[] talentPoolIdList;
        /**
         * 文件夹列表
         * <p> 示例值：
         */
        private TalentFolder[] talentFolderRefListV2;
        /**
         * 标签列表
         * <p> 示例值：
         */
        private TalentTag[] tagList;
        /**
         * 相似人才信息
         * <p> 示例值：
         */
        private TalentSimilar similarInfoV2;
        /**
         * 人才黑名单详情
         * <p> 示例值：
         */
        private TalentBlock blockInfo;
        /**
         * 人才已经加入的人才库列表
         * <p> 示例值：
         */
        private TalentPool[] talentPoolRefListV2;
        /**
         * 备注列表
         * <p> 示例值：
         */
        private TalentNote[] noteListV2;

        /**
         * ID
         * <p> 示例值：6761694410053798151
         *
         * @param talentId
         * @return
         */
        public Builder talentId(String talentId) {
            this.talentId = talentId;
            return this;
        }


        /**
         * 基础信息
         * <p> 示例值：
         *
         * @param basicInfo
         * @return
         */
        public Builder basicInfo(CompositeTalentBasicInfo basicInfo) {
            this.basicInfo = basicInfo;
            return this;
        }


        /**
         * 教育经历
         * <p> 示例值：
         *
         * @param educationList
         * @return
         */
        public Builder educationList(CompositeTalentEducationInfo[] educationList) {
            this.educationList = educationList;
            return this;
        }


        /**
         * 工作经历
         * <p> 示例值：
         *
         * @param careerList
         * @return
         */
        public Builder careerList(CompositeTalentCareerInfo[] careerList) {
            this.careerList = careerList;
            return this;
        }


        /**
         * 项目经历
         * <p> 示例值：
         *
         * @param projectList
         * @return
         */
        public Builder projectList(CompositeTalentProjectInfo[] projectList) {
            this.projectList = projectList;
            return this;
        }


        /**
         * 作品集
         * <p> 示例值：
         *
         * @param worksList
         * @return
         */
        public Builder worksList(CompositeTalentWorksInfo[] worksList) {
            this.worksList = worksList;
            return this;
        }


        /**
         * 获奖列表
         * <p> 示例值：
         *
         * @param awardList
         * @return
         */
        public Builder awardList(CompositeTalentAwardInfo[] awardList) {
            this.awardList = awardList;
            return this;
        }


        /**
         * 语言列表
         * <p> 示例值：
         *
         * @param languageList
         * @return
         */
        public Builder languageList(CompositeTalentLanguageInfo[] languageList) {
            this.languageList = languageList;
            return this;
        }


        /**
         * SNS列表
         * <p> 示例值：
         *
         * @param snsList
         * @return
         */
        public Builder snsList(CompositeTalentSnsInfo[] snsList) {
            this.snsList = snsList;
            return this;
        }


        /**
         * 简历来源
         * <p> 示例值：
         *
         * @param resumeSourceList
         * @return
         */
        public Builder resumeSourceList(TalentResumeSource[] resumeSourceList) {
            this.resumeSourceList = resumeSourceList;
            return this;
        }


        /**
         * 实习经历
         * <p> 示例值：
         *
         * @param internshipList
         * @return
         */
        public Builder internshipList(CompositeTalentInternshipInfo[] internshipList) {
            this.internshipList = internshipList;
            return this;
        }


        /**
         * 自定义字段
         * <p> 示例值：
         *
         * @param customizedDataList
         * @return
         */
        public Builder customizedDataList(CompositeTalentCustomizedData[] customizedDataList) {
            this.customizedDataList = customizedDataList;
            return this;
        }


        /**
         * 简历附件id列表（按照简历创建时间降序）
         * <p> 示例值：
         *
         * @param resumeAttachmentIdList
         * @return
         */
        public Builder resumeAttachmentIdList(String[] resumeAttachmentIdList) {
            this.resumeAttachmentIdList = resumeAttachmentIdList;
            return this;
        }


        /**
         * 简历附件列表（按照简历创建时间降序）
         * <p> 示例值：
         *
         * @param resumeAttachmentList
         * @return
         */
        public Builder resumeAttachmentList(TalentResumeAttachment[] resumeAttachmentList) {
            this.resumeAttachmentList = resumeAttachmentList;
            return this;
        }


        /**
         * 面试登记表
         * <p> 示例值：
         *
         * @param interviewRegistrationList
         * @return
         */
        public Builder interviewRegistrationList(TalentInterviewRegistrationSimple[] interviewRegistrationList) {
            this.interviewRegistrationList = interviewRegistrationList;
            return this;
        }


        /**
         * 登记表列表
         * <p> 示例值：
         *
         * @param registrationList
         * @return
         */
        public Builder registrationList(RegistrationBasicInfo[] registrationList) {
            this.registrationList = registrationList;
            return this;
        }


        /**
         * 是否已入职
         * <p> 示例值：true
         *
         * @param isOnboarded
         * @return
         */
        public Builder isOnboarded(Boolean isOnboarded) {
            this.isOnboarded = isOnboarded;
            return this;
        }


        /**
         * 是否在猎头保护期
         * <p> 示例值：true
         *
         * @param isInAgencyPeriod
         * @return
         */
        public Builder isInAgencyPeriod(Boolean isInAgencyPeriod) {
            this.isInAgencyPeriod = isInAgencyPeriod;
            return this;
        }


        /**
         * 最高学历 参考 DegreeType 枚举
         * <p> 示例值：1
         *
         * @param topDegree
         * @return
         */
        public Builder topDegree(Integer topDegree) {
            this.topDegree = topDegree;
            return this;
        }


        /**
         * 人才已加入的人才库列表
         * <p> 示例值：
         *
         * @param talentPoolIdList
         * @return
         */
        public Builder talentPoolIdList(String[] talentPoolIdList) {
            this.talentPoolIdList = talentPoolIdList;
            return this;
        }


        /**
         * 文件夹列表
         * <p> 示例值：
         *
         * @param talentFolderRefListV2
         * @return
         */
        public Builder talentFolderRefListV2(TalentFolder[] talentFolderRefListV2) {
            this.talentFolderRefListV2 = talentFolderRefListV2;
            return this;
        }


        /**
         * 标签列表
         * <p> 示例值：
         *
         * @param tagList
         * @return
         */
        public Builder tagList(TalentTag[] tagList) {
            this.tagList = tagList;
            return this;
        }


        /**
         * 相似人才信息
         * <p> 示例值：
         *
         * @param similarInfoV2
         * @return
         */
        public Builder similarInfoV2(TalentSimilar similarInfoV2) {
            this.similarInfoV2 = similarInfoV2;
            return this;
        }


        /**
         * 人才黑名单详情
         * <p> 示例值：
         *
         * @param blockInfo
         * @return
         */
        public Builder blockInfo(TalentBlock blockInfo) {
            this.blockInfo = blockInfo;
            return this;
        }


        /**
         * 人才已经加入的人才库列表
         * <p> 示例值：
         *
         * @param talentPoolRefListV2
         * @return
         */
        public Builder talentPoolRefListV2(TalentPool[] talentPoolRefListV2) {
            this.talentPoolRefListV2 = talentPoolRefListV2;
            return this;
        }


        /**
         * 备注列表
         * <p> 示例值：
         *
         * @param noteListV2
         * @return
         */
        public Builder noteListV2(TalentNote[] noteListV2) {
            this.noteListV2 = noteListV2;
            return this;
        }


        public CompositeTalent build() {
            return new CompositeTalent(this);
        }
    }
}
