// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.payroll.v1.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.payroll.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class ListCostAllocationReportReq {
    /**
     * 分页大小
     * <p> 示例值：50
     */
    @Query
    @SerializedName("page_size")
    private Integer pageSize;
    /**
     * 分页标记，第一次请求不填，表示从头开始遍历；分页查询结果还有更多项时会同时返回新的 page_token，下次遍历可采用该 page_token 获取查询结果
     * <p> 示例值：6823630319749580304
     */
    @Query
    @SerializedName("page_token")
    private String pageToken;
    /**
     * 成本分摊方案ID
     * <p> 示例值：6823630319749580304
     */
    @Query
    @SerializedName("cost_allocation_plan_id")
    private String costAllocationPlanId;
    /**
     * 期间
     * <p> 示例值：2023-11
     */
    @Query
    @SerializedName("pay_period")
    private String payPeriod;
    /**
     * 报表类型
     * <p> 示例值：1
     */
    @Query
    @SerializedName("report_type")
    private Integer reportType;

    // builder 开始
    public ListCostAllocationReportReq() {
    }

    public ListCostAllocationReportReq(Builder builder) {
        /**
         * 分页大小
         * <p> 示例值：50
         */
        this.pageSize = builder.pageSize;
        /**
         * 分页标记，第一次请求不填，表示从头开始遍历；分页查询结果还有更多项时会同时返回新的 page_token，下次遍历可采用该 page_token 获取查询结果
         * <p> 示例值：6823630319749580304
         */
        this.pageToken = builder.pageToken;
        /**
         * 成本分摊方案ID
         * <p> 示例值：6823630319749580304
         */
        this.costAllocationPlanId = builder.costAllocationPlanId;
        /**
         * 期间
         * <p> 示例值：2023-11
         */
        this.payPeriod = builder.payPeriod;
        /**
         * 报表类型
         * <p> 示例值：1
         */
        this.reportType = builder.reportType;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getPageToken() {
        return this.pageToken;
    }

    public void setPageToken(String pageToken) {
        this.pageToken = pageToken;
    }

    public String getCostAllocationPlanId() {
        return this.costAllocationPlanId;
    }

    public void setCostAllocationPlanId(String costAllocationPlanId) {
        this.costAllocationPlanId = costAllocationPlanId;
    }

    public String getPayPeriod() {
        return this.payPeriod;
    }

    public void setPayPeriod(String payPeriod) {
        this.payPeriod = payPeriod;
    }

    public Integer getReportType() {
        return this.reportType;
    }

    public void setReportType(Integer reportType) {
        this.reportType = reportType;
    }

    public static class Builder {
        private Integer pageSize; // 分页大小
        private String pageToken; // 分页标记，第一次请求不填，表示从头开始遍历；分页查询结果还有更多项时会同时返回新的 page_token，下次遍历可采用该 page_token 获取查询结果
        private String costAllocationPlanId; // 成本分摊方案ID
        private String payPeriod; // 期间
        private Integer reportType; // 报表类型

        /**
         * 分页大小
         * <p> 示例值：50
         *
         * @param pageSize
         * @return
         */
        public Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }


        /**
         * 分页标记，第一次请求不填，表示从头开始遍历；分页查询结果还有更多项时会同时返回新的 page_token，下次遍历可采用该 page_token 获取查询结果
         * <p> 示例值：6823630319749580304
         *
         * @param pageToken
         * @return
         */
        public Builder pageToken(String pageToken) {
            this.pageToken = pageToken;
            return this;
        }


        /**
         * 成本分摊方案ID
         * <p> 示例值：6823630319749580304
         *
         * @param costAllocationPlanId
         * @return
         */
        public Builder costAllocationPlanId(String costAllocationPlanId) {
            this.costAllocationPlanId = costAllocationPlanId;
            return this;
        }


        /**
         * 期间
         * <p> 示例值：2023-11
         *
         * @param payPeriod
         * @return
         */
        public Builder payPeriod(String payPeriod) {
            this.payPeriod = payPeriod;
            return this;
        }


        /**
         * 报表类型
         * <p> 示例值：1
         *
         * @param reportType
         * @return
         */
        public Builder reportType(Integer reportType) {
            this.reportType = reportType;
            return this;
        }

        /**
         * 报表类型
         * <p> 示例值：1
         *
         * @param reportType {@link com.lark.oapi.service.payroll.v1.enums.ListCostAllocationReportReportTypeEnum}
         * @return
         */
        public Builder reportType(com.lark.oapi.service.payroll.v1.enums.ListCostAllocationReportReportTypeEnum reportType) {
            this.reportType = reportType.getValue();
            return this;
        }


        public ListCostAllocationReportReq build() {
            return new ListCostAllocationReportReq(this);
        }
    }
}
