// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.wiki.v1.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.wiki.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class Space {
    /**
     * space的唯一标识
     * <p> 示例值：
     */
    @SerializedName("space_id")
    private String spaceId;
    /**
     * 名称
     * <p> 示例值：
     */
    @SerializedName("name")
    private String name;
    /**
     * 描述
     * <p> 示例值：
     */
    @SerializedName("description")
    private String description;
    /**
     * 头像url
     * <p> 示例值：
     */
    @SerializedName("avatar_url")
    private String avatarUrl;
    /**
     * 所属租户id
     * <p> 示例值：
     */
    @SerializedName("tenant_id")
    private String tenantId;
    /**
     * 所在域名
     * <p> 示例值：
     */
    @SerializedName("domain")
    private String domain;
    /**
     * 是否跨租户
     * <p> 示例值：
     */
    @SerializedName("is_cross_tenant")
    private Boolean isCrossTenant;
    /**
     * 默认属性
     * <p> 示例值：
     */
    @SerializedName("default_attr")
    private Integer defaultAttr;
    /**
     * 空间主页
     * <p> 示例值：
     */
    @SerializedName("home_page")
    private SpaceHomePage homePage;
    /**
     * 空间封面
     * <p> 示例值：
     */
    @SerializedName("cover_info")
    private SpaceCoverInfo coverInfo;
    /**
     * 版本号
     * <p> 示例值：
     */
    @SerializedName("version")
    private Integer version;

    // builder 开始
    public Space() {
    }

    public Space(Builder builder) {
        /**
         * space的唯一标识
         * <p> 示例值：
         */
        this.spaceId = builder.spaceId;
        /**
         * 名称
         * <p> 示例值：
         */
        this.name = builder.name;
        /**
         * 描述
         * <p> 示例值：
         */
        this.description = builder.description;
        /**
         * 头像url
         * <p> 示例值：
         */
        this.avatarUrl = builder.avatarUrl;
        /**
         * 所属租户id
         * <p> 示例值：
         */
        this.tenantId = builder.tenantId;
        /**
         * 所在域名
         * <p> 示例值：
         */
        this.domain = builder.domain;
        /**
         * 是否跨租户
         * <p> 示例值：
         */
        this.isCrossTenant = builder.isCrossTenant;
        /**
         * 默认属性
         * <p> 示例值：
         */
        this.defaultAttr = builder.defaultAttr;
        /**
         * 空间主页
         * <p> 示例值：
         */
        this.homePage = builder.homePage;
        /**
         * 空间封面
         * <p> 示例值：
         */
        this.coverInfo = builder.coverInfo;
        /**
         * 版本号
         * <p> 示例值：
         */
        this.version = builder.version;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getSpaceId() {
        return this.spaceId;
    }

    public void setSpaceId(String spaceId) {
        this.spaceId = spaceId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getAvatarUrl() {
        return this.avatarUrl;
    }

    public void setAvatarUrl(String avatarUrl) {
        this.avatarUrl = avatarUrl;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public Boolean getIsCrossTenant() {
        return this.isCrossTenant;
    }

    public void setIsCrossTenant(Boolean isCrossTenant) {
        this.isCrossTenant = isCrossTenant;
    }

    public Integer getDefaultAttr() {
        return this.defaultAttr;
    }

    public void setDefaultAttr(Integer defaultAttr) {
        this.defaultAttr = defaultAttr;
    }

    public SpaceHomePage getHomePage() {
        return this.homePage;
    }

    public void setHomePage(SpaceHomePage homePage) {
        this.homePage = homePage;
    }

    public SpaceCoverInfo getCoverInfo() {
        return this.coverInfo;
    }

    public void setCoverInfo(SpaceCoverInfo coverInfo) {
        this.coverInfo = coverInfo;
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public static class Builder {
        /**
         * space的唯一标识
         * <p> 示例值：
         */
        private String spaceId;
        /**
         * 名称
         * <p> 示例值：
         */
        private String name;
        /**
         * 描述
         * <p> 示例值：
         */
        private String description;
        /**
         * 头像url
         * <p> 示例值：
         */
        private String avatarUrl;
        /**
         * 所属租户id
         * <p> 示例值：
         */
        private String tenantId;
        /**
         * 所在域名
         * <p> 示例值：
         */
        private String domain;
        /**
         * 是否跨租户
         * <p> 示例值：
         */
        private Boolean isCrossTenant;
        /**
         * 默认属性
         * <p> 示例值：
         */
        private Integer defaultAttr;
        /**
         * 空间主页
         * <p> 示例值：
         */
        private SpaceHomePage homePage;
        /**
         * 空间封面
         * <p> 示例值：
         */
        private SpaceCoverInfo coverInfo;
        /**
         * 版本号
         * <p> 示例值：
         */
        private Integer version;

        /**
         * space的唯一标识
         * <p> 示例值：
         *
         * @param spaceId
         * @return
         */
        public Builder spaceId(String spaceId) {
            this.spaceId = spaceId;
            return this;
        }


        /**
         * 名称
         * <p> 示例值：
         *
         * @param name
         * @return
         */
        public Builder name(String name) {
            this.name = name;
            return this;
        }


        /**
         * 描述
         * <p> 示例值：
         *
         * @param description
         * @return
         */
        public Builder description(String description) {
            this.description = description;
            return this;
        }


        /**
         * 头像url
         * <p> 示例值：
         *
         * @param avatarUrl
         * @return
         */
        public Builder avatarUrl(String avatarUrl) {
            this.avatarUrl = avatarUrl;
            return this;
        }


        /**
         * 所属租户id
         * <p> 示例值：
         *
         * @param tenantId
         * @return
         */
        public Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }


        /**
         * 所在域名
         * <p> 示例值：
         *
         * @param domain
         * @return
         */
        public Builder domain(String domain) {
            this.domain = domain;
            return this;
        }


        /**
         * 是否跨租户
         * <p> 示例值：
         *
         * @param isCrossTenant
         * @return
         */
        public Builder isCrossTenant(Boolean isCrossTenant) {
            this.isCrossTenant = isCrossTenant;
            return this;
        }


        /**
         * 默认属性
         * <p> 示例值：
         *
         * @param defaultAttr
         * @return
         */
        public Builder defaultAttr(Integer defaultAttr) {
            this.defaultAttr = defaultAttr;
            return this;
        }

        /**
         * 默认属性
         * <p> 示例值：
         *
         * @param defaultAttr {@link com.lark.oapi.service.wiki.v1.enums.SpaceDefaultAttrEnum}
         * @return
         */
        public Builder defaultAttr(com.lark.oapi.service.wiki.v1.enums.SpaceDefaultAttrEnum defaultAttr) {
            this.defaultAttr = defaultAttr.getValue();
            return this;
        }


        /**
         * 空间主页
         * <p> 示例值：
         *
         * @param homePage
         * @return
         */
        public Builder homePage(SpaceHomePage homePage) {
            this.homePage = homePage;
            return this;
        }


        /**
         * 空间封面
         * <p> 示例值：
         *
         * @param coverInfo
         * @return
         */
        public Builder coverInfo(SpaceCoverInfo coverInfo) {
            this.coverInfo = coverInfo;
            return this;
        }


        /**
         * 版本号
         * <p> 示例值：
         *
         * @param version
         * @return
         */
        public Builder version(Integer version) {
            this.version = version;
            return this;
        }


        public Space build() {
            return new Space(this);
        }
    }
}
