// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.cardkit.v1.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.cardkit.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;

import java.util.Map;

import com.lark.oapi.core.response.BaseResponse;

public class CallbackAction {
    /**
     * 交互组件绑定的开发者自定义回传数据，对应组件中的 value 属性。类型为 string 或 object，可由开发者指定
     * <p> 示例值：
     */
    @SerializedName("value")
    private Map<String, String> value;
    /**
     * 用户操作交互组件的标签
     * <p> 示例值：button
     */
    @SerializedName("tag")
    private String tag;
    /**
     * 用户操作单选组件的选项值
     * <p> 示例值：selectDemo1
     */
    @SerializedName("option")
    private String option;
    /**
     * 用户操作多选组件的选项值
     * <p> 示例值：
     */
    @SerializedName("options")
    private String[] options;
    /**
     * 用户当前所在地区的时区。当用户操作日期选择器、时间选择器、或日期时间选择器时返回
     * <p> 示例值：Asia/Shanghai
     */
    @SerializedName("timezone")
    private String timezone;
    /**
     * 用户操作输入组件的输入值
     * <p> 示例值：input_value
     */
    @SerializedName("input_value")
    private String inputValue;
    /**
     * 用户操作表单容器内用户提交的数据
     * <p> 示例值：
     */
    @SerializedName("form_value")
    private Map<String, String> formValue;
    /**
     * 用户操作交互组件的名称，由开发者自定义
     * <p> 示例值：approval_button
     */
    @SerializedName("name")
    private String name;
    /**
     * 用户操作勾选器组件的勾选状态
     * <p> 示例值：
     */
    @SerializedName("checked")
    private Boolean checked;

    // builder 开始
    public CallbackAction() {
    }

    public CallbackAction(Builder builder) {
        /**
         * 交互组件绑定的开发者自定义回传数据，对应组件中的 value 属性。类型为 string 或 object，可由开发者指定
         * <p> 示例值：
         */
        this.value = builder.value;
        /**
         * 用户操作交互组件的标签
         * <p> 示例值：button
         */
        this.tag = builder.tag;
        /**
         * 用户操作单选组件的选项值
         * <p> 示例值：selectDemo1
         */
        this.option = builder.option;
        /**
         * 用户操作多选组件的选项值
         * <p> 示例值：
         */
        this.options = builder.options;
        /**
         * 用户当前所在地区的时区。当用户操作日期选择器、时间选择器、或日期时间选择器时返回
         * <p> 示例值：Asia/Shanghai
         */
        this.timezone = builder.timezone;
        /**
         * 用户操作输入组件的输入值
         * <p> 示例值：input_value
         */
        this.inputValue = builder.inputValue;
        /**
         * 用户操作表单容器内用户提交的数据
         * <p> 示例值：
         */
        this.formValue = builder.formValue;
        /**
         * 用户操作交互组件的名称，由开发者自定义
         * <p> 示例值：approval_button
         */
        this.name = builder.name;
        /**
         * 用户操作勾选器组件的勾选状态
         * <p> 示例值：
         */
        this.checked = builder.checked;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Map<String, String> getValue() {
        return this.value;
    }

    public void setValue(Map<String, String> value) {
        this.value = value;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getOption() {
        return this.option;
    }

    public void setOption(String option) {
        this.option = option;
    }

    public String[] getOptions() {
        return this.options;
    }

    public void setOptions(String[] options) {
        this.options = options;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public String getInputValue() {
        return this.inputValue;
    }

    public void setInputValue(String inputValue) {
        this.inputValue = inputValue;
    }

    public Map<String, String> getFormValue() {
        return this.formValue;
    }

    public void setFormValue(Map<String, String> formValue) {
        this.formValue = formValue;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Boolean getChecked() {
        return this.checked;
    }

    public void setChecked(Boolean checked) {
        this.checked = checked;
    }

    public static class Builder {
        /**
         * 交互组件绑定的开发者自定义回传数据，对应组件中的 value 属性。类型为 string 或 object，可由开发者指定
         * <p> 示例值：
         */
        private Map<String, String> value;
        /**
         * 用户操作交互组件的标签
         * <p> 示例值：button
         */
        private String tag;
        /**
         * 用户操作单选组件的选项值
         * <p> 示例值：selectDemo1
         */
        private String option;
        /**
         * 用户操作多选组件的选项值
         * <p> 示例值：
         */
        private String[] options;
        /**
         * 用户当前所在地区的时区。当用户操作日期选择器、时间选择器、或日期时间选择器时返回
         * <p> 示例值：Asia/Shanghai
         */
        private String timezone;
        /**
         * 用户操作输入组件的输入值
         * <p> 示例值：input_value
         */
        private String inputValue;
        /**
         * 用户操作表单容器内用户提交的数据
         * <p> 示例值：
         */
        private Map<String, String> formValue;
        /**
         * 用户操作交互组件的名称，由开发者自定义
         * <p> 示例值：approval_button
         */
        private String name;
        /**
         * 用户操作勾选器组件的勾选状态
         * <p> 示例值：
         */
        private Boolean checked;

        /**
         * 交互组件绑定的开发者自定义回传数据，对应组件中的 value 属性。类型为 string 或 object，可由开发者指定
         * <p> 示例值：
         *
         * @param value
         * @return
         */
        public Builder value(Map<String, String> value) {
            this.value = value;
            return this;
        }


        /**
         * 用户操作交互组件的标签
         * <p> 示例值：button
         *
         * @param tag
         * @return
         */
        public Builder tag(String tag) {
            this.tag = tag;
            return this;
        }


        /**
         * 用户操作单选组件的选项值
         * <p> 示例值：selectDemo1
         *
         * @param option
         * @return
         */
        public Builder option(String option) {
            this.option = option;
            return this;
        }


        /**
         * 用户操作多选组件的选项值
         * <p> 示例值：
         *
         * @param options
         * @return
         */
        public Builder options(String[] options) {
            this.options = options;
            return this;
        }


        /**
         * 用户当前所在地区的时区。当用户操作日期选择器、时间选择器、或日期时间选择器时返回
         * <p> 示例值：Asia/Shanghai
         *
         * @param timezone
         * @return
         */
        public Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }


        /**
         * 用户操作输入组件的输入值
         * <p> 示例值：input_value
         *
         * @param inputValue
         * @return
         */
        public Builder inputValue(String inputValue) {
            this.inputValue = inputValue;
            return this;
        }


        /**
         * 用户操作表单容器内用户提交的数据
         * <p> 示例值：
         *
         * @param formValue
         * @return
         */
        public Builder formValue(Map<String, String> formValue) {
            this.formValue = formValue;
            return this;
        }


        /**
         * 用户操作交互组件的名称，由开发者自定义
         * <p> 示例值：approval_button
         *
         * @param name
         * @return
         */
        public Builder name(String name) {
            this.name = name;
            return this;
        }


        /**
         * 用户操作勾选器组件的勾选状态
         * <p> 示例值：
         *
         * @param checked
         * @return
         */
        public Builder checked(Boolean checked) {
            this.checked = checked;
            return this;
        }


        public CallbackAction build() {
            return new CallbackAction(this);
        }
    }
}
