// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.corehr.v1.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.corehr.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class CpstGradeStandardValue {
    /**
     * 薪资标准的关联对象，项目或者指标
     * <p> 示例值：
     */
    @SerializedName("reference_object")
    private ReferenceObject referenceObject;
    /**
     * 薪资标准类型
     * <p> 示例值：
     */
    @SerializedName("standard_type")
    private CpstStandardType standardType;
    /**
     * 上下限
     * <p> 示例值：
     */
    @SerializedName("band_width")
    private CpstBandWidth bandWidth;
    /**
     * 标准值
     * <p> 示例值：12000
     */
    @SerializedName("standard_value")
    private String standardValue;

    // builder 开始
    public CpstGradeStandardValue() {
    }

    public CpstGradeStandardValue(Builder builder) {
        /**
         * 薪资标准的关联对象，项目或者指标
         * <p> 示例值：
         */
        this.referenceObject = builder.referenceObject;
        /**
         * 薪资标准类型
         * <p> 示例值：
         */
        this.standardType = builder.standardType;
        /**
         * 上下限
         * <p> 示例值：
         */
        this.bandWidth = builder.bandWidth;
        /**
         * 标准值
         * <p> 示例值：12000
         */
        this.standardValue = builder.standardValue;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public ReferenceObject getReferenceObject() {
        return this.referenceObject;
    }

    public void setReferenceObject(ReferenceObject referenceObject) {
        this.referenceObject = referenceObject;
    }

    public CpstStandardType getStandardType() {
        return this.standardType;
    }

    public void setStandardType(CpstStandardType standardType) {
        this.standardType = standardType;
    }

    public CpstBandWidth getBandWidth() {
        return this.bandWidth;
    }

    public void setBandWidth(CpstBandWidth bandWidth) {
        this.bandWidth = bandWidth;
    }

    public String getStandardValue() {
        return this.standardValue;
    }

    public void setStandardValue(String standardValue) {
        this.standardValue = standardValue;
    }

    public static class Builder {
        /**
         * 薪资标准的关联对象，项目或者指标
         * <p> 示例值：
         */
        private ReferenceObject referenceObject;
        /**
         * 薪资标准类型
         * <p> 示例值：
         */
        private CpstStandardType standardType;
        /**
         * 上下限
         * <p> 示例值：
         */
        private CpstBandWidth bandWidth;
        /**
         * 标准值
         * <p> 示例值：12000
         */
        private String standardValue;

        /**
         * 薪资标准的关联对象，项目或者指标
         * <p> 示例值：
         *
         * @param referenceObject
         * @return
         */
        public Builder referenceObject(ReferenceObject referenceObject) {
            this.referenceObject = referenceObject;
            return this;
        }


        /**
         * 薪资标准类型
         * <p> 示例值：
         *
         * @param standardType
         * @return
         */
        public Builder standardType(CpstStandardType standardType) {
            this.standardType = standardType;
            return this;
        }


        /**
         * 上下限
         * <p> 示例值：
         *
         * @param bandWidth
         * @return
         */
        public Builder bandWidth(CpstBandWidth bandWidth) {
            this.bandWidth = bandWidth;
            return this;
        }


        /**
         * 标准值
         * <p> 示例值：12000
         *
         * @param standardValue
         * @return
         */
        public Builder standardValue(String standardValue) {
            this.standardValue = standardValue;
            return this;
        }


        public CpstGradeStandardValue build() {
            return new CpstGradeStandardValue(this);
        }
    }
}
