// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.docx.v1.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.docx.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class ConvertDocumentReqBody {
    /**
     * 内容类型
     * <p> 示例值：markdown
     */
    @SerializedName("content_type")
    private String contentType;
    /**
     * 文本内容
     * <p> 示例值：**第一段为加粗文本**\n\n```\n第二段为代码块\n```
     */
    @SerializedName("content")
    private String content;

    // builder 开始
    public ConvertDocumentReqBody() {
    }

    public ConvertDocumentReqBody(Builder builder) {
        /**
         * 内容类型
         * <p> 示例值：markdown
         */
        this.contentType = builder.contentType;
        /**
         * 文本内容
         * <p> 示例值：**第一段为加粗文本**\n\n```\n第二段为代码块\n```
         */
        this.content = builder.content;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public static class Builder {
        /**
         * 内容类型
         * <p> 示例值：markdown
         */
        private String contentType;
        /**
         * 文本内容
         * <p> 示例值：**第一段为加粗文本**\n\n```\n第二段为代码块\n```
         */
        private String content;

        /**
         * 内容类型
         * <p> 示例值：markdown
         *
         * @param contentType
         * @return
         */
        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        /**
         * 内容类型
         * <p> 示例值：markdown
         *
         * @param contentType {@link com.lark.oapi.service.docx.v1.enums.ConvertDocumentContentTypeEnum}
         * @return
         */
        public Builder contentType(com.lark.oapi.service.docx.v1.enums.ConvertDocumentContentTypeEnum contentType) {
            this.contentType = contentType.getValue();
            return this;
        }


        /**
         * 文本内容
         * <p> 示例值：**第一段为加粗文本**\n\n```\n第二段为代码块\n```
         *
         * @param content
         * @return
         */
        public Builder content(String content) {
            this.content = content;
            return this;
        }


        public ConvertDocumentReqBody build() {
            return new ConvertDocumentReqBody(this);
        }
    }
}
