// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.base.v2.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.base.v2.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class RecRule {
    /**
     * 记录筛选条件
     * <p> 示例值：
     */
    @SerializedName("conditions")
    private RecRuleCondition[] conditions;
    /**
     * 多个筛选条件的关系
     * <p> 示例值：and
     */
    @SerializedName("conjunction")
    private String conjunction;
    /**
     * 规则筛选记录对应的权限
     * <p> 示例值：1
     */
    @SerializedName("perm")
    private Integer perm;
    /**
     * 其他记录权限，仅在table_perm为2时有效
     * <p> 示例值：1
     */
    @SerializedName("other_perm")
    private Integer otherPerm;

    // builder 开始
    public RecRule() {
    }

    public RecRule(Builder builder) {
        /**
         * 记录筛选条件
         * <p> 示例值：
         */
        this.conditions = builder.conditions;
        /**
         * 多个筛选条件的关系
         * <p> 示例值：and
         */
        this.conjunction = builder.conjunction;
        /**
         * 规则筛选记录对应的权限
         * <p> 示例值：1
         */
        this.perm = builder.perm;
        /**
         * 其他记录权限，仅在table_perm为2时有效
         * <p> 示例值：1
         */
        this.otherPerm = builder.otherPerm;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public RecRuleCondition[] getConditions() {
        return this.conditions;
    }

    public void setConditions(RecRuleCondition[] conditions) {
        this.conditions = conditions;
    }

    public String getConjunction() {
        return this.conjunction;
    }

    public void setConjunction(String conjunction) {
        this.conjunction = conjunction;
    }

    public Integer getPerm() {
        return this.perm;
    }

    public void setPerm(Integer perm) {
        this.perm = perm;
    }

    public Integer getOtherPerm() {
        return this.otherPerm;
    }

    public void setOtherPerm(Integer otherPerm) {
        this.otherPerm = otherPerm;
    }

    public static class Builder {
        /**
         * 记录筛选条件
         * <p> 示例值：
         */
        private RecRuleCondition[] conditions;
        /**
         * 多个筛选条件的关系
         * <p> 示例值：and
         */
        private String conjunction;
        /**
         * 规则筛选记录对应的权限
         * <p> 示例值：1
         */
        private Integer perm;
        /**
         * 其他记录权限，仅在table_perm为2时有效
         * <p> 示例值：1
         */
        private Integer otherPerm;

        /**
         * 记录筛选条件
         * <p> 示例值：
         *
         * @param conditions
         * @return
         */
        public Builder conditions(RecRuleCondition[] conditions) {
            this.conditions = conditions;
            return this;
        }


        /**
         * 多个筛选条件的关系
         * <p> 示例值：and
         *
         * @param conjunction
         * @return
         */
        public Builder conjunction(String conjunction) {
            this.conjunction = conjunction;
            return this;
        }

        /**
         * 多个筛选条件的关系
         * <p> 示例值：and
         *
         * @param conjunction {@link com.lark.oapi.service.base.v2.enums.RecRuleConjunctionEnum}
         * @return
         */
        public Builder conjunction(com.lark.oapi.service.base.v2.enums.RecRuleConjunctionEnum conjunction) {
            this.conjunction = conjunction.getValue();
            return this;
        }


        /**
         * 规则筛选记录对应的权限
         * <p> 示例值：1
         *
         * @param perm
         * @return
         */
        public Builder perm(Integer perm) {
            this.perm = perm;
            return this;
        }

        /**
         * 规则筛选记录对应的权限
         * <p> 示例值：1
         *
         * @param perm {@link com.lark.oapi.service.base.v2.enums.RecRulePermEnum}
         * @return
         */
        public Builder perm(com.lark.oapi.service.base.v2.enums.RecRulePermEnum perm) {
            this.perm = perm.getValue();
            return this;
        }


        /**
         * 其他记录权限，仅在table_perm为2时有效
         * <p> 示例值：1
         *
         * @param otherPerm
         * @return
         */
        public Builder otherPerm(Integer otherPerm) {
            this.otherPerm = otherPerm;
            return this;
        }

        /**
         * 其他记录权限，仅在table_perm为2时有效
         * <p> 示例值：1
         *
         * @param otherPerm {@link com.lark.oapi.service.base.v2.enums.RecRuleOtherPermEnum}
         * @return
         */
        public Builder otherPerm(com.lark.oapi.service.base.v2.enums.RecRuleOtherPermEnum otherPerm) {
            this.otherPerm = otherPerm.getValue();
            return this;
        }


        public RecRule build() {
            return new RecRule(this);
        }
    }
}
