// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.okr.v1.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.okr.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class QueryReviewReq {
    /**
     * 此次调用中使用的用户ID的类型
     * <p> 示例值：
     */
    @Query
    @SerializedName("user_id_type")
    private String userIdType;
    /**
     * 目标用户id列表，最多5个
     * <p> 示例值：ou_e6139117c300506837def50545420c6a
     */
    @Query
    @SerializedName("user_ids")
    private String[] userIds;
    /**
     * period_id列表，最多5个
     * <p> 示例值：7067724095781142548
     */
    @Query
    @SerializedName("period_ids")
    private String[] periodIds;

    // builder 开始
    public QueryReviewReq() {
    }

    public QueryReviewReq(Builder builder) {
        /**
         * 此次调用中使用的用户ID的类型
         * <p> 示例值：
         */
        this.userIdType = builder.userIdType;
        /**
         * 目标用户id列表，最多5个
         * <p> 示例值：ou_e6139117c300506837def50545420c6a
         */
        this.userIds = builder.userIds;
        /**
         * period_id列表，最多5个
         * <p> 示例值：7067724095781142548
         */
        this.periodIds = builder.periodIds;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getUserIdType() {
        return this.userIdType;
    }

    public void setUserIdType(String userIdType) {
        this.userIdType = userIdType;
    }

    public String[] getUserIds() {
        return this.userIds;
    }

    public void setUserIds(String[] userIds) {
        this.userIds = userIds;
    }

    public String[] getPeriodIds() {
        return this.periodIds;
    }

    public void setPeriodIds(String[] periodIds) {
        this.periodIds = periodIds;
    }

    public static class Builder {
        private String userIdType; // 此次调用中使用的用户ID的类型
        private String[] userIds; // 目标用户id列表，最多5个
        private String[] periodIds; // period_id列表，最多5个

        /**
         * 此次调用中使用的用户ID的类型
         * <p> 示例值：
         *
         * @param userIdType
         * @return
         */
        public Builder userIdType(String userIdType) {
            this.userIdType = userIdType;
            return this;
        }

        /**
         * 此次调用中使用的用户ID的类型
         * <p> 示例值：
         *
         * @param userIdType {@link com.lark.oapi.service.okr.v1.enums.QueryReviewOpenAPIQueryReviewUserIDTypeEnum}
         * @return
         */
        public Builder userIdType(com.lark.oapi.service.okr.v1.enums.QueryReviewOpenAPIQueryReviewUserIDTypeEnum userIdType) {
            this.userIdType = userIdType.getValue();
            return this;
        }


        /**
         * 目标用户id列表，最多5个
         * <p> 示例值：ou_e6139117c300506837def50545420c6a
         *
         * @param userIds
         * @return
         */
        public Builder userIds(String[] userIds) {
            this.userIds = userIds;
            return this;
        }


        /**
         * period_id列表，最多5个
         * <p> 示例值：7067724095781142548
         *
         * @param periodIds
         * @return
         */
        public Builder periodIds(String[] periodIds) {
            this.periodIds = periodIds;
            return this;
        }


        public QueryReviewReq build() {
            return new QueryReviewReq(this);
        }
    }
}
