// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.payroll.v1.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.payroll.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class PaymentAccountingItem {
    /**
     * 算薪项唯一标识
     * <p> 示例值：7202076988667019308
     */
    @SerializedName("id")
    private String id;
    /**
     * 算薪项名称
     * <p> 示例值：
     */
    @SerializedName("accounting_item_names")
    private I18nContent[] accountingItemNames;
    /**
     * 算薪项值
     * <p> 示例值：
     */
    @SerializedName("accounting_item_value")
    private AccountingItemValue accountingItemValue;
    /**
     * 算薪项分段数据
     * <p> 示例值：
     */
    @SerializedName("segment_values")
    private SegmentValue[] segmentValues;
    /**
     * 算薪项类型，1-文本；2-金额；3-数值；4-百分比；5-日期；6-引用
     * <p> 示例值：1
     */
    @SerializedName("accounting_item_type")
    private Integer accountingItemType;

    // builder 开始
    public PaymentAccountingItem() {
    }

    public PaymentAccountingItem(Builder builder) {
        /**
         * 算薪项唯一标识
         * <p> 示例值：7202076988667019308
         */
        this.id = builder.id;
        /**
         * 算薪项名称
         * <p> 示例值：
         */
        this.accountingItemNames = builder.accountingItemNames;
        /**
         * 算薪项值
         * <p> 示例值：
         */
        this.accountingItemValue = builder.accountingItemValue;
        /**
         * 算薪项分段数据
         * <p> 示例值：
         */
        this.segmentValues = builder.segmentValues;
        /**
         * 算薪项类型，1-文本；2-金额；3-数值；4-百分比；5-日期；6-引用
         * <p> 示例值：1
         */
        this.accountingItemType = builder.accountingItemType;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public I18nContent[] getAccountingItemNames() {
        return this.accountingItemNames;
    }

    public void setAccountingItemNames(I18nContent[] accountingItemNames) {
        this.accountingItemNames = accountingItemNames;
    }

    public AccountingItemValue getAccountingItemValue() {
        return this.accountingItemValue;
    }

    public void setAccountingItemValue(AccountingItemValue accountingItemValue) {
        this.accountingItemValue = accountingItemValue;
    }

    public SegmentValue[] getSegmentValues() {
        return this.segmentValues;
    }

    public void setSegmentValues(SegmentValue[] segmentValues) {
        this.segmentValues = segmentValues;
    }

    public Integer getAccountingItemType() {
        return this.accountingItemType;
    }

    public void setAccountingItemType(Integer accountingItemType) {
        this.accountingItemType = accountingItemType;
    }

    public static class Builder {
        /**
         * 算薪项唯一标识
         * <p> 示例值：7202076988667019308
         */
        private String id;
        /**
         * 算薪项名称
         * <p> 示例值：
         */
        private I18nContent[] accountingItemNames;
        /**
         * 算薪项值
         * <p> 示例值：
         */
        private AccountingItemValue accountingItemValue;
        /**
         * 算薪项分段数据
         * <p> 示例值：
         */
        private SegmentValue[] segmentValues;
        /**
         * 算薪项类型，1-文本；2-金额；3-数值；4-百分比；5-日期；6-引用
         * <p> 示例值：1
         */
        private Integer accountingItemType;

        /**
         * 算薪项唯一标识
         * <p> 示例值：7202076988667019308
         *
         * @param id
         * @return
         */
        public Builder id(String id) {
            this.id = id;
            return this;
        }


        /**
         * 算薪项名称
         * <p> 示例值：
         *
         * @param accountingItemNames
         * @return
         */
        public Builder accountingItemNames(I18nContent[] accountingItemNames) {
            this.accountingItemNames = accountingItemNames;
            return this;
        }


        /**
         * 算薪项值
         * <p> 示例值：
         *
         * @param accountingItemValue
         * @return
         */
        public Builder accountingItemValue(AccountingItemValue accountingItemValue) {
            this.accountingItemValue = accountingItemValue;
            return this;
        }


        /**
         * 算薪项分段数据
         * <p> 示例值：
         *
         * @param segmentValues
         * @return
         */
        public Builder segmentValues(SegmentValue[] segmentValues) {
            this.segmentValues = segmentValues;
            return this;
        }


        /**
         * 算薪项类型，1-文本；2-金额；3-数值；4-百分比；5-日期；6-引用
         * <p> 示例值：1
         *
         * @param accountingItemType
         * @return
         */
        public Builder accountingItemType(Integer accountingItemType) {
            this.accountingItemType = accountingItemType;
            return this;
        }


        public PaymentAccountingItem build() {
            return new PaymentAccountingItem(this);
        }
    }
}
