// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.apaas.v1.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.apaas.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class GetApplicationEnvironmentVariableReq {
    /**
     * 应用命名空间
     * <p> 示例值：package_test__c
     */
    @Path
    @SerializedName("namespace")
    private String namespace;
    /**
     * 环境变量 API 名称
     * <p> 示例值：globalParam_0b410b17704
     */
    @Path
    @SerializedName("environment_variable_api_name")
    private String environmentVariableApiName;

    // builder 开始
    public GetApplicationEnvironmentVariableReq() {
    }

    public GetApplicationEnvironmentVariableReq(Builder builder) {
        /**
         * 应用命名空间
         * <p> 示例值：package_test__c
         */
        this.namespace = builder.namespace;
        /**
         * 环境变量 API 名称
         * <p> 示例值：globalParam_0b410b17704
         */
        this.environmentVariableApiName = builder.environmentVariableApiName;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getEnvironmentVariableApiName() {
        return this.environmentVariableApiName;
    }

    public void setEnvironmentVariableApiName(String environmentVariableApiName) {
        this.environmentVariableApiName = environmentVariableApiName;
    }

    public static class Builder {

        private String namespace; // 应用命名空间
        private String environmentVariableApiName; // 环境变量 API 名称

        /**
         * 应用命名空间
         * <p> 示例值：package_test__c
         *
         * @param namespace
         * @return
         */
        public Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }


        /**
         * 环境变量 API 名称
         * <p> 示例值：globalParam_0b410b17704
         *
         * @param environmentVariableApiName
         * @return
         */
        public Builder environmentVariableApiName(String environmentVariableApiName) {
            this.environmentVariableApiName = environmentVariableApiName;
            return this;
        }


        public GetApplicationEnvironmentVariableReq build() {
            return new GetApplicationEnvironmentVariableReq(this);
        }
    }
}
