// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.apaas.v1.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.apaas.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class SearchApplicationObjectReqBody {
    /**
     * 搜索词
     * <p> 示例值：搜索关键字
     */
    @SerializedName("q")
    private String q;
    /**
     * 搜索对象范围
     * <p> 示例值：
     */
    @SerializedName("search_objects")
    private SearchObjectParam[] searchObjects;
    /**
     * 分页参数，第一次搜索时为空，需要分页查询时使用 SearchRecordsResponse 中的结果
     * <p> 示例值：eyJvYmplY3RzX3BhZ2VfdG9rZW4iOlt7Im9ial9pZCI6MTc2OTI4NzM5M
     */
    @SerializedName("page_token")
    private String pageToken;
    /**
     * 返回数量，默认为50，最大不超过2000
     * <p> 示例值：100
     */
    @SerializedName("page_size")
    private String pageSize;
    /**
     * 返回元数据枚举值
     * <p> 示例值：Label
     */
    @SerializedName("metadata")
    private String metadata;

    // builder 开始
    public SearchApplicationObjectReqBody() {
    }

    public SearchApplicationObjectReqBody(Builder builder) {
        /**
         * 搜索词
         * <p> 示例值：搜索关键字
         */
        this.q = builder.q;
        /**
         * 搜索对象范围
         * <p> 示例值：
         */
        this.searchObjects = builder.searchObjects;
        /**
         * 分页参数，第一次搜索时为空，需要分页查询时使用 SearchRecordsResponse 中的结果
         * <p> 示例值：eyJvYmplY3RzX3BhZ2VfdG9rZW4iOlt7Im9ial9pZCI6MTc2OTI4NzM5M
         */
        this.pageToken = builder.pageToken;
        /**
         * 返回数量，默认为50，最大不超过2000
         * <p> 示例值：100
         */
        this.pageSize = builder.pageSize;
        /**
         * 返回元数据枚举值
         * <p> 示例值：Label
         */
        this.metadata = builder.metadata;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getQ() {
        return this.q;
    }

    public void setQ(String q) {
        this.q = q;
    }

    public SearchObjectParam[] getSearchObjects() {
        return this.searchObjects;
    }

    public void setSearchObjects(SearchObjectParam[] searchObjects) {
        this.searchObjects = searchObjects;
    }

    public String getPageToken() {
        return this.pageToken;
    }

    public void setPageToken(String pageToken) {
        this.pageToken = pageToken;
    }

    public String getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(String pageSize) {
        this.pageSize = pageSize;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    public static class Builder {
        /**
         * 搜索词
         * <p> 示例值：搜索关键字
         */
        private String q;
        /**
         * 搜索对象范围
         * <p> 示例值：
         */
        private SearchObjectParam[] searchObjects;
        /**
         * 分页参数，第一次搜索时为空，需要分页查询时使用 SearchRecordsResponse 中的结果
         * <p> 示例值：eyJvYmplY3RzX3BhZ2VfdG9rZW4iOlt7Im9ial9pZCI6MTc2OTI4NzM5M
         */
        private String pageToken;
        /**
         * 返回数量，默认为50，最大不超过2000
         * <p> 示例值：100
         */
        private String pageSize;
        /**
         * 返回元数据枚举值
         * <p> 示例值：Label
         */
        private String metadata;

        /**
         * 搜索词
         * <p> 示例值：搜索关键字
         *
         * @param q
         * @return
         */
        public Builder q(String q) {
            this.q = q;
            return this;
        }


        /**
         * 搜索对象范围
         * <p> 示例值：
         *
         * @param searchObjects
         * @return
         */
        public Builder searchObjects(SearchObjectParam[] searchObjects) {
            this.searchObjects = searchObjects;
            return this;
        }


        /**
         * 分页参数，第一次搜索时为空，需要分页查询时使用 SearchRecordsResponse 中的结果
         * <p> 示例值：eyJvYmplY3RzX3BhZ2VfdG9rZW4iOlt7Im9ial9pZCI6MTc2OTI4NzM5M
         *
         * @param pageToken
         * @return
         */
        public Builder pageToken(String pageToken) {
            this.pageToken = pageToken;
            return this;
        }


        /**
         * 返回数量，默认为50，最大不超过2000
         * <p> 示例值：100
         *
         * @param pageSize
         * @return
         */
        public Builder pageSize(String pageSize) {
            this.pageSize = pageSize;
            return this;
        }


        /**
         * 返回元数据枚举值
         * <p> 示例值：Label
         *
         * @param metadata
         * @return
         */
        public Builder metadata(String metadata) {
            this.metadata = metadata;
            return this;
        }

        /**
         * 返回元数据枚举值
         * <p> 示例值：Label
         *
         * @param metadata {@link com.lark.oapi.service.apaas.v1.enums.SearchApplicationObjectMetadataOptionEnum}
         * @return
         */
        public Builder metadata(com.lark.oapi.service.apaas.v1.enums.SearchApplicationObjectMetadataOptionEnum metadata) {
            this.metadata = metadata.getValue();
            return this;
        }


        public SearchApplicationObjectReqBody build() {
            return new SearchApplicationObjectReqBody(this);
        }
    }
}
