// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.attendance.v1.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.attendance.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class CreateBpmOutRecord {
    /**
     * 发起外出审批的用户ID
     * <p> 示例值：
     */
    @SerializedName("user_id")
    private String userId;
    /**
     * 外出数据
     * <p> 示例值：
     */
    @SerializedName("out_record")
    private OutRecord outRecord;
    /**
     * 外出事由
     * <p> 示例值：临时外出
     */
    @SerializedName("out_reason")
    private String outReason;
    /**
     * json string，BPM流程中自定义新增控件
     * <p> 示例值："{\"attachments\":{\"null_value\":{}}}"
     */
    @SerializedName("custom_form_data")
    private String customFormData;

    // builder 开始
    public CreateBpmOutRecord() {
    }

    public CreateBpmOutRecord(Builder builder) {
        /**
         * 发起外出审批的用户ID
         * <p> 示例值：
         */
        this.userId = builder.userId;
        /**
         * 外出数据
         * <p> 示例值：
         */
        this.outRecord = builder.outRecord;
        /**
         * 外出事由
         * <p> 示例值：临时外出
         */
        this.outReason = builder.outReason;
        /**
         * json string，BPM流程中自定义新增控件
         * <p> 示例值："{\"attachments\":{\"null_value\":{}}}"
         */
        this.customFormData = builder.customFormData;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public OutRecord getOutRecord() {
        return this.outRecord;
    }

    public void setOutRecord(OutRecord outRecord) {
        this.outRecord = outRecord;
    }

    public String getOutReason() {
        return this.outReason;
    }

    public void setOutReason(String outReason) {
        this.outReason = outReason;
    }

    public String getCustomFormData() {
        return this.customFormData;
    }

    public void setCustomFormData(String customFormData) {
        this.customFormData = customFormData;
    }

    public static class Builder {
        /**
         * 发起外出审批的用户ID
         * <p> 示例值：
         */
        private String userId;
        /**
         * 外出数据
         * <p> 示例值：
         */
        private OutRecord outRecord;
        /**
         * 外出事由
         * <p> 示例值：临时外出
         */
        private String outReason;
        /**
         * json string，BPM流程中自定义新增控件
         * <p> 示例值："{\"attachments\":{\"null_value\":{}}}"
         */
        private String customFormData;

        /**
         * 发起外出审批的用户ID
         * <p> 示例值：
         *
         * @param userId
         * @return
         */
        public Builder userId(String userId) {
            this.userId = userId;
            return this;
        }


        /**
         * 外出数据
         * <p> 示例值：
         *
         * @param outRecord
         * @return
         */
        public Builder outRecord(OutRecord outRecord) {
            this.outRecord = outRecord;
            return this;
        }


        /**
         * 外出事由
         * <p> 示例值：临时外出
         *
         * @param outReason
         * @return
         */
        public Builder outReason(String outReason) {
            this.outReason = outReason;
            return this;
        }


        /**
         * json string，BPM流程中自定义新增控件
         * <p> 示例值："{\"attachments\":{\"null_value\":{}}}"
         *
         * @param customFormData
         * @return
         */
        public Builder customFormData(String customFormData) {
            this.customFormData = customFormData;
            return this;
        }


        public CreateBpmOutRecord build() {
            return new CreateBpmOutRecord(this);
        }
    }
}
