// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.calendar.v4.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.calendar.v4.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class CalendarAcl {
    /**
     * acl资源ID。参见[ACL ID说明](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/calendar-v4/calendar-acl/introduction)
     * <p> 示例值：user_xxxxxx
     */
    @SerializedName("acl_id")
    private String aclId;
    /**
     * 对日历的访问权限
     * <p> 示例值：writer
     */
    @SerializedName("role")
    private String role;
    /**
     * 权限范围
     * <p> 示例值：
     */
    @SerializedName("scope")
    private AclScope scope;

    // builder 开始
    public CalendarAcl() {
    }

    public CalendarAcl(Builder builder) {
        /**
         * acl资源ID。参见[ACL ID说明](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/calendar-v4/calendar-acl/introduction)
         * <p> 示例值：user_xxxxxx
         */
        this.aclId = builder.aclId;
        /**
         * 对日历的访问权限
         * <p> 示例值：writer
         */
        this.role = builder.role;
        /**
         * 权限范围
         * <p> 示例值：
         */
        this.scope = builder.scope;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getAclId() {
        return this.aclId;
    }

    public void setAclId(String aclId) {
        this.aclId = aclId;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public AclScope getScope() {
        return this.scope;
    }

    public void setScope(AclScope scope) {
        this.scope = scope;
    }

    public static class Builder {
        /**
         * acl资源ID。参见[ACL ID说明](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/calendar-v4/calendar-acl/introduction)
         * <p> 示例值：user_xxxxxx
         */
        private String aclId;
        /**
         * 对日历的访问权限
         * <p> 示例值：writer
         */
        private String role;
        /**
         * 权限范围
         * <p> 示例值：
         */
        private AclScope scope;

        /**
         * acl资源ID。参见[ACL ID说明](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/calendar-v4/calendar-acl/introduction)
         * <p> 示例值：user_xxxxxx
         *
         * @param aclId
         * @return
         */
        public Builder aclId(String aclId) {
            this.aclId = aclId;
            return this;
        }


        /**
         * 对日历的访问权限
         * <p> 示例值：writer
         *
         * @param role
         * @return
         */
        public Builder role(String role) {
            this.role = role;
            return this;
        }

        /**
         * 对日历的访问权限
         * <p> 示例值：writer
         *
         * @param role {@link com.lark.oapi.service.calendar.v4.enums.CalendarAclCalendarAccessRoleEnum}
         * @return
         */
        public Builder role(com.lark.oapi.service.calendar.v4.enums.CalendarAclCalendarAccessRoleEnum role) {
            this.role = role.getValue();
            return this;
        }


        /**
         * 权限范围
         * <p> 示例值：
         *
         * @param scope
         * @return
         */
        public Builder scope(AclScope scope) {
            this.scope = scope;
            return this;
        }


        public CalendarAcl build() {
            return new CalendarAcl(this);
        }
    }
}
