// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.contact.v3.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.contact.v3.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class UserOrder {
    /**
     * 排序信息对应的部门ID， ID值与查询参数中的department_id_type 对应。;;表示用户所在的、且需要排序的部门。;;不同 ID 的说明参见及获取方式参见 [部门ID说明](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/contact-v3/department/field-overview)
     * <p> 示例值：od-4e6ac4d14bcd5071a37a39de902c7141
     */
    @SerializedName("department_id")
    private String departmentId;
    /**
     * 用户在其直属部门内的排序，数值越大，排序越靠前
     * <p> 示例值：100
     */
    @SerializedName("user_order")
    private Integer userOrder;
    /**
     * 用户所属的多个部门间的排序，数值越大，排序越靠前
     * <p> 示例值：100
     */
    @SerializedName("department_order")
    private Integer departmentOrder;
    /**
     * 是否为用户主部门
     * <p> 示例值：true
     */
    @SerializedName("is_primary_dept")
    private Boolean isPrimaryDept;

    // builder 开始
    public UserOrder() {
    }

    public UserOrder(Builder builder) {
        /**
         * 排序信息对应的部门ID， ID值与查询参数中的department_id_type 对应。;;表示用户所在的、且需要排序的部门。;;不同 ID 的说明参见及获取方式参见 [部门ID说明](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/contact-v3/department/field-overview)
         * <p> 示例值：od-4e6ac4d14bcd5071a37a39de902c7141
         */
        this.departmentId = builder.departmentId;
        /**
         * 用户在其直属部门内的排序，数值越大，排序越靠前
         * <p> 示例值：100
         */
        this.userOrder = builder.userOrder;
        /**
         * 用户所属的多个部门间的排序，数值越大，排序越靠前
         * <p> 示例值：100
         */
        this.departmentOrder = builder.departmentOrder;
        /**
         * 是否为用户主部门
         * <p> 示例值：true
         */
        this.isPrimaryDept = builder.isPrimaryDept;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getDepartmentId() {
        return this.departmentId;
    }

    public void setDepartmentId(String departmentId) {
        this.departmentId = departmentId;
    }

    public Integer getUserOrder() {
        return this.userOrder;
    }

    public void setUserOrder(Integer userOrder) {
        this.userOrder = userOrder;
    }

    public Integer getDepartmentOrder() {
        return this.departmentOrder;
    }

    public void setDepartmentOrder(Integer departmentOrder) {
        this.departmentOrder = departmentOrder;
    }

    public Boolean getIsPrimaryDept() {
        return this.isPrimaryDept;
    }

    public void setIsPrimaryDept(Boolean isPrimaryDept) {
        this.isPrimaryDept = isPrimaryDept;
    }

    public static class Builder {
        /**
         * 排序信息对应的部门ID， ID值与查询参数中的department_id_type 对应。;;表示用户所在的、且需要排序的部门。;;不同 ID 的说明参见及获取方式参见 [部门ID说明](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/contact-v3/department/field-overview)
         * <p> 示例值：od-4e6ac4d14bcd5071a37a39de902c7141
         */
        private String departmentId;
        /**
         * 用户在其直属部门内的排序，数值越大，排序越靠前
         * <p> 示例值：100
         */
        private Integer userOrder;
        /**
         * 用户所属的多个部门间的排序，数值越大，排序越靠前
         * <p> 示例值：100
         */
        private Integer departmentOrder;
        /**
         * 是否为用户主部门
         * <p> 示例值：true
         */
        private Boolean isPrimaryDept;

        /**
         * 排序信息对应的部门ID， ID值与查询参数中的department_id_type 对应。;;表示用户所在的、且需要排序的部门。;;不同 ID 的说明参见及获取方式参见 [部门ID说明](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/contact-v3/department/field-overview)
         * <p> 示例值：od-4e6ac4d14bcd5071a37a39de902c7141
         *
         * @param departmentId
         * @return
         */
        public Builder departmentId(String departmentId) {
            this.departmentId = departmentId;
            return this;
        }


        /**
         * 用户在其直属部门内的排序，数值越大，排序越靠前
         * <p> 示例值：100
         *
         * @param userOrder
         * @return
         */
        public Builder userOrder(Integer userOrder) {
            this.userOrder = userOrder;
            return this;
        }


        /**
         * 用户所属的多个部门间的排序，数值越大，排序越靠前
         * <p> 示例值：100
         *
         * @param departmentOrder
         * @return
         */
        public Builder departmentOrder(Integer departmentOrder) {
            this.departmentOrder = departmentOrder;
            return this;
        }


        /**
         * 是否为用户主部门
         * <p> 示例值：true
         *
         * @param isPrimaryDept
         * @return
         */
        public Builder isPrimaryDept(Boolean isPrimaryDept) {
            this.isPrimaryDept = isPrimaryDept;
            return this;
        }


        public UserOrder build() {
            return new UserOrder(this);
        }
    }
}
