// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.payroll.v1.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.payroll.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class DatasourceField {
    /**
     * 数据源字段编码
     * <p> 示例值：test__c
     */
    @SerializedName("code")
    private String code;
    /**
     * 数据源字段名称
     * <p> 示例值：
     */
    @SerializedName("i18n_names")
    private I18nContent[] i18nNames;
    /**
     * 字段类型
     * <p> 示例值：1
     */
    @SerializedName("field_type")
    private Integer fieldType;
    /**
     * 字段启停用状态
     * <p> 示例值：1
     */
    @SerializedName("active_status")
    private Integer activeStatus;
    /**
     * 数据源字段描述
     * <p> 示例值：
     */
    @SerializedName("i18n_description")
    private I18nContent[] i18nDescription;
    /**
     * 保留小数位数。目前只有number、money类型字段需要设置保留小数
     * <p> 示例值：1
     */
    @SerializedName("decimal_places")
    private Integer decimalPlaces;

    // builder 开始
    public DatasourceField() {
    }

    public DatasourceField(Builder builder) {
        /**
         * 数据源字段编码
         * <p> 示例值：test__c
         */
        this.code = builder.code;
        /**
         * 数据源字段名称
         * <p> 示例值：
         */
        this.i18nNames = builder.i18nNames;
        /**
         * 字段类型
         * <p> 示例值：1
         */
        this.fieldType = builder.fieldType;
        /**
         * 字段启停用状态
         * <p> 示例值：1
         */
        this.activeStatus = builder.activeStatus;
        /**
         * 数据源字段描述
         * <p> 示例值：
         */
        this.i18nDescription = builder.i18nDescription;
        /**
         * 保留小数位数。目前只有number、money类型字段需要设置保留小数
         * <p> 示例值：1
         */
        this.decimalPlaces = builder.decimalPlaces;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public I18nContent[] getI18nNames() {
        return this.i18nNames;
    }

    public void setI18nNames(I18nContent[] i18nNames) {
        this.i18nNames = i18nNames;
    }

    public Integer getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(Integer fieldType) {
        this.fieldType = fieldType;
    }

    public Integer getActiveStatus() {
        return this.activeStatus;
    }

    public void setActiveStatus(Integer activeStatus) {
        this.activeStatus = activeStatus;
    }

    public I18nContent[] getI18nDescription() {
        return this.i18nDescription;
    }

    public void setI18nDescription(I18nContent[] i18nDescription) {
        this.i18nDescription = i18nDescription;
    }

    public Integer getDecimalPlaces() {
        return this.decimalPlaces;
    }

    public void setDecimalPlaces(Integer decimalPlaces) {
        this.decimalPlaces = decimalPlaces;
    }

    public static class Builder {
        /**
         * 数据源字段编码
         * <p> 示例值：test__c
         */
        private String code;
        /**
         * 数据源字段名称
         * <p> 示例值：
         */
        private I18nContent[] i18nNames;
        /**
         * 字段类型
         * <p> 示例值：1
         */
        private Integer fieldType;
        /**
         * 字段启停用状态
         * <p> 示例值：1
         */
        private Integer activeStatus;
        /**
         * 数据源字段描述
         * <p> 示例值：
         */
        private I18nContent[] i18nDescription;
        /**
         * 保留小数位数。目前只有number、money类型字段需要设置保留小数
         * <p> 示例值：1
         */
        private Integer decimalPlaces;

        /**
         * 数据源字段编码
         * <p> 示例值：test__c
         *
         * @param code
         * @return
         */
        public Builder code(String code) {
            this.code = code;
            return this;
        }


        /**
         * 数据源字段名称
         * <p> 示例值：
         *
         * @param i18nNames
         * @return
         */
        public Builder i18nNames(I18nContent[] i18nNames) {
            this.i18nNames = i18nNames;
            return this;
        }


        /**
         * 字段类型
         * <p> 示例值：1
         *
         * @param fieldType
         * @return
         */
        public Builder fieldType(Integer fieldType) {
            this.fieldType = fieldType;
            return this;
        }

        /**
         * 字段类型
         * <p> 示例值：1
         *
         * @param fieldType {@link com.lark.oapi.service.payroll.v1.enums.DatasourceFieldFieldTypeEnum}
         * @return
         */
        public Builder fieldType(com.lark.oapi.service.payroll.v1.enums.DatasourceFieldFieldTypeEnum fieldType) {
            this.fieldType = fieldType.getValue();
            return this;
        }


        /**
         * 字段启停用状态
         * <p> 示例值：1
         *
         * @param activeStatus
         * @return
         */
        public Builder activeStatus(Integer activeStatus) {
            this.activeStatus = activeStatus;
            return this;
        }

        /**
         * 字段启停用状态
         * <p> 示例值：1
         *
         * @param activeStatus {@link com.lark.oapi.service.payroll.v1.enums.DatasourceFieldActiveStatusEnum}
         * @return
         */
        public Builder activeStatus(com.lark.oapi.service.payroll.v1.enums.DatasourceFieldActiveStatusEnum activeStatus) {
            this.activeStatus = activeStatus.getValue();
            return this;
        }


        /**
         * 数据源字段描述
         * <p> 示例值：
         *
         * @param i18nDescription
         * @return
         */
        public Builder i18nDescription(I18nContent[] i18nDescription) {
            this.i18nDescription = i18nDescription;
            return this;
        }


        /**
         * 保留小数位数。目前只有number、money类型字段需要设置保留小数
         * <p> 示例值：1
         *
         * @param decimalPlaces
         * @return
         */
        public Builder decimalPlaces(Integer decimalPlaces) {
            this.decimalPlaces = decimalPlaces;
            return this;
        }


        public DatasourceField build() {
            return new DatasourceField(this);
        }
    }
}
