// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.application.v6.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.application.v6.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class DepartmentOverviewApplicationAppUsageReqBody {
    /**
     * 查询日期，格式为yyyy-mm-dd，若cycle_type为1，date可以为任何自然日；若cycle_type为2，则输入的date必须为周一； 若cycle_type为3，则输入的date必须为每月1号
     * <p> 示例值：2021-07-08
     */
    @SerializedName("date")
    private String date;
    /**
     * 活跃周期的统计类型
     * <p> 示例值：1
     */
    @SerializedName("cycle_type")
    private Integer cycleType;
    /**
     * 查询的部门id，获取方法可参考[部门ID概述](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/contact-v3/department/field-overview);-  若部门id为空，则返回当前租户的使用数据；若填写部门id，则返回当前部门的使用数据（包含子部门的用户） 以及多级子部门的使用数据。;-  若路径参数中department_id_type为空或者为open_department_id，则此处应该填写部门的 open_department_id；若路径参数中department_id_type为department_id，则此处应该填写部门的 department_id。;- 若不填写则返回整个租户的数据
     * <p> 示例值：od-4e6ac4d14bcd5071a37a39de902c7141
     */
    @SerializedName("department_id")
    private String departmentId;
    /**
     * 是否需要查询部门下多层子部门的数据。未设置或为0时，仅查询department_id对应的部门。设置为n时，查询department_id及其n级子部门的数据。仅在department_id参数传递时有效，最大值为4。
     * <p> 示例值：0
     */
    @SerializedName("recursion")
    private Integer recursion;
    /**
     * 分页大小，取值范围 1~20
     * <p> 示例值：10
     */
    @SerializedName("page_size")
    private Integer pageSize;
    /**
     * 分页标记，第一次请求不填，表示从头开始遍历；当返回的has_more为true时，会返回新的page_token，再次调用接口，传入这个page_token，将获得下一页数据。
     * <p> 示例值：new-1a8f509162ca3c95405838d05ccded09
     */
    @SerializedName("page_token")
    private String pageToken;

    // builder 开始
    public DepartmentOverviewApplicationAppUsageReqBody() {
    }

    public DepartmentOverviewApplicationAppUsageReqBody(Builder builder) {
        /**
         * 查询日期，格式为yyyy-mm-dd，若cycle_type为1，date可以为任何自然日；若cycle_type为2，则输入的date必须为周一； 若cycle_type为3，则输入的date必须为每月1号
         * <p> 示例值：2021-07-08
         */
        this.date = builder.date;
        /**
         * 活跃周期的统计类型
         * <p> 示例值：1
         */
        this.cycleType = builder.cycleType;
        /**
         * 查询的部门id，获取方法可参考[部门ID概述](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/contact-v3/department/field-overview);-  若部门id为空，则返回当前租户的使用数据；若填写部门id，则返回当前部门的使用数据（包含子部门的用户） 以及多级子部门的使用数据。;-  若路径参数中department_id_type为空或者为open_department_id，则此处应该填写部门的 open_department_id；若路径参数中department_id_type为department_id，则此处应该填写部门的 department_id。;- 若不填写则返回整个租户的数据
         * <p> 示例值：od-4e6ac4d14bcd5071a37a39de902c7141
         */
        this.departmentId = builder.departmentId;
        /**
         * 是否需要查询部门下多层子部门的数据。未设置或为0时，仅查询department_id对应的部门。设置为n时，查询department_id及其n级子部门的数据。仅在department_id参数传递时有效，最大值为4。
         * <p> 示例值：0
         */
        this.recursion = builder.recursion;
        /**
         * 分页大小，取值范围 1~20
         * <p> 示例值：10
         */
        this.pageSize = builder.pageSize;
        /**
         * 分页标记，第一次请求不填，表示从头开始遍历；当返回的has_more为true时，会返回新的page_token，再次调用接口，传入这个page_token，将获得下一页数据。
         * <p> 示例值：new-1a8f509162ca3c95405838d05ccded09
         */
        this.pageToken = builder.pageToken;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public Integer getCycleType() {
        return this.cycleType;
    }

    public void setCycleType(Integer cycleType) {
        this.cycleType = cycleType;
    }

    public String getDepartmentId() {
        return this.departmentId;
    }

    public void setDepartmentId(String departmentId) {
        this.departmentId = departmentId;
    }

    public Integer getRecursion() {
        return this.recursion;
    }

    public void setRecursion(Integer recursion) {
        this.recursion = recursion;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getPageToken() {
        return this.pageToken;
    }

    public void setPageToken(String pageToken) {
        this.pageToken = pageToken;
    }

    public static class Builder {
        /**
         * 查询日期，格式为yyyy-mm-dd，若cycle_type为1，date可以为任何自然日；若cycle_type为2，则输入的date必须为周一； 若cycle_type为3，则输入的date必须为每月1号
         * <p> 示例值：2021-07-08
         */
        private String date;
        /**
         * 活跃周期的统计类型
         * <p> 示例值：1
         */
        private Integer cycleType;
        /**
         * 查询的部门id，获取方法可参考[部门ID概述](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/contact-v3/department/field-overview);-  若部门id为空，则返回当前租户的使用数据；若填写部门id，则返回当前部门的使用数据（包含子部门的用户） 以及多级子部门的使用数据。;-  若路径参数中department_id_type为空或者为open_department_id，则此处应该填写部门的 open_department_id；若路径参数中department_id_type为department_id，则此处应该填写部门的 department_id。;- 若不填写则返回整个租户的数据
         * <p> 示例值：od-4e6ac4d14bcd5071a37a39de902c7141
         */
        private String departmentId;
        /**
         * 是否需要查询部门下多层子部门的数据。未设置或为0时，仅查询department_id对应的部门。设置为n时，查询department_id及其n级子部门的数据。仅在department_id参数传递时有效，最大值为4。
         * <p> 示例值：0
         */
        private Integer recursion;
        /**
         * 分页大小，取值范围 1~20
         * <p> 示例值：10
         */
        private Integer pageSize;
        /**
         * 分页标记，第一次请求不填，表示从头开始遍历；当返回的has_more为true时，会返回新的page_token，再次调用接口，传入这个page_token，将获得下一页数据。
         * <p> 示例值：new-1a8f509162ca3c95405838d05ccded09
         */
        private String pageToken;

        /**
         * 查询日期，格式为yyyy-mm-dd，若cycle_type为1，date可以为任何自然日；若cycle_type为2，则输入的date必须为周一； 若cycle_type为3，则输入的date必须为每月1号
         * <p> 示例值：2021-07-08
         *
         * @param date
         * @return
         */
        public Builder date(String date) {
            this.date = date;
            return this;
        }


        /**
         * 活跃周期的统计类型
         * <p> 示例值：1
         *
         * @param cycleType
         * @return
         */
        public Builder cycleType(Integer cycleType) {
            this.cycleType = cycleType;
            return this;
        }

        /**
         * 活跃周期的统计类型
         * <p> 示例值：1
         *
         * @param cycleType {@link com.lark.oapi.service.application.v6.enums.DepartmentOverviewApplicationAppUsageCycleTypeEnum}
         * @return
         */
        public Builder cycleType(com.lark.oapi.service.application.v6.enums.DepartmentOverviewApplicationAppUsageCycleTypeEnum cycleType) {
            this.cycleType = cycleType.getValue();
            return this;
        }


        /**
         * 查询的部门id，获取方法可参考[部门ID概述](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/contact-v3/department/field-overview);-  若部门id为空，则返回当前租户的使用数据；若填写部门id，则返回当前部门的使用数据（包含子部门的用户） 以及多级子部门的使用数据。;-  若路径参数中department_id_type为空或者为open_department_id，则此处应该填写部门的 open_department_id；若路径参数中department_id_type为department_id，则此处应该填写部门的 department_id。;- 若不填写则返回整个租户的数据
         * <p> 示例值：od-4e6ac4d14bcd5071a37a39de902c7141
         *
         * @param departmentId
         * @return
         */
        public Builder departmentId(String departmentId) {
            this.departmentId = departmentId;
            return this;
        }


        /**
         * 是否需要查询部门下多层子部门的数据。未设置或为0时，仅查询department_id对应的部门。设置为n时，查询department_id及其n级子部门的数据。仅在department_id参数传递时有效，最大值为4。
         * <p> 示例值：0
         *
         * @param recursion
         * @return
         */
        public Builder recursion(Integer recursion) {
            this.recursion = recursion;
            return this;
        }


        /**
         * 分页大小，取值范围 1~20
         * <p> 示例值：10
         *
         * @param pageSize
         * @return
         */
        public Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }


        /**
         * 分页标记，第一次请求不填，表示从头开始遍历；当返回的has_more为true时，会返回新的page_token，再次调用接口，传入这个page_token，将获得下一页数据。
         * <p> 示例值：new-1a8f509162ca3c95405838d05ccded09
         *
         * @param pageToken
         * @return
         */
        public Builder pageToken(String pageToken) {
            this.pageToken = pageToken;
            return this;
        }


        public DepartmentOverviewApplicationAppUsageReqBody build() {
            return new DepartmentOverviewApplicationAppUsageReqBody(this);
        }
    }
}
