// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.board.v1.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.board.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class ConnectorInfo {
    /**
     * 连接图形信息
     * <p> 示例值：
     */
    @SerializedName("attached_object")
    private ConnectorAttachedObject attachedObject;
    /**
     * 连线端点在画布内的坐标，position与attached_object二选一
     * <p> 示例值：
     */
    @SerializedName("position")
    private Point position;
    /**
     * 连线端点箭头样式
     * <p> 示例值：line_arrow
     */
    @SerializedName("arrow_style")
    private String arrowStyle;

    // builder 开始
    public ConnectorInfo() {
    }

    public ConnectorInfo(Builder builder) {
        /**
         * 连接图形信息
         * <p> 示例值：
         */
        this.attachedObject = builder.attachedObject;
        /**
         * 连线端点在画布内的坐标，position与attached_object二选一
         * <p> 示例值：
         */
        this.position = builder.position;
        /**
         * 连线端点箭头样式
         * <p> 示例值：line_arrow
         */
        this.arrowStyle = builder.arrowStyle;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public ConnectorAttachedObject getAttachedObject() {
        return this.attachedObject;
    }

    public void setAttachedObject(ConnectorAttachedObject attachedObject) {
        this.attachedObject = attachedObject;
    }

    public Point getPosition() {
        return this.position;
    }

    public void setPosition(Point position) {
        this.position = position;
    }

    public String getArrowStyle() {
        return this.arrowStyle;
    }

    public void setArrowStyle(String arrowStyle) {
        this.arrowStyle = arrowStyle;
    }

    public static class Builder {
        /**
         * 连接图形信息
         * <p> 示例值：
         */
        private ConnectorAttachedObject attachedObject;
        /**
         * 连线端点在画布内的坐标，position与attached_object二选一
         * <p> 示例值：
         */
        private Point position;
        /**
         * 连线端点箭头样式
         * <p> 示例值：line_arrow
         */
        private String arrowStyle;

        /**
         * 连接图形信息
         * <p> 示例值：
         *
         * @param attachedObject
         * @return
         */
        public Builder attachedObject(ConnectorAttachedObject attachedObject) {
            this.attachedObject = attachedObject;
            return this;
        }


        /**
         * 连线端点在画布内的坐标，position与attached_object二选一
         * <p> 示例值：
         *
         * @param position
         * @return
         */
        public Builder position(Point position) {
            this.position = position;
            return this;
        }


        /**
         * 连线端点箭头样式
         * <p> 示例值：line_arrow
         *
         * @param arrowStyle
         * @return
         */
        public Builder arrowStyle(String arrowStyle) {
            this.arrowStyle = arrowStyle;
            return this;
        }

        /**
         * 连线端点箭头样式
         * <p> 示例值：line_arrow
         *
         * @param arrowStyle {@link com.lark.oapi.service.board.v1.enums.ConnectorInfoConnectorArrowStyleEnum}
         * @return
         */
        public Builder arrowStyle(com.lark.oapi.service.board.v1.enums.ConnectorInfoConnectorArrowStyleEnum arrowStyle) {
            this.arrowStyle = arrowStyle.getValue();
            return this;
        }


        public ConnectorInfo build() {
            return new ConnectorInfo(this);
        }
    }
}
