// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.board.v1.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.board.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class MindMapRoot {
    /**
     * 思维导图布局方式
     * <p> 示例值：
     */
    @SerializedName("layout")
    private String layout;
    /**
     * 思维导图根节点图形类型
     * <p> 示例值：
     */
    @SerializedName("type")
    private String type;
    /**
     * 思维导图图形连接线样式
     * <p> 示例值：
     */
    @SerializedName("line_style")
    private String lineStyle;
    /**
     * 思维导图上布局子节点关系树
     * <p> 示例值：
     */
    @SerializedName("up_children")
    private String[] upChildren;
    /**
     * 思维导图下布局子节点关系树
     * <p> 示例值：
     */
    @SerializedName("down_children")
    private String[] downChildren;
    /**
     * 思维导图左布局子节点关系树
     * <p> 示例值：
     */
    @SerializedName("left_children")
    private String[] leftChildren;
    /**
     * 思维导图右布局子节点关系树
     * <p> 示例值：
     */
    @SerializedName("right_children")
    private String[] rightChildren;

    // builder 开始
    public MindMapRoot() {
    }

    public MindMapRoot(Builder builder) {
        /**
         * 思维导图布局方式
         * <p> 示例值：
         */
        this.layout = builder.layout;
        /**
         * 思维导图根节点图形类型
         * <p> 示例值：
         */
        this.type = builder.type;
        /**
         * 思维导图图形连接线样式
         * <p> 示例值：
         */
        this.lineStyle = builder.lineStyle;
        /**
         * 思维导图上布局子节点关系树
         * <p> 示例值：
         */
        this.upChildren = builder.upChildren;
        /**
         * 思维导图下布局子节点关系树
         * <p> 示例值：
         */
        this.downChildren = builder.downChildren;
        /**
         * 思维导图左布局子节点关系树
         * <p> 示例值：
         */
        this.leftChildren = builder.leftChildren;
        /**
         * 思维导图右布局子节点关系树
         * <p> 示例值：
         */
        this.rightChildren = builder.rightChildren;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getLayout() {
        return this.layout;
    }

    public void setLayout(String layout) {
        this.layout = layout;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getLineStyle() {
        return this.lineStyle;
    }

    public void setLineStyle(String lineStyle) {
        this.lineStyle = lineStyle;
    }

    public String[] getUpChildren() {
        return this.upChildren;
    }

    public void setUpChildren(String[] upChildren) {
        this.upChildren = upChildren;
    }

    public String[] getDownChildren() {
        return this.downChildren;
    }

    public void setDownChildren(String[] downChildren) {
        this.downChildren = downChildren;
    }

    public String[] getLeftChildren() {
        return this.leftChildren;
    }

    public void setLeftChildren(String[] leftChildren) {
        this.leftChildren = leftChildren;
    }

    public String[] getRightChildren() {
        return this.rightChildren;
    }

    public void setRightChildren(String[] rightChildren) {
        this.rightChildren = rightChildren;
    }

    public static class Builder {
        /**
         * 思维导图布局方式
         * <p> 示例值：
         */
        private String layout;
        /**
         * 思维导图根节点图形类型
         * <p> 示例值：
         */
        private String type;
        /**
         * 思维导图图形连接线样式
         * <p> 示例值：
         */
        private String lineStyle;
        /**
         * 思维导图上布局子节点关系树
         * <p> 示例值：
         */
        private String[] upChildren;
        /**
         * 思维导图下布局子节点关系树
         * <p> 示例值：
         */
        private String[] downChildren;
        /**
         * 思维导图左布局子节点关系树
         * <p> 示例值：
         */
        private String[] leftChildren;
        /**
         * 思维导图右布局子节点关系树
         * <p> 示例值：
         */
        private String[] rightChildren;

        /**
         * 思维导图布局方式
         * <p> 示例值：
         *
         * @param layout
         * @return
         */
        public Builder layout(String layout) {
            this.layout = layout;
            return this;
        }

        /**
         * 思维导图布局方式
         * <p> 示例值：
         *
         * @param layout {@link com.lark.oapi.service.board.v1.enums.MindMapRootMindMapLayoutEnum}
         * @return
         */
        public Builder layout(com.lark.oapi.service.board.v1.enums.MindMapRootMindMapLayoutEnum layout) {
            this.layout = layout.getValue();
            return this;
        }


        /**
         * 思维导图根节点图形类型
         * <p> 示例值：
         *
         * @param type
         * @return
         */
        public Builder type(String type) {
            this.type = type;
            return this;
        }

        /**
         * 思维导图根节点图形类型
         * <p> 示例值：
         *
         * @param type {@link com.lark.oapi.service.board.v1.enums.MindMapRootMindMapTypeEnum}
         * @return
         */
        public Builder type(com.lark.oapi.service.board.v1.enums.MindMapRootMindMapTypeEnum type) {
            this.type = type.getValue();
            return this;
        }


        /**
         * 思维导图图形连接线样式
         * <p> 示例值：
         *
         * @param lineStyle
         * @return
         */
        public Builder lineStyle(String lineStyle) {
            this.lineStyle = lineStyle;
            return this;
        }

        /**
         * 思维导图图形连接线样式
         * <p> 示例值：
         *
         * @param lineStyle {@link com.lark.oapi.service.board.v1.enums.MindMapRootLineStyleEnum}
         * @return
         */
        public Builder lineStyle(com.lark.oapi.service.board.v1.enums.MindMapRootLineStyleEnum lineStyle) {
            this.lineStyle = lineStyle.getValue();
            return this;
        }


        /**
         * 思维导图上布局子节点关系树
         * <p> 示例值：
         *
         * @param upChildren
         * @return
         */
        public Builder upChildren(String[] upChildren) {
            this.upChildren = upChildren;
            return this;
        }


        /**
         * 思维导图下布局子节点关系树
         * <p> 示例值：
         *
         * @param downChildren
         * @return
         */
        public Builder downChildren(String[] downChildren) {
            this.downChildren = downChildren;
            return this;
        }


        /**
         * 思维导图左布局子节点关系树
         * <p> 示例值：
         *
         * @param leftChildren
         * @return
         */
        public Builder leftChildren(String[] leftChildren) {
            this.leftChildren = leftChildren;
            return this;
        }


        /**
         * 思维导图右布局子节点关系树
         * <p> 示例值：
         *
         * @param rightChildren
         * @return
         */
        public Builder rightChildren(String[] rightChildren) {
            this.rightChildren = rightChildren;
            return this;
        }


        public MindMapRoot build() {
            return new MindMapRoot(this);
        }
    }
}
