// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.board.v1.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.board.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class Style {
    /**
     * 填充颜色，16 进制 rbg 值
     * <p> 示例值：#6db5a3
     */
    @SerializedName("fill_color")
    private String fillColor;
    /**
     * 填充透明度
     * <p> 示例值：50
     */
    @SerializedName("fill_opacity")
    private Double fillOpacity;
    /**
     * 边框样式
     * <p> 示例值：
     */
    @SerializedName("border_style")
    private String borderStyle;
    /**
     * 边框宽度
     * <p> 示例值：
     */
    @SerializedName("border_width")
    private String borderWidth;
    /**
     * 边框透明度
     * <p> 示例值：50
     */
    @SerializedName("border_opacity")
    private Double borderOpacity;
    /**
     * 水平翻折
     * <p> 示例值：false
     */
    @SerializedName("h_flip")
    private Boolean hFlip;
    /**
     * 垂直翻折
     * <p> 示例值：false
     */
    @SerializedName("v_flip")
    private Boolean vFlip;
    /**
     * 边框颜色，16 进制 rgb 值
     * <p> 示例值：#6db5a3
     */
    @SerializedName("border_color")
    private String borderColor;
    /**
     * 填充颜色主题配色编码值
     * <p> 示例值：3
     */
    @SerializedName("theme_fill_color_code")
    private Integer themeFillColorCode;
    /**
     * 边框颜色主题配色编码值
     * <p> 示例值：4
     */
    @SerializedName("theme_border_color_code")
    private Integer themeBorderColorCode;

    // builder 开始
    public Style() {
    }

    public Style(Builder builder) {
        /**
         * 填充颜色，16 进制 rbg 值
         * <p> 示例值：#6db5a3
         */
        this.fillColor = builder.fillColor;
        /**
         * 填充透明度
         * <p> 示例值：50
         */
        this.fillOpacity = builder.fillOpacity;
        /**
         * 边框样式
         * <p> 示例值：
         */
        this.borderStyle = builder.borderStyle;
        /**
         * 边框宽度
         * <p> 示例值：
         */
        this.borderWidth = builder.borderWidth;
        /**
         * 边框透明度
         * <p> 示例值：50
         */
        this.borderOpacity = builder.borderOpacity;
        /**
         * 水平翻折
         * <p> 示例值：false
         */
        this.hFlip = builder.hFlip;
        /**
         * 垂直翻折
         * <p> 示例值：false
         */
        this.vFlip = builder.vFlip;
        /**
         * 边框颜色，16 进制 rgb 值
         * <p> 示例值：#6db5a3
         */
        this.borderColor = builder.borderColor;
        /**
         * 填充颜色主题配色编码值
         * <p> 示例值：3
         */
        this.themeFillColorCode = builder.themeFillColorCode;
        /**
         * 边框颜色主题配色编码值
         * <p> 示例值：4
         */
        this.themeBorderColorCode = builder.themeBorderColorCode;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(String fillColor) {
        this.fillColor = fillColor;
    }

    public Double getFillOpacity() {
        return this.fillOpacity;
    }

    public void setFillOpacity(Double fillOpacity) {
        this.fillOpacity = fillOpacity;
    }

    public String getBorderStyle() {
        return this.borderStyle;
    }

    public void setBorderStyle(String borderStyle) {
        this.borderStyle = borderStyle;
    }

    public String getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(String borderWidth) {
        this.borderWidth = borderWidth;
    }

    public Double getBorderOpacity() {
        return this.borderOpacity;
    }

    public void setBorderOpacity(Double borderOpacity) {
        this.borderOpacity = borderOpacity;
    }

    public Boolean getHFlip() {
        return this.hFlip;
    }

    public void setHFlip(Boolean hFlip) {
        this.hFlip = hFlip;
    }

    public Boolean getVFlip() {
        return this.vFlip;
    }

    public void setVFlip(Boolean vFlip) {
        this.vFlip = vFlip;
    }

    public String getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(String borderColor) {
        this.borderColor = borderColor;
    }

    public Integer getThemeFillColorCode() {
        return this.themeFillColorCode;
    }

    public void setThemeFillColorCode(Integer themeFillColorCode) {
        this.themeFillColorCode = themeFillColorCode;
    }

    public Integer getThemeBorderColorCode() {
        return this.themeBorderColorCode;
    }

    public void setThemeBorderColorCode(Integer themeBorderColorCode) {
        this.themeBorderColorCode = themeBorderColorCode;
    }

    public static class Builder {
        /**
         * 填充颜色，16 进制 rbg 值
         * <p> 示例值：#6db5a3
         */
        private String fillColor;
        /**
         * 填充透明度
         * <p> 示例值：50
         */
        private Double fillOpacity;
        /**
         * 边框样式
         * <p> 示例值：
         */
        private String borderStyle;
        /**
         * 边框宽度
         * <p> 示例值：
         */
        private String borderWidth;
        /**
         * 边框透明度
         * <p> 示例值：50
         */
        private Double borderOpacity;
        /**
         * 水平翻折
         * <p> 示例值：false
         */
        private Boolean hFlip;
        /**
         * 垂直翻折
         * <p> 示例值：false
         */
        private Boolean vFlip;
        /**
         * 边框颜色，16 进制 rgb 值
         * <p> 示例值：#6db5a3
         */
        private String borderColor;
        /**
         * 填充颜色主题配色编码值
         * <p> 示例值：3
         */
        private Integer themeFillColorCode;
        /**
         * 边框颜色主题配色编码值
         * <p> 示例值：4
         */
        private Integer themeBorderColorCode;

        /**
         * 填充颜色，16 进制 rbg 值
         * <p> 示例值：#6db5a3
         *
         * @param fillColor
         * @return
         */
        public Builder fillColor(String fillColor) {
            this.fillColor = fillColor;
            return this;
        }


        /**
         * 填充透明度
         * <p> 示例值：50
         *
         * @param fillOpacity
         * @return
         */
        public Builder fillOpacity(Double fillOpacity) {
            this.fillOpacity = fillOpacity;
            return this;
        }


        /**
         * 边框样式
         * <p> 示例值：
         *
         * @param borderStyle
         * @return
         */
        public Builder borderStyle(String borderStyle) {
            this.borderStyle = borderStyle;
            return this;
        }

        /**
         * 边框样式
         * <p> 示例值：
         *
         * @param borderStyle {@link com.lark.oapi.service.board.v1.enums.StyleBorderStyleEnum}
         * @return
         */
        public Builder borderStyle(com.lark.oapi.service.board.v1.enums.StyleBorderStyleEnum borderStyle) {
            this.borderStyle = borderStyle.getValue();
            return this;
        }


        /**
         * 边框宽度
         * <p> 示例值：
         *
         * @param borderWidth
         * @return
         */
        public Builder borderWidth(String borderWidth) {
            this.borderWidth = borderWidth;
            return this;
        }

        /**
         * 边框宽度
         * <p> 示例值：
         *
         * @param borderWidth {@link com.lark.oapi.service.board.v1.enums.StyleBorderWidthEnum}
         * @return
         */
        public Builder borderWidth(com.lark.oapi.service.board.v1.enums.StyleBorderWidthEnum borderWidth) {
            this.borderWidth = borderWidth.getValue();
            return this;
        }


        /**
         * 边框透明度
         * <p> 示例值：50
         *
         * @param borderOpacity
         * @return
         */
        public Builder borderOpacity(Double borderOpacity) {
            this.borderOpacity = borderOpacity;
            return this;
        }


        /**
         * 水平翻折
         * <p> 示例值：false
         *
         * @param hFlip
         * @return
         */
        public Builder hFlip(Boolean hFlip) {
            this.hFlip = hFlip;
            return this;
        }


        /**
         * 垂直翻折
         * <p> 示例值：false
         *
         * @param vFlip
         * @return
         */
        public Builder vFlip(Boolean vFlip) {
            this.vFlip = vFlip;
            return this;
        }


        /**
         * 边框颜色，16 进制 rgb 值
         * <p> 示例值：#6db5a3
         *
         * @param borderColor
         * @return
         */
        public Builder borderColor(String borderColor) {
            this.borderColor = borderColor;
            return this;
        }


        /**
         * 填充颜色主题配色编码值
         * <p> 示例值：3
         *
         * @param themeFillColorCode
         * @return
         */
        public Builder themeFillColorCode(Integer themeFillColorCode) {
            this.themeFillColorCode = themeFillColorCode;
            return this;
        }


        /**
         * 边框颜色主题配色编码值
         * <p> 示例值：4
         *
         * @param themeBorderColorCode
         * @return
         */
        public Builder themeBorderColorCode(Integer themeBorderColorCode) {
            this.themeBorderColorCode = themeBorderColorCode;
            return this;
        }


        public Style build() {
            return new Style(this);
        }
    }
}
