// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.board.v1.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.board.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class TableMeta {
    /**
     * 行数
     * <p> 示例值：3
     */
    @SerializedName("row_num")
    private Integer rowNum;
    /**
     * 列数
     * <p> 示例值：2
     */
    @SerializedName("col_num")
    private Integer colNum;
    /**
     * 行高
     * <p> 示例值：
     */
    @SerializedName("row_sizes")
    private Double[] rowSizes;
    /**
     * 列宽
     * <p> 示例值：
     */
    @SerializedName("col_sizes")
    private Double[] colSizes;
    /**
     * 整个表格的样式
     * <p> 示例值：
     */
    @SerializedName("style")
    private Style style;
    /**
     * 整个表格的文字样式
     * <p> 示例值：
     */
    @SerializedName("text")
    private Text text;

    // builder 开始
    public TableMeta() {
    }

    public TableMeta(Builder builder) {
        /**
         * 行数
         * <p> 示例值：3
         */
        this.rowNum = builder.rowNum;
        /**
         * 列数
         * <p> 示例值：2
         */
        this.colNum = builder.colNum;
        /**
         * 行高
         * <p> 示例值：
         */
        this.rowSizes = builder.rowSizes;
        /**
         * 列宽
         * <p> 示例值：
         */
        this.colSizes = builder.colSizes;
        /**
         * 整个表格的样式
         * <p> 示例值：
         */
        this.style = builder.style;
        /**
         * 整个表格的文字样式
         * <p> 示例值：
         */
        this.text = builder.text;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Integer getRowNum() {
        return this.rowNum;
    }

    public void setRowNum(Integer rowNum) {
        this.rowNum = rowNum;
    }

    public Integer getColNum() {
        return this.colNum;
    }

    public void setColNum(Integer colNum) {
        this.colNum = colNum;
    }

    public Double[] getRowSizes() {
        return this.rowSizes;
    }

    public void setRowSizes(Double[] rowSizes) {
        this.rowSizes = rowSizes;
    }

    public Double[] getColSizes() {
        return this.colSizes;
    }

    public void setColSizes(Double[] colSizes) {
        this.colSizes = colSizes;
    }

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public Text getText() {
        return this.text;
    }

    public void setText(Text text) {
        this.text = text;
    }

    public static class Builder {
        /**
         * 行数
         * <p> 示例值：3
         */
        private Integer rowNum;
        /**
         * 列数
         * <p> 示例值：2
         */
        private Integer colNum;
        /**
         * 行高
         * <p> 示例值：
         */
        private Double[] rowSizes;
        /**
         * 列宽
         * <p> 示例值：
         */
        private Double[] colSizes;
        /**
         * 整个表格的样式
         * <p> 示例值：
         */
        private Style style;
        /**
         * 整个表格的文字样式
         * <p> 示例值：
         */
        private Text text;

        /**
         * 行数
         * <p> 示例值：3
         *
         * @param rowNum
         * @return
         */
        public Builder rowNum(Integer rowNum) {
            this.rowNum = rowNum;
            return this;
        }


        /**
         * 列数
         * <p> 示例值：2
         *
         * @param colNum
         * @return
         */
        public Builder colNum(Integer colNum) {
            this.colNum = colNum;
            return this;
        }


        /**
         * 行高
         * <p> 示例值：
         *
         * @param rowSizes
         * @return
         */
        public Builder rowSizes(Double[] rowSizes) {
            this.rowSizes = rowSizes;
            return this;
        }


        /**
         * 列宽
         * <p> 示例值：
         *
         * @param colSizes
         * @return
         */
        public Builder colSizes(Double[] colSizes) {
            this.colSizes = colSizes;
            return this;
        }


        /**
         * 整个表格的样式
         * <p> 示例值：
         *
         * @param style
         * @return
         */
        public Builder style(Style style) {
            this.style = style;
            return this;
        }


        /**
         * 整个表格的文字样式
         * <p> 示例值：
         *
         * @param text
         * @return
         */
        public Builder text(Text text) {
            this.text = text;
            return this;
        }


        public TableMeta build() {
            return new TableMeta(this);
        }
    }
}
