// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.cardkit.v1.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.cardkit.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class CardLink {
    /**
     * 默认的链接地址
     * <p> 示例值：https://www.baidu.com
     */
    @SerializedName("url")
    private String url;
    /**
     * PC端的链接地址
     * <p> 示例值：https://developer.windows.com/
     */
    @SerializedName("pc_url")
    private String pcUrl;
    /**
     * iOS端的链接地址
     * <p> 示例值：https://developer.apple.com/
     */
    @SerializedName("ios_url")
    private String iosUrl;
    /**
     * Android 端的链接地址
     * <p> 示例值：https://developer.android.com/
     */
    @SerializedName("android_url")
    private String androidUrl;

    // builder 开始
    public CardLink() {
    }

    public CardLink(Builder builder) {
        /**
         * 默认的链接地址
         * <p> 示例值：https://www.baidu.com
         */
        this.url = builder.url;
        /**
         * PC端的链接地址
         * <p> 示例值：https://developer.windows.com/
         */
        this.pcUrl = builder.pcUrl;
        /**
         * iOS端的链接地址
         * <p> 示例值：https://developer.apple.com/
         */
        this.iosUrl = builder.iosUrl;
        /**
         * Android 端的链接地址
         * <p> 示例值：https://developer.android.com/
         */
        this.androidUrl = builder.androidUrl;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getPcUrl() {
        return this.pcUrl;
    }

    public void setPcUrl(String pcUrl) {
        this.pcUrl = pcUrl;
    }

    public String getIosUrl() {
        return this.iosUrl;
    }

    public void setIosUrl(String iosUrl) {
        this.iosUrl = iosUrl;
    }

    public String getAndroidUrl() {
        return this.androidUrl;
    }

    public void setAndroidUrl(String androidUrl) {
        this.androidUrl = androidUrl;
    }

    public static class Builder {
        /**
         * 默认的链接地址
         * <p> 示例值：https://www.baidu.com
         */
        private String url;
        /**
         * PC端的链接地址
         * <p> 示例值：https://developer.windows.com/
         */
        private String pcUrl;
        /**
         * iOS端的链接地址
         * <p> 示例值：https://developer.apple.com/
         */
        private String iosUrl;
        /**
         * Android 端的链接地址
         * <p> 示例值：https://developer.android.com/
         */
        private String androidUrl;

        /**
         * 默认的链接地址
         * <p> 示例值：https://www.baidu.com
         *
         * @param url
         * @return
         */
        public Builder url(String url) {
            this.url = url;
            return this;
        }


        /**
         * PC端的链接地址
         * <p> 示例值：https://developer.windows.com/
         *
         * @param pcUrl
         * @return
         */
        public Builder pcUrl(String pcUrl) {
            this.pcUrl = pcUrl;
            return this;
        }


        /**
         * iOS端的链接地址
         * <p> 示例值：https://developer.apple.com/
         *
         * @param iosUrl
         * @return
         */
        public Builder iosUrl(String iosUrl) {
            this.iosUrl = iosUrl;
            return this;
        }


        /**
         * Android 端的链接地址
         * <p> 示例值：https://developer.android.com/
         *
         * @param androidUrl
         * @return
         */
        public Builder androidUrl(String androidUrl) {
            this.androidUrl = androidUrl;
            return this;
        }


        public CardLink build() {
            return new CardLink(this);
        }
    }
}
