// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.compensation.v1.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.compensation.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class SocialArchiveAdjustRecord {
    /**
     * 员工ID
     * <p> 示例值：
     */
    @SerializedName("user_id")
    private String userId;
    /**
     * 类型，increase: 增员; attrition: 减员
     * <p> 示例值：increase
     */
    @SerializedName("record_type")
    private String recordType;
    /**
     * 员工增减员记录，包括社保、公积金记录
     * <p> 示例值：
     */
    @SerializedName("details")
    private SocialArchiveDetail[] details;

    // builder 开始
    public SocialArchiveAdjustRecord() {
    }

    public SocialArchiveAdjustRecord(Builder builder) {
        /**
         * 员工ID
         * <p> 示例值：
         */
        this.userId = builder.userId;
        /**
         * 类型，increase: 增员; attrition: 减员
         * <p> 示例值：increase
         */
        this.recordType = builder.recordType;
        /**
         * 员工增减员记录，包括社保、公积金记录
         * <p> 示例值：
         */
        this.details = builder.details;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getRecordType() {
        return this.recordType;
    }

    public void setRecordType(String recordType) {
        this.recordType = recordType;
    }

    public SocialArchiveDetail[] getDetails() {
        return this.details;
    }

    public void setDetails(SocialArchiveDetail[] details) {
        this.details = details;
    }

    public static class Builder {
        /**
         * 员工ID
         * <p> 示例值：
         */
        private String userId;
        /**
         * 类型，increase: 增员; attrition: 减员
         * <p> 示例值：increase
         */
        private String recordType;
        /**
         * 员工增减员记录，包括社保、公积金记录
         * <p> 示例值：
         */
        private SocialArchiveDetail[] details;

        /**
         * 员工ID
         * <p> 示例值：
         *
         * @param userId
         * @return
         */
        public Builder userId(String userId) {
            this.userId = userId;
            return this;
        }


        /**
         * 类型，increase: 增员; attrition: 减员
         * <p> 示例值：increase
         *
         * @param recordType
         * @return
         */
        public Builder recordType(String recordType) {
            this.recordType = recordType;
            return this;
        }

        /**
         * 类型，increase: 增员; attrition: 减员
         * <p> 示例值：increase
         *
         * @param recordType {@link com.lark.oapi.service.compensation.v1.enums.SocialArchiveAdjustRecordRecordTypeEnum}
         * @return
         */
        public Builder recordType(com.lark.oapi.service.compensation.v1.enums.SocialArchiveAdjustRecordRecordTypeEnum recordType) {
            this.recordType = recordType.getValue();
            return this;
        }


        /**
         * 员工增减员记录，包括社保、公积金记录
         * <p> 示例值：
         *
         * @param details
         * @return
         */
        public Builder details(SocialArchiveDetail[] details) {
            this.details = details;
            return this;
        }


        public SocialArchiveAdjustRecord build() {
            return new SocialArchiveAdjustRecord(this);
        }
    }
}
