// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.corehr.v2.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.corehr.v2.enums.*;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class ListEmployeesInternationalAssignmentReq {
    /**
     * 用户 ID 类型
     * <p> 示例值：open_id
     */
    @Query
    @SerializedName("user_id_type")
    private String userIdType;
    /**
     * 此次调用中使用的部门 ID 类型
     * <p> 示例值：open_department_id
     */
    @Query
    @SerializedName("department_id_type")
    private String departmentIdType;
    /**
     * 分页大小
     * <p> 示例值：100
     */
    @Query
    @SerializedName("page_size")
    private Integer pageSize;
    /**
     * 分页标记，第一次请求不填，表示从头开始遍历；分页查询结果还有更多项时会同时返回新的 page_token，下次遍历可采用该 page_token 获取查询结果
     * <p> 示例值：123456
     */
    @Query
    @SerializedName("page_token")
    private String pageToken;
    /**
     * 雇佣ID;- 可通过[【批量查询员工信息】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/corehr-v2/employee/batch_get)获取详细信息;- 类型必须与 user_id_type 一致
     * <p> 示例值：
     */
    @Query
    @SerializedName("employment_ids")
    private String[] employmentIds;
    /**
     * 外派 ID
     * <p> 示例值：
     */
    @Query
    @SerializedName("international_assignment_ids")
    private String[] internationalAssignmentIds;
    /**
     * 外派开始日期;- 范围筛选，格式：yyyy-mm-dd~yyyy-mm-dd
     * <p> 示例值：- "2024-01-01~2024-02-02";- "~2024-02-02";- "2024-01-01~"
     */
    @Query
    @SerializedName("effective_time")
    private String effectiveTime;
    /**
     * 外派结束日期;- 范围筛选，格式：yyyy-mm-dd~yyyy-mm-dd
     * <p> 示例值：- "2024-01-01~2024-02-02";- "~2024-02-02";- "2024-01-01~"
     */
    @Query
    @SerializedName("expiration_time")
    private String expirationTime;
    /**
     * 雇佣状态;- 可通过[【获取字段详情】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/custom_field/get_by_param)接口查询，查询参数如下：;  - object_api_name：employment;  - custom_api_name：employment_status
     * <p> 示例值：
     */
    @Query
    @SerializedName("employment_status_list")
    private String[] employmentStatusList;
    /**
     * 外派工作地点;- 可通过[【批量查询地点】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/location/list)获取;- 需要以下权限点之一：;  - [读取外派地点](corehr:employment.international_assignment.work_location:read);  - [读写外派地点](corehr:employment.international_assignment.work_location:write)
     * <p> 示例值：
     */
    @Query
    @SerializedName("work_location_id_list")
    private String[] workLocationIdList;
    /**
     * 外派部门;- 可通过[【批量查询部门】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/corehr-v2/department/batch_get)获取;- 类型与 department_id_type 一致
     * <p> 示例值：
     */
    @Query
    @SerializedName("department_id_list")
    private String[] departmentIdList;
    /**
     * 外派直属上级;- 可通过[【批量查询员工信息】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/corehr-v2/employee/batch_get)获取;- 类型与 user_id_type 一致
     * <p> 示例值：
     */
    @Query
    @SerializedName("direct_manager_id_list")
    private String[] directManagerIdList;
    /**
     * 外派虚线上级;- 可通过[【批量查询员工信息】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/corehr-v2/employee/batch_get)获取;- 类型与 user_id_type 一致
     * <p> 示例值：
     */
    @Query
    @SerializedName("dotted_line_manager_id_list")
    private String[] dottedLineManagerIdList;
    /**
     * 外派岗位;- 功能灰度中，请联系[技术支持](https://applink.feishu.cn/TLJpeNdW);- 需要以下权限点之一：;  - [读取外派岗位](corehr:employment.international_assignment.position:read);  - [读写外派岗位](corehr:employment.international_assignment.position:write)
     * <p> 示例值：
     */
    @Query
    @SerializedName("position_id_list")
    private String[] positionIdList;
    /**
     * 外派职务;- 可通过[【批量查询职务】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/corehr-v2/job/list)获取;- 需要以下权限点之一：;    - [读取外派职务](corehr:employment.international_assignment.job:read);    - [读写外派职务](corehr:employment.international_assignment.job:write)
     * <p> 示例值：
     */
    @Query
    @SerializedName("job_id_list")
    private String[] jobIdList;
    /**
     * 外派序列;- 可通过[【批量查询序列】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/job_family/list)获取
     * <p> 示例值：
     */
    @Query
    @SerializedName("job_family_id_list")
    private String[] jobFamilyIdList;
    /**
     * 外派职级;- 可通过[【批量查询职级】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/job_level/list)获取;- 需要以下权限点之一：;    - [读取外派职级](corehr:employment.international_assignment.job_level:read);    - [读写外派职级](corehr:employment.international_assignment.job_level:write)
     * <p> 示例值：
     */
    @Query
    @SerializedName("job_level_id_list")
    private String[] jobLevelIdList;
    /**
     * 外派职等;- 可通过[【查询职等】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/corehr-v2/job_grade/query)获取;- 需要以下权限点之一：;      - [读取外派职等](corehr:employment.international_assignment.job_grade:read);      - [读写外派职等](corehr:employment.international_assignment.job_grade:write)
     * <p> 示例值：
     */
    @Query
    @SerializedName("job_grade_id_list")
    private String[] jobGradeIdList;
    /**
     * 外派工时制度;- 可通过[【批量查询工时制度】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/working_hours_type/list)获取;- 需要以下权限点之一：;      - [读取外派工时制度](corehr:employment.international_assignment.working_hours_type:read);      - [读写外派工时制度](corehr:employment.international_assignment.working_hours_type:write)
     * <p> 示例值：
     */
    @Query
    @SerializedName("working_hours_type_id_list")
    private String[] workingHoursTypeIdList;
    /**
     * 外派任职公司;- 可通过[【批量查询公司】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/company/list)获取;- 需要以下权限点之一：;    - [读取外派公司](corehr:employment.international_assignment.service_company:read);    - [读写外派公司](corehr:employment.international_assignment.service_company:write)
     * <p> 示例值：
     */
    @Query
    @SerializedName("service_company_list")
    private String[] serviceCompanyList;
    /**
     * 外派周工作时长;- 限制两位小数;- 需要以下权限点之一：;    - [读取外派周工作时长](corehr:employment.international_assignment.weekly_working_hours:read);    - [读写外派周工作时长](corehr:employment.international_assignment.weekly_working_hours:write)
     * <p> 示例值：10
     */
    @Query
    @SerializedName("weekly_working_hours_v2")
    private Double weeklyWorkingHoursV2;
    /**
     * 外派排班类型;- 可通过[【获取字段详情】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/custom_field/get_by_param)接口查询，查询参数如下：;    - object_api_name：job_data;    - custom_api_name：work_shift;- 需要以下权限点之一：;    - [读取外派排班类型](corehr:employment.international_assignment.work_shift:read);    - [读写外派排班类型](corehr:employment.international_assignment.work_shift:write)
     * <p> 示例值：
     */
    @Query
    @SerializedName("work_shift_list")
    private String[] workShiftList;
    /**
     * 外派薪资类型;- 可通过[【获取字段详情】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/custom_field/get_by_param)接口查询，查询参数如下：;  - object_api_name：job_data;  - custom_api_name：compensation_type;- 需要以下权限点之一：;  - [读取外派薪资类型](corehr:employment.international_assignment.compensation_type:read);  - [读写外派薪资类型](corehr:employment.international_assignment.compensation_type:write)
     * <p> 示例值：
     */
    @Query
    @SerializedName("compensation_type_list")
    private String[] compensationTypeList;
    /**
     * 外派预计结束日期;- 范围筛选，格式：yyyy-mm-dd~yyyy-mm-dd
     * <p> 示例值：- "2024-01-01~2024-02-02";- "~2024-02-02";- "2024-01-01~"
     */
    @Query
    @SerializedName("international_assignment_expected_end_date")
    private String internationalAssignmentExpectedEndDate;
    /**
     * 外派状态;- 可通过[【获取字段详情】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/custom_field/get_by_param)接口查询，查询参数如下：;    - object_api_name：international_assignment;    - custom_api_name：international_assignment_status
     * <p> 示例值：
     */
    @Query
    @SerializedName("international_assignment_status_list")
    private String[] internationalAssignmentStatusList;
    /**
     * 外派类型;- 可通过[【获取字段详情】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/custom_field/get_by_param)接口查询，查询参数如下：;    - object_api_name：international_assignment;    - custom_api_name：international_assignment_type
     * <p> 示例值：
     */
    @Query
    @SerializedName("international_assignment_type_list")
    private String[] internationalAssignmentTypeList;
    /**
     * 外派工作日历;- 可通过[【查询工作日历】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/leave/work_calendar)获取详细信息;- 需要以下权限点之一：;    - [读取外派工作日历](corehr:employment.international_assignment.work_calendar:read);    - [读写外派工作日历](corehr:employment.international_assignment.work_calendar:write)
     * <p> 示例值：
     */
    @Query
    @SerializedName("work_calendar_id_list")
    private String[] workCalendarIdList;

    // builder 开始
    public ListEmployeesInternationalAssignmentReq() {
    }

    public ListEmployeesInternationalAssignmentReq(Builder builder) {
        /**
         * 用户 ID 类型
         * <p> 示例值：open_id
         */
        this.userIdType = builder.userIdType;
        /**
         * 此次调用中使用的部门 ID 类型
         * <p> 示例值：open_department_id
         */
        this.departmentIdType = builder.departmentIdType;
        /**
         * 分页大小
         * <p> 示例值：100
         */
        this.pageSize = builder.pageSize;
        /**
         * 分页标记，第一次请求不填，表示从头开始遍历；分页查询结果还有更多项时会同时返回新的 page_token，下次遍历可采用该 page_token 获取查询结果
         * <p> 示例值：123456
         */
        this.pageToken = builder.pageToken;
        /**
         * 雇佣ID;- 可通过[【批量查询员工信息】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/corehr-v2/employee/batch_get)获取详细信息;- 类型必须与 user_id_type 一致
         * <p> 示例值：
         */
        this.employmentIds = builder.employmentIds;
        /**
         * 外派 ID
         * <p> 示例值：
         */
        this.internationalAssignmentIds = builder.internationalAssignmentIds;
        /**
         * 外派开始日期;- 范围筛选，格式：yyyy-mm-dd~yyyy-mm-dd
         * <p> 示例值：- "2024-01-01~2024-02-02";- "~2024-02-02";- "2024-01-01~"
         */
        this.effectiveTime = builder.effectiveTime;
        /**
         * 外派结束日期;- 范围筛选，格式：yyyy-mm-dd~yyyy-mm-dd
         * <p> 示例值：- "2024-01-01~2024-02-02";- "~2024-02-02";- "2024-01-01~"
         */
        this.expirationTime = builder.expirationTime;
        /**
         * 雇佣状态;- 可通过[【获取字段详情】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/custom_field/get_by_param)接口查询，查询参数如下：;  - object_api_name：employment;  - custom_api_name：employment_status
         * <p> 示例值：
         */
        this.employmentStatusList = builder.employmentStatusList;
        /**
         * 外派工作地点;- 可通过[【批量查询地点】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/location/list)获取;- 需要以下权限点之一：;  - [读取外派地点](corehr:employment.international_assignment.work_location:read);  - [读写外派地点](corehr:employment.international_assignment.work_location:write)
         * <p> 示例值：
         */
        this.workLocationIdList = builder.workLocationIdList;
        /**
         * 外派部门;- 可通过[【批量查询部门】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/corehr-v2/department/batch_get)获取;- 类型与 department_id_type 一致
         * <p> 示例值：
         */
        this.departmentIdList = builder.departmentIdList;
        /**
         * 外派直属上级;- 可通过[【批量查询员工信息】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/corehr-v2/employee/batch_get)获取;- 类型与 user_id_type 一致
         * <p> 示例值：
         */
        this.directManagerIdList = builder.directManagerIdList;
        /**
         * 外派虚线上级;- 可通过[【批量查询员工信息】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/corehr-v2/employee/batch_get)获取;- 类型与 user_id_type 一致
         * <p> 示例值：
         */
        this.dottedLineManagerIdList = builder.dottedLineManagerIdList;
        /**
         * 外派岗位;- 功能灰度中，请联系[技术支持](https://applink.feishu.cn/TLJpeNdW);- 需要以下权限点之一：;  - [读取外派岗位](corehr:employment.international_assignment.position:read);  - [读写外派岗位](corehr:employment.international_assignment.position:write)
         * <p> 示例值：
         */
        this.positionIdList = builder.positionIdList;
        /**
         * 外派职务;- 可通过[【批量查询职务】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/corehr-v2/job/list)获取;- 需要以下权限点之一：;    - [读取外派职务](corehr:employment.international_assignment.job:read);    - [读写外派职务](corehr:employment.international_assignment.job:write)
         * <p> 示例值：
         */
        this.jobIdList = builder.jobIdList;
        /**
         * 外派序列;- 可通过[【批量查询序列】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/job_family/list)获取
         * <p> 示例值：
         */
        this.jobFamilyIdList = builder.jobFamilyIdList;
        /**
         * 外派职级;- 可通过[【批量查询职级】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/job_level/list)获取;- 需要以下权限点之一：;    - [读取外派职级](corehr:employment.international_assignment.job_level:read);    - [读写外派职级](corehr:employment.international_assignment.job_level:write)
         * <p> 示例值：
         */
        this.jobLevelIdList = builder.jobLevelIdList;
        /**
         * 外派职等;- 可通过[【查询职等】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/corehr-v2/job_grade/query)获取;- 需要以下权限点之一：;      - [读取外派职等](corehr:employment.international_assignment.job_grade:read);      - [读写外派职等](corehr:employment.international_assignment.job_grade:write)
         * <p> 示例值：
         */
        this.jobGradeIdList = builder.jobGradeIdList;
        /**
         * 外派工时制度;- 可通过[【批量查询工时制度】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/working_hours_type/list)获取;- 需要以下权限点之一：;      - [读取外派工时制度](corehr:employment.international_assignment.working_hours_type:read);      - [读写外派工时制度](corehr:employment.international_assignment.working_hours_type:write)
         * <p> 示例值：
         */
        this.workingHoursTypeIdList = builder.workingHoursTypeIdList;
        /**
         * 外派任职公司;- 可通过[【批量查询公司】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/company/list)获取;- 需要以下权限点之一：;    - [读取外派公司](corehr:employment.international_assignment.service_company:read);    - [读写外派公司](corehr:employment.international_assignment.service_company:write)
         * <p> 示例值：
         */
        this.serviceCompanyList = builder.serviceCompanyList;
        /**
         * 外派周工作时长;- 限制两位小数;- 需要以下权限点之一：;    - [读取外派周工作时长](corehr:employment.international_assignment.weekly_working_hours:read);    - [读写外派周工作时长](corehr:employment.international_assignment.weekly_working_hours:write)
         * <p> 示例值：10
         */
        this.weeklyWorkingHoursV2 = builder.weeklyWorkingHoursV2;
        /**
         * 外派排班类型;- 可通过[【获取字段详情】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/custom_field/get_by_param)接口查询，查询参数如下：;    - object_api_name：job_data;    - custom_api_name：work_shift;- 需要以下权限点之一：;    - [读取外派排班类型](corehr:employment.international_assignment.work_shift:read);    - [读写外派排班类型](corehr:employment.international_assignment.work_shift:write)
         * <p> 示例值：
         */
        this.workShiftList = builder.workShiftList;
        /**
         * 外派薪资类型;- 可通过[【获取字段详情】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/custom_field/get_by_param)接口查询，查询参数如下：;  - object_api_name：job_data;  - custom_api_name：compensation_type;- 需要以下权限点之一：;  - [读取外派薪资类型](corehr:employment.international_assignment.compensation_type:read);  - [读写外派薪资类型](corehr:employment.international_assignment.compensation_type:write)
         * <p> 示例值：
         */
        this.compensationTypeList = builder.compensationTypeList;
        /**
         * 外派预计结束日期;- 范围筛选，格式：yyyy-mm-dd~yyyy-mm-dd
         * <p> 示例值：- "2024-01-01~2024-02-02";- "~2024-02-02";- "2024-01-01~"
         */
        this.internationalAssignmentExpectedEndDate = builder.internationalAssignmentExpectedEndDate;
        /**
         * 外派状态;- 可通过[【获取字段详情】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/custom_field/get_by_param)接口查询，查询参数如下：;    - object_api_name：international_assignment;    - custom_api_name：international_assignment_status
         * <p> 示例值：
         */
        this.internationalAssignmentStatusList = builder.internationalAssignmentStatusList;
        /**
         * 外派类型;- 可通过[【获取字段详情】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/custom_field/get_by_param)接口查询，查询参数如下：;    - object_api_name：international_assignment;    - custom_api_name：international_assignment_type
         * <p> 示例值：
         */
        this.internationalAssignmentTypeList = builder.internationalAssignmentTypeList;
        /**
         * 外派工作日历;- 可通过[【查询工作日历】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/leave/work_calendar)获取详细信息;- 需要以下权限点之一：;    - [读取外派工作日历](corehr:employment.international_assignment.work_calendar:read);    - [读写外派工作日历](corehr:employment.international_assignment.work_calendar:write)
         * <p> 示例值：
         */
        this.workCalendarIdList = builder.workCalendarIdList;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getUserIdType() {
        return this.userIdType;
    }

    public void setUserIdType(String userIdType) {
        this.userIdType = userIdType;
    }

    public String getDepartmentIdType() {
        return this.departmentIdType;
    }

    public void setDepartmentIdType(String departmentIdType) {
        this.departmentIdType = departmentIdType;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getPageToken() {
        return this.pageToken;
    }

    public void setPageToken(String pageToken) {
        this.pageToken = pageToken;
    }

    public String[] getEmploymentIds() {
        return this.employmentIds;
    }

    public void setEmploymentIds(String[] employmentIds) {
        this.employmentIds = employmentIds;
    }

    public String[] getInternationalAssignmentIds() {
        return this.internationalAssignmentIds;
    }

    public void setInternationalAssignmentIds(String[] internationalAssignmentIds) {
        this.internationalAssignmentIds = internationalAssignmentIds;
    }

    public String getEffectiveTime() {
        return this.effectiveTime;
    }

    public void setEffectiveTime(String effectiveTime) {
        this.effectiveTime = effectiveTime;
    }

    public String getExpirationTime() {
        return this.expirationTime;
    }

    public void setExpirationTime(String expirationTime) {
        this.expirationTime = expirationTime;
    }

    public String[] getEmploymentStatusList() {
        return this.employmentStatusList;
    }

    public void setEmploymentStatusList(String[] employmentStatusList) {
        this.employmentStatusList = employmentStatusList;
    }

    public String[] getWorkLocationIdList() {
        return this.workLocationIdList;
    }

    public void setWorkLocationIdList(String[] workLocationIdList) {
        this.workLocationIdList = workLocationIdList;
    }

    public String[] getDepartmentIdList() {
        return this.departmentIdList;
    }

    public void setDepartmentIdList(String[] departmentIdList) {
        this.departmentIdList = departmentIdList;
    }

    public String[] getDirectManagerIdList() {
        return this.directManagerIdList;
    }

    public void setDirectManagerIdList(String[] directManagerIdList) {
        this.directManagerIdList = directManagerIdList;
    }

    public String[] getDottedLineManagerIdList() {
        return this.dottedLineManagerIdList;
    }

    public void setDottedLineManagerIdList(String[] dottedLineManagerIdList) {
        this.dottedLineManagerIdList = dottedLineManagerIdList;
    }

    public String[] getPositionIdList() {
        return this.positionIdList;
    }

    public void setPositionIdList(String[] positionIdList) {
        this.positionIdList = positionIdList;
    }

    public String[] getJobIdList() {
        return this.jobIdList;
    }

    public void setJobIdList(String[] jobIdList) {
        this.jobIdList = jobIdList;
    }

    public String[] getJobFamilyIdList() {
        return this.jobFamilyIdList;
    }

    public void setJobFamilyIdList(String[] jobFamilyIdList) {
        this.jobFamilyIdList = jobFamilyIdList;
    }

    public String[] getJobLevelIdList() {
        return this.jobLevelIdList;
    }

    public void setJobLevelIdList(String[] jobLevelIdList) {
        this.jobLevelIdList = jobLevelIdList;
    }

    public String[] getJobGradeIdList() {
        return this.jobGradeIdList;
    }

    public void setJobGradeIdList(String[] jobGradeIdList) {
        this.jobGradeIdList = jobGradeIdList;
    }

    public String[] getWorkingHoursTypeIdList() {
        return this.workingHoursTypeIdList;
    }

    public void setWorkingHoursTypeIdList(String[] workingHoursTypeIdList) {
        this.workingHoursTypeIdList = workingHoursTypeIdList;
    }

    public String[] getServiceCompanyList() {
        return this.serviceCompanyList;
    }

    public void setServiceCompanyList(String[] serviceCompanyList) {
        this.serviceCompanyList = serviceCompanyList;
    }

    public Double getWeeklyWorkingHoursV2() {
        return this.weeklyWorkingHoursV2;
    }

    public void setWeeklyWorkingHoursV2(Double weeklyWorkingHoursV2) {
        this.weeklyWorkingHoursV2 = weeklyWorkingHoursV2;
    }

    public String[] getWorkShiftList() {
        return this.workShiftList;
    }

    public void setWorkShiftList(String[] workShiftList) {
        this.workShiftList = workShiftList;
    }

    public String[] getCompensationTypeList() {
        return this.compensationTypeList;
    }

    public void setCompensationTypeList(String[] compensationTypeList) {
        this.compensationTypeList = compensationTypeList;
    }

    public String getInternationalAssignmentExpectedEndDate() {
        return this.internationalAssignmentExpectedEndDate;
    }

    public void setInternationalAssignmentExpectedEndDate(String internationalAssignmentExpectedEndDate) {
        this.internationalAssignmentExpectedEndDate = internationalAssignmentExpectedEndDate;
    }

    public String[] getInternationalAssignmentStatusList() {
        return this.internationalAssignmentStatusList;
    }

    public void setInternationalAssignmentStatusList(String[] internationalAssignmentStatusList) {
        this.internationalAssignmentStatusList = internationalAssignmentStatusList;
    }

    public String[] getInternationalAssignmentTypeList() {
        return this.internationalAssignmentTypeList;
    }

    public void setInternationalAssignmentTypeList(String[] internationalAssignmentTypeList) {
        this.internationalAssignmentTypeList = internationalAssignmentTypeList;
    }

    public String[] getWorkCalendarIdList() {
        return this.workCalendarIdList;
    }

    public void setWorkCalendarIdList(String[] workCalendarIdList) {
        this.workCalendarIdList = workCalendarIdList;
    }

    public static class Builder {
        private String userIdType; // 用户 ID 类型
        private String departmentIdType; // 此次调用中使用的部门 ID 类型
        private Integer pageSize; // 分页大小
        private String pageToken; // 分页标记，第一次请求不填，表示从头开始遍历；分页查询结果还有更多项时会同时返回新的 page_token，下次遍历可采用该 page_token 获取查询结果
        private String[] employmentIds; // 雇佣ID;- 可通过[【批量查询员工信息】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/corehr-v2/employee/batch_get)获取详细信息;- 类型必须与 user_id_type 一致
        private String[] internationalAssignmentIds; // 外派 ID
        private String effectiveTime; // 外派开始日期;- 范围筛选，格式：yyyy-mm-dd~yyyy-mm-dd
        private String expirationTime; // 外派结束日期;- 范围筛选，格式：yyyy-mm-dd~yyyy-mm-dd
        private String[] employmentStatusList; // 雇佣状态;- 可通过[【获取字段详情】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/custom_field/get_by_param)接口查询，查询参数如下：;  - object_api_name：employment;  - custom_api_name：employment_status
        private String[] workLocationIdList; // 外派工作地点;- 可通过[【批量查询地点】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/location/list)获取;- 需要以下权限点之一：;  - [读取外派地点](corehr:employment.international_assignment.work_location:read);  - [读写外派地点](corehr:employment.international_assignment.work_location:write)
        private String[] departmentIdList; // 外派部门;- 可通过[【批量查询部门】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/corehr-v2/department/batch_get)获取;- 类型与 department_id_type 一致
        private String[] directManagerIdList; // 外派直属上级;- 可通过[【批量查询员工信息】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/corehr-v2/employee/batch_get)获取;- 类型与 user_id_type 一致
        private String[] dottedLineManagerIdList; // 外派虚线上级;- 可通过[【批量查询员工信息】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/corehr-v2/employee/batch_get)获取;- 类型与 user_id_type 一致
        private String[] positionIdList; // 外派岗位;- 功能灰度中，请联系[技术支持](https://applink.feishu.cn/TLJpeNdW);- 需要以下权限点之一：;  - [读取外派岗位](corehr:employment.international_assignment.position:read);  - [读写外派岗位](corehr:employment.international_assignment.position:write)
        private String[] jobIdList; // 外派职务;- 可通过[【批量查询职务】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/corehr-v2/job/list)获取;- 需要以下权限点之一：;    - [读取外派职务](corehr:employment.international_assignment.job:read);    - [读写外派职务](corehr:employment.international_assignment.job:write)
        private String[] jobFamilyIdList; // 外派序列;- 可通过[【批量查询序列】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/job_family/list)获取
        private String[] jobLevelIdList; // 外派职级;- 可通过[【批量查询职级】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/job_level/list)获取;- 需要以下权限点之一：;    - [读取外派职级](corehr:employment.international_assignment.job_level:read);    - [读写外派职级](corehr:employment.international_assignment.job_level:write)
        private String[] jobGradeIdList; // 外派职等;- 可通过[【查询职等】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/corehr-v2/job_grade/query)获取;- 需要以下权限点之一：;      - [读取外派职等](corehr:employment.international_assignment.job_grade:read);      - [读写外派职等](corehr:employment.international_assignment.job_grade:write)
        private String[] workingHoursTypeIdList; // 外派工时制度;- 可通过[【批量查询工时制度】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/working_hours_type/list)获取;- 需要以下权限点之一：;      - [读取外派工时制度](corehr:employment.international_assignment.working_hours_type:read);      - [读写外派工时制度](corehr:employment.international_assignment.working_hours_type:write)
        private String[] serviceCompanyList; // 外派任职公司;- 可通过[【批量查询公司】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/company/list)获取;- 需要以下权限点之一：;    - [读取外派公司](corehr:employment.international_assignment.service_company:read);    - [读写外派公司](corehr:employment.international_assignment.service_company:write)
        private Double weeklyWorkingHoursV2; // 外派周工作时长;- 限制两位小数;- 需要以下权限点之一：;    - [读取外派周工作时长](corehr:employment.international_assignment.weekly_working_hours:read);    - [读写外派周工作时长](corehr:employment.international_assignment.weekly_working_hours:write)
        private String[] workShiftList; // 外派排班类型;- 可通过[【获取字段详情】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/custom_field/get_by_param)接口查询，查询参数如下：;    - object_api_name：job_data;    - custom_api_name：work_shift;- 需要以下权限点之一：;    - [读取外派排班类型](corehr:employment.international_assignment.work_shift:read);    - [读写外派排班类型](corehr:employment.international_assignment.work_shift:write)
        private String[] compensationTypeList; // 外派薪资类型;- 可通过[【获取字段详情】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/custom_field/get_by_param)接口查询，查询参数如下：;  - object_api_name：job_data;  - custom_api_name：compensation_type;- 需要以下权限点之一：;  - [读取外派薪资类型](corehr:employment.international_assignment.compensation_type:read);  - [读写外派薪资类型](corehr:employment.international_assignment.compensation_type:write)
        private String internationalAssignmentExpectedEndDate; // 外派预计结束日期;- 范围筛选，格式：yyyy-mm-dd~yyyy-mm-dd
        private String[] internationalAssignmentStatusList; // 外派状态;- 可通过[【获取字段详情】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/custom_field/get_by_param)接口查询，查询参数如下：;    - object_api_name：international_assignment;    - custom_api_name：international_assignment_status
        private String[] internationalAssignmentTypeList; // 外派类型;- 可通过[【获取字段详情】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/custom_field/get_by_param)接口查询，查询参数如下：;    - object_api_name：international_assignment;    - custom_api_name：international_assignment_type
        private String[] workCalendarIdList; // 外派工作日历;- 可通过[【查询工作日历】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/leave/work_calendar)获取详细信息;- 需要以下权限点之一：;    - [读取外派工作日历](corehr:employment.international_assignment.work_calendar:read);    - [读写外派工作日历](corehr:employment.international_assignment.work_calendar:write)

        /**
         * 用户 ID 类型
         * <p> 示例值：open_id
         *
         * @param userIdType
         * @return
         */
        public Builder userIdType(String userIdType) {
            this.userIdType = userIdType;
            return this;
        }

        /**
         * 用户 ID 类型
         * <p> 示例值：open_id
         *
         * @param userIdType {@link com.lark.oapi.service.corehr.v2.enums.ListEmployeesInternationalAssignmentUserIdTypeEnum}
         * @return
         */
        public Builder userIdType(com.lark.oapi.service.corehr.v2.enums.ListEmployeesInternationalAssignmentUserIdTypeEnum userIdType) {
            this.userIdType = userIdType.getValue();
            return this;
        }


        /**
         * 此次调用中使用的部门 ID 类型
         * <p> 示例值：open_department_id
         *
         * @param departmentIdType
         * @return
         */
        public Builder departmentIdType(String departmentIdType) {
            this.departmentIdType = departmentIdType;
            return this;
        }

        /**
         * 此次调用中使用的部门 ID 类型
         * <p> 示例值：open_department_id
         *
         * @param departmentIdType {@link com.lark.oapi.service.corehr.v2.enums.ListEmployeesInternationalAssignmentDepartmentIdTypeEnum}
         * @return
         */
        public Builder departmentIdType(com.lark.oapi.service.corehr.v2.enums.ListEmployeesInternationalAssignmentDepartmentIdTypeEnum departmentIdType) {
            this.departmentIdType = departmentIdType.getValue();
            return this;
        }


        /**
         * 分页大小
         * <p> 示例值：100
         *
         * @param pageSize
         * @return
         */
        public Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }


        /**
         * 分页标记，第一次请求不填，表示从头开始遍历；分页查询结果还有更多项时会同时返回新的 page_token，下次遍历可采用该 page_token 获取查询结果
         * <p> 示例值：123456
         *
         * @param pageToken
         * @return
         */
        public Builder pageToken(String pageToken) {
            this.pageToken = pageToken;
            return this;
        }


        /**
         * 雇佣ID;- 可通过[【批量查询员工信息】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/corehr-v2/employee/batch_get)获取详细信息;- 类型必须与 user_id_type 一致
         * <p> 示例值：
         *
         * @param employmentIds
         * @return
         */
        public Builder employmentIds(String[] employmentIds) {
            this.employmentIds = employmentIds;
            return this;
        }


        /**
         * 外派 ID
         * <p> 示例值：
         *
         * @param internationalAssignmentIds
         * @return
         */
        public Builder internationalAssignmentIds(String[] internationalAssignmentIds) {
            this.internationalAssignmentIds = internationalAssignmentIds;
            return this;
        }


        /**
         * 外派开始日期;- 范围筛选，格式：yyyy-mm-dd~yyyy-mm-dd
         * <p> 示例值：- "2024-01-01~2024-02-02";- "~2024-02-02";- "2024-01-01~"
         *
         * @param effectiveTime
         * @return
         */
        public Builder effectiveTime(String effectiveTime) {
            this.effectiveTime = effectiveTime;
            return this;
        }


        /**
         * 外派结束日期;- 范围筛选，格式：yyyy-mm-dd~yyyy-mm-dd
         * <p> 示例值：- "2024-01-01~2024-02-02";- "~2024-02-02";- "2024-01-01~"
         *
         * @param expirationTime
         * @return
         */
        public Builder expirationTime(String expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }


        /**
         * 雇佣状态;- 可通过[【获取字段详情】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/custom_field/get_by_param)接口查询，查询参数如下：;  - object_api_name：employment;  - custom_api_name：employment_status
         * <p> 示例值：
         *
         * @param employmentStatusList
         * @return
         */
        public Builder employmentStatusList(String[] employmentStatusList) {
            this.employmentStatusList = employmentStatusList;
            return this;
        }


        /**
         * 外派工作地点;- 可通过[【批量查询地点】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/location/list)获取;- 需要以下权限点之一：;  - [读取外派地点](corehr:employment.international_assignment.work_location:read);  - [读写外派地点](corehr:employment.international_assignment.work_location:write)
         * <p> 示例值：
         *
         * @param workLocationIdList
         * @return
         */
        public Builder workLocationIdList(String[] workLocationIdList) {
            this.workLocationIdList = workLocationIdList;
            return this;
        }


        /**
         * 外派部门;- 可通过[【批量查询部门】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/corehr-v2/department/batch_get)获取;- 类型与 department_id_type 一致
         * <p> 示例值：
         *
         * @param departmentIdList
         * @return
         */
        public Builder departmentIdList(String[] departmentIdList) {
            this.departmentIdList = departmentIdList;
            return this;
        }


        /**
         * 外派直属上级;- 可通过[【批量查询员工信息】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/corehr-v2/employee/batch_get)获取;- 类型与 user_id_type 一致
         * <p> 示例值：
         *
         * @param directManagerIdList
         * @return
         */
        public Builder directManagerIdList(String[] directManagerIdList) {
            this.directManagerIdList = directManagerIdList;
            return this;
        }


        /**
         * 外派虚线上级;- 可通过[【批量查询员工信息】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/corehr-v2/employee/batch_get)获取;- 类型与 user_id_type 一致
         * <p> 示例值：
         *
         * @param dottedLineManagerIdList
         * @return
         */
        public Builder dottedLineManagerIdList(String[] dottedLineManagerIdList) {
            this.dottedLineManagerIdList = dottedLineManagerIdList;
            return this;
        }


        /**
         * 外派岗位;- 功能灰度中，请联系[技术支持](https://applink.feishu.cn/TLJpeNdW);- 需要以下权限点之一：;  - [读取外派岗位](corehr:employment.international_assignment.position:read);  - [读写外派岗位](corehr:employment.international_assignment.position:write)
         * <p> 示例值：
         *
         * @param positionIdList
         * @return
         */
        public Builder positionIdList(String[] positionIdList) {
            this.positionIdList = positionIdList;
            return this;
        }


        /**
         * 外派职务;- 可通过[【批量查询职务】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/corehr-v2/job/list)获取;- 需要以下权限点之一：;    - [读取外派职务](corehr:employment.international_assignment.job:read);    - [读写外派职务](corehr:employment.international_assignment.job:write)
         * <p> 示例值：
         *
         * @param jobIdList
         * @return
         */
        public Builder jobIdList(String[] jobIdList) {
            this.jobIdList = jobIdList;
            return this;
        }


        /**
         * 外派序列;- 可通过[【批量查询序列】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/job_family/list)获取
         * <p> 示例值：
         *
         * @param jobFamilyIdList
         * @return
         */
        public Builder jobFamilyIdList(String[] jobFamilyIdList) {
            this.jobFamilyIdList = jobFamilyIdList;
            return this;
        }


        /**
         * 外派职级;- 可通过[【批量查询职级】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/job_level/list)获取;- 需要以下权限点之一：;    - [读取外派职级](corehr:employment.international_assignment.job_level:read);    - [读写外派职级](corehr:employment.international_assignment.job_level:write)
         * <p> 示例值：
         *
         * @param jobLevelIdList
         * @return
         */
        public Builder jobLevelIdList(String[] jobLevelIdList) {
            this.jobLevelIdList = jobLevelIdList;
            return this;
        }


        /**
         * 外派职等;- 可通过[【查询职等】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/corehr-v2/job_grade/query)获取;- 需要以下权限点之一：;      - [读取外派职等](corehr:employment.international_assignment.job_grade:read);      - [读写外派职等](corehr:employment.international_assignment.job_grade:write)
         * <p> 示例值：
         *
         * @param jobGradeIdList
         * @return
         */
        public Builder jobGradeIdList(String[] jobGradeIdList) {
            this.jobGradeIdList = jobGradeIdList;
            return this;
        }


        /**
         * 外派工时制度;- 可通过[【批量查询工时制度】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/working_hours_type/list)获取;- 需要以下权限点之一：;      - [读取外派工时制度](corehr:employment.international_assignment.working_hours_type:read);      - [读写外派工时制度](corehr:employment.international_assignment.working_hours_type:write)
         * <p> 示例值：
         *
         * @param workingHoursTypeIdList
         * @return
         */
        public Builder workingHoursTypeIdList(String[] workingHoursTypeIdList) {
            this.workingHoursTypeIdList = workingHoursTypeIdList;
            return this;
        }


        /**
         * 外派任职公司;- 可通过[【批量查询公司】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/company/list)获取;- 需要以下权限点之一：;    - [读取外派公司](corehr:employment.international_assignment.service_company:read);    - [读写外派公司](corehr:employment.international_assignment.service_company:write)
         * <p> 示例值：
         *
         * @param serviceCompanyList
         * @return
         */
        public Builder serviceCompanyList(String[] serviceCompanyList) {
            this.serviceCompanyList = serviceCompanyList;
            return this;
        }


        /**
         * 外派周工作时长;- 限制两位小数;- 需要以下权限点之一：;    - [读取外派周工作时长](corehr:employment.international_assignment.weekly_working_hours:read);    - [读写外派周工作时长](corehr:employment.international_assignment.weekly_working_hours:write)
         * <p> 示例值：10
         *
         * @param weeklyWorkingHoursV2
         * @return
         */
        public Builder weeklyWorkingHoursV2(Double weeklyWorkingHoursV2) {
            this.weeklyWorkingHoursV2 = weeklyWorkingHoursV2;
            return this;
        }


        /**
         * 外派排班类型;- 可通过[【获取字段详情】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/custom_field/get_by_param)接口查询，查询参数如下：;    - object_api_name：job_data;    - custom_api_name：work_shift;- 需要以下权限点之一：;    - [读取外派排班类型](corehr:employment.international_assignment.work_shift:read);    - [读写外派排班类型](corehr:employment.international_assignment.work_shift:write)
         * <p> 示例值：
         *
         * @param workShiftList
         * @return
         */
        public Builder workShiftList(String[] workShiftList) {
            this.workShiftList = workShiftList;
            return this;
        }


        /**
         * 外派薪资类型;- 可通过[【获取字段详情】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/custom_field/get_by_param)接口查询，查询参数如下：;  - object_api_name：job_data;  - custom_api_name：compensation_type;- 需要以下权限点之一：;  - [读取外派薪资类型](corehr:employment.international_assignment.compensation_type:read);  - [读写外派薪资类型](corehr:employment.international_assignment.compensation_type:write)
         * <p> 示例值：
         *
         * @param compensationTypeList
         * @return
         */
        public Builder compensationTypeList(String[] compensationTypeList) {
            this.compensationTypeList = compensationTypeList;
            return this;
        }


        /**
         * 外派预计结束日期;- 范围筛选，格式：yyyy-mm-dd~yyyy-mm-dd
         * <p> 示例值：- "2024-01-01~2024-02-02";- "~2024-02-02";- "2024-01-01~"
         *
         * @param internationalAssignmentExpectedEndDate
         * @return
         */
        public Builder internationalAssignmentExpectedEndDate(String internationalAssignmentExpectedEndDate) {
            this.internationalAssignmentExpectedEndDate = internationalAssignmentExpectedEndDate;
            return this;
        }


        /**
         * 外派状态;- 可通过[【获取字段详情】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/custom_field/get_by_param)接口查询，查询参数如下：;    - object_api_name：international_assignment;    - custom_api_name：international_assignment_status
         * <p> 示例值：
         *
         * @param internationalAssignmentStatusList
         * @return
         */
        public Builder internationalAssignmentStatusList(String[] internationalAssignmentStatusList) {
            this.internationalAssignmentStatusList = internationalAssignmentStatusList;
            return this;
        }


        /**
         * 外派类型;- 可通过[【获取字段详情】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/custom_field/get_by_param)接口查询，查询参数如下：;    - object_api_name：international_assignment;    - custom_api_name：international_assignment_type
         * <p> 示例值：
         *
         * @param internationalAssignmentTypeList
         * @return
         */
        public Builder internationalAssignmentTypeList(String[] internationalAssignmentTypeList) {
            this.internationalAssignmentTypeList = internationalAssignmentTypeList;
            return this;
        }


        /**
         * 外派工作日历;- 可通过[【查询工作日历】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/leave/work_calendar)获取详细信息;- 需要以下权限点之一：;    - [读取外派工作日历](corehr:employment.international_assignment.work_calendar:read);    - [读写外派工作日历](corehr:employment.international_assignment.work_calendar:write)
         * <p> 示例值：
         *
         * @param workCalendarIdList
         * @return
         */
        public Builder workCalendarIdList(String[] workCalendarIdList) {
            this.workCalendarIdList = workCalendarIdList;
            return this;
        }


        public ListEmployeesInternationalAssignmentReq build() {
            return new ListEmployeesInternationalAssignmentReq(this);
        }
    }
}
