// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.mail.v1.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.mail.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class UpdateUserMailboxRuleReq {
    /**
     * 用户邮箱地址 或 输入me代表当前调用接口用户
     * <p> 示例值：user@xxx.xx 或 me
     */
    @Path
    @SerializedName("user_mailbox_id")
    private String userMailboxId;
    /**
     * 规则 id
     * <p> 示例值：123123123
     */
    @Path
    @SerializedName("rule_id")
    private String ruleId;
    @Body
    private Rule body;

    // builder 开始
    public UpdateUserMailboxRuleReq() {
    }

    public UpdateUserMailboxRuleReq(Builder builder) {
        /**
         * 用户邮箱地址 或 输入me代表当前调用接口用户
         * <p> 示例值：user@xxx.xx 或 me
         */
        this.userMailboxId = builder.userMailboxId;
        /**
         * 规则 id
         * <p> 示例值：123123123
         */
        this.ruleId = builder.ruleId;
        this.body = builder.body;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getUserMailboxId() {
        return this.userMailboxId;
    }

    public void setUserMailboxId(String userMailboxId) {
        this.userMailboxId = userMailboxId;
    }

    public String getRuleId() {
        return this.ruleId;
    }

    public void setRuleId(String ruleId) {
        this.ruleId = ruleId;
    }

    public Rule getRule() {
        return this.body;
    }

    public void setRule(Rule body) {
        this.body = body;
    }

    public static class Builder {

        private String userMailboxId; // 用户邮箱地址 或 输入me代表当前调用接口用户
        private String ruleId; // 规则 id
        private Rule body;

        /**
         * 用户邮箱地址 或 输入me代表当前调用接口用户
         * <p> 示例值：user@xxx.xx 或 me
         *
         * @param userMailboxId
         * @return
         */
        public Builder userMailboxId(String userMailboxId) {
            this.userMailboxId = userMailboxId;
            return this;
        }

        /**
         * 规则 id
         * <p> 示例值：123123123
         *
         * @param ruleId
         * @return
         */
        public Builder ruleId(String ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        public Rule getRule() {
            return this.body;
        }

        /**
         * body
         *
         * @param body
         * @return
         */
        public Builder rule(Rule body) {
            this.body = body;
            return this;
        }

        public UpdateUserMailboxRuleReq build() {
            return new UpdateUserMailboxRuleReq(this);
        }
    }
}
