// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.mail.v1.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.mail.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class UserMailEntity {
    /**
     * 邮箱类型
     * <p> 示例值：
     */
    @SerializedName("type")
    private Integer type;
    /**
     * 邮箱地址
     * <p> 示例值：user@xxx.xx
     */
    @SerializedName("email_address")
    private String emailAddress;
    /**
     * 公共邮箱、邮件组实体ID
     * <p> 示例值：xxxxx
     */
    @SerializedName("entity_id")
    private String entityId;
    /**
     * 个人邮箱，用户ID
     * <p> 示例值：ou_7dab8a3d3cdcc9da365777c7ad115d62
     */
    @SerializedName("user_id")
    private String userId;

    // builder 开始
    public UserMailEntity() {
    }

    public UserMailEntity(Builder builder) {
        /**
         * 邮箱类型
         * <p> 示例值：
         */
        this.type = builder.type;
        /**
         * 邮箱地址
         * <p> 示例值：user@xxx.xx
         */
        this.emailAddress = builder.emailAddress;
        /**
         * 公共邮箱、邮件组实体ID
         * <p> 示例值：xxxxx
         */
        this.entityId = builder.entityId;
        /**
         * 个人邮箱，用户ID
         * <p> 示例值：ou_7dab8a3d3cdcc9da365777c7ad115d62
         */
        this.userId = builder.userId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public static class Builder {
        /**
         * 邮箱类型
         * <p> 示例值：
         */
        private Integer type;
        /**
         * 邮箱地址
         * <p> 示例值：user@xxx.xx
         */
        private String emailAddress;
        /**
         * 公共邮箱、邮件组实体ID
         * <p> 示例值：xxxxx
         */
        private String entityId;
        /**
         * 个人邮箱，用户ID
         * <p> 示例值：ou_7dab8a3d3cdcc9da365777c7ad115d62
         */
        private String userId;

        /**
         * 邮箱类型
         * <p> 示例值：
         *
         * @param type
         * @return
         */
        public Builder type(Integer type) {
            this.type = type;
            return this;
        }

        /**
         * 邮箱类型
         * <p> 示例值：
         *
         * @param type {@link com.lark.oapi.service.mail.v1.enums.UserMailEntityEntityTypeEnum}
         * @return
         */
        public Builder type(com.lark.oapi.service.mail.v1.enums.UserMailEntityEntityTypeEnum type) {
            this.type = type.getValue();
            return this;
        }


        /**
         * 邮箱地址
         * <p> 示例值：user@xxx.xx
         *
         * @param emailAddress
         * @return
         */
        public Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }


        /**
         * 公共邮箱、邮件组实体ID
         * <p> 示例值：xxxxx
         *
         * @param entityId
         * @return
         */
        public Builder entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }


        /**
         * 个人邮箱，用户ID
         * <p> 示例值：ou_7dab8a3d3cdcc9da365777c7ad115d62
         *
         * @param userId
         * @return
         */
        public Builder userId(String userId) {
            this.userId = userId;
            return this;
        }


        public UserMailEntity build() {
            return new UserMailEntity(this);
        }
    }
}
