// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.wiki.v1.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.wiki.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class SpaceCoverInfo {
    /**
     * 封面图片的url
     * <p> 示例值：
     */
    @SerializedName("origin")
    private String origin;
    /**
     * 封面图片缩略图的url
     * <p> 示例值：
     */
    @SerializedName("thumbnail")
    private String thumbnail;
    /**
     * 封面图片的名称
     * <p> 示例值：
     */
    @SerializedName("name")
    private String name;
    /**
     * 封面是否为深色，如果为深色，则封面标题应当为白色，反之应当为黑色
     * <p> 示例值：
     */
    @SerializedName("is_graph_dark")
    private Boolean isGraphDark;
    /**
     * 封面的色值
     * <p> 示例值：
     */
    @SerializedName("color")
    private String color;

    // builder 开始
    public SpaceCoverInfo() {
    }

    public SpaceCoverInfo(Builder builder) {
        /**
         * 封面图片的url
         * <p> 示例值：
         */
        this.origin = builder.origin;
        /**
         * 封面图片缩略图的url
         * <p> 示例值：
         */
        this.thumbnail = builder.thumbnail;
        /**
         * 封面图片的名称
         * <p> 示例值：
         */
        this.name = builder.name;
        /**
         * 封面是否为深色，如果为深色，则封面标题应当为白色，反之应当为黑色
         * <p> 示例值：
         */
        this.isGraphDark = builder.isGraphDark;
        /**
         * 封面的色值
         * <p> 示例值：
         */
        this.color = builder.color;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public String getThumbnail() {
        return this.thumbnail;
    }

    public void setThumbnail(String thumbnail) {
        this.thumbnail = thumbnail;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Boolean getIsGraphDark() {
        return this.isGraphDark;
    }

    public void setIsGraphDark(Boolean isGraphDark) {
        this.isGraphDark = isGraphDark;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public static class Builder {
        /**
         * 封面图片的url
         * <p> 示例值：
         */
        private String origin;
        /**
         * 封面图片缩略图的url
         * <p> 示例值：
         */
        private String thumbnail;
        /**
         * 封面图片的名称
         * <p> 示例值：
         */
        private String name;
        /**
         * 封面是否为深色，如果为深色，则封面标题应当为白色，反之应当为黑色
         * <p> 示例值：
         */
        private Boolean isGraphDark;
        /**
         * 封面的色值
         * <p> 示例值：
         */
        private String color;

        /**
         * 封面图片的url
         * <p> 示例值：
         *
         * @param origin
         * @return
         */
        public Builder origin(String origin) {
            this.origin = origin;
            return this;
        }


        /**
         * 封面图片缩略图的url
         * <p> 示例值：
         *
         * @param thumbnail
         * @return
         */
        public Builder thumbnail(String thumbnail) {
            this.thumbnail = thumbnail;
            return this;
        }


        /**
         * 封面图片的名称
         * <p> 示例值：
         *
         * @param name
         * @return
         */
        public Builder name(String name) {
            this.name = name;
            return this;
        }


        /**
         * 封面是否为深色，如果为深色，则封面标题应当为白色，反之应当为黑色
         * <p> 示例值：
         *
         * @param isGraphDark
         * @return
         */
        public Builder isGraphDark(Boolean isGraphDark) {
            this.isGraphDark = isGraphDark;
            return this;
        }


        /**
         * 封面的色值
         * <p> 示例值：
         *
         * @param color
         * @return
         */
        public Builder color(String color) {
            this.color = color;
            return this;
        }


        public SpaceCoverInfo build() {
            return new SpaceCoverInfo(this);
        }
    }
}
