// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.apaas.v1.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.apaas.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;

import java.util.Map;

import com.lark.oapi.core.response.BaseResponse;

public class BasicInfo {
    /**
     * 日志类型：10000-全部类型；10001-企业管理；10002-登录日志；10003-应用管理
     * <p> 示例值：10000
     */
    @SerializedName("log_type")
    private String logType;
    /**
     * 审计域：15001-企业管理后台；15002-应用管理后台；15003-应用开发平台
     * <p> 示例值：15001
     */
    @SerializedName("audit_scope")
    private String auditScope;
    /**
     * 环境类型：16001-沙箱环境；16003-线上环境
     * <p> 示例值：16003
     */
    @SerializedName("env_type")
    private String envType;
    /**
     * 应用id
     * <p> 示例值：app123
     */
    @SerializedName("app_id")
    private String appId;
    /**
     * 审计日志功能模块
     * <p> 示例值：17001
     */
    @SerializedName("module")
    private String module;
    /**
     * 事件类型
     * <p> 示例值：19001
     */
    @SerializedName("op_type")
    private String opType;
    /**
     * 应用名称
     * <p> 示例值：
     */
    @SerializedName("app_name")
    private Map<String, String> appName;

    // builder 开始
    public BasicInfo() {
    }

    public BasicInfo(Builder builder) {
        /**
         * 日志类型：10000-全部类型；10001-企业管理；10002-登录日志；10003-应用管理
         * <p> 示例值：10000
         */
        this.logType = builder.logType;
        /**
         * 审计域：15001-企业管理后台；15002-应用管理后台；15003-应用开发平台
         * <p> 示例值：15001
         */
        this.auditScope = builder.auditScope;
        /**
         * 环境类型：16001-沙箱环境；16003-线上环境
         * <p> 示例值：16003
         */
        this.envType = builder.envType;
        /**
         * 应用id
         * <p> 示例值：app123
         */
        this.appId = builder.appId;
        /**
         * 审计日志功能模块
         * <p> 示例值：17001
         */
        this.module = builder.module;
        /**
         * 事件类型
         * <p> 示例值：19001
         */
        this.opType = builder.opType;
        /**
         * 应用名称
         * <p> 示例值：
         */
        this.appName = builder.appName;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getLogType() {
        return this.logType;
    }

    public void setLogType(String logType) {
        this.logType = logType;
    }

    public String getAuditScope() {
        return this.auditScope;
    }

    public void setAuditScope(String auditScope) {
        this.auditScope = auditScope;
    }

    public String getEnvType() {
        return this.envType;
    }

    public void setEnvType(String envType) {
        this.envType = envType;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public String getOpType() {
        return this.opType;
    }

    public void setOpType(String opType) {
        this.opType = opType;
    }

    public Map<String, String> getAppName() {
        return this.appName;
    }

    public void setAppName(Map<String, String> appName) {
        this.appName = appName;
    }

    public static class Builder {
        /**
         * 日志类型：10000-全部类型；10001-企业管理；10002-登录日志；10003-应用管理
         * <p> 示例值：10000
         */
        private String logType;
        /**
         * 审计域：15001-企业管理后台；15002-应用管理后台；15003-应用开发平台
         * <p> 示例值：15001
         */
        private String auditScope;
        /**
         * 环境类型：16001-沙箱环境；16003-线上环境
         * <p> 示例值：16003
         */
        private String envType;
        /**
         * 应用id
         * <p> 示例值：app123
         */
        private String appId;
        /**
         * 审计日志功能模块
         * <p> 示例值：17001
         */
        private String module;
        /**
         * 事件类型
         * <p> 示例值：19001
         */
        private String opType;
        /**
         * 应用名称
         * <p> 示例值：
         */
        private Map<String, String> appName;

        /**
         * 日志类型：10000-全部类型；10001-企业管理；10002-登录日志；10003-应用管理
         * <p> 示例值：10000
         *
         * @param logType
         * @return
         */
        public Builder logType(String logType) {
            this.logType = logType;
            return this;
        }


        /**
         * 审计域：15001-企业管理后台；15002-应用管理后台；15003-应用开发平台
         * <p> 示例值：15001
         *
         * @param auditScope
         * @return
         */
        public Builder auditScope(String auditScope) {
            this.auditScope = auditScope;
            return this;
        }


        /**
         * 环境类型：16001-沙箱环境；16003-线上环境
         * <p> 示例值：16003
         *
         * @param envType
         * @return
         */
        public Builder envType(String envType) {
            this.envType = envType;
            return this;
        }


        /**
         * 应用id
         * <p> 示例值：app123
         *
         * @param appId
         * @return
         */
        public Builder appId(String appId) {
            this.appId = appId;
            return this;
        }


        /**
         * 审计日志功能模块
         * <p> 示例值：17001
         *
         * @param module
         * @return
         */
        public Builder module(String module) {
            this.module = module;
            return this;
        }


        /**
         * 事件类型
         * <p> 示例值：19001
         *
         * @param opType
         * @return
         */
        public Builder opType(String opType) {
            this.opType = opType;
            return this;
        }


        /**
         * 应用名称
         * <p> 示例值：
         *
         * @param appName
         * @return
         */
        public Builder appName(Map<String, String> appName) {
            this.appName = appName;
            return this;
        }


        public BasicInfo build() {
            return new BasicInfo(this);
        }
    }
}
