// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.apaas.v1.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.apaas.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class OqlQueryApplicationObjectReqBody {
    /**
     * 待执行的 OQL 语句（关于支持的关键词及操作符，详见查看）
     * <p> 示例值：SELECT _id, _name FROM _user WHERE _type = $1 AND _accountStatus = $user_status LIMIT 10
     */
    @SerializedName("query")
    private String query;
    /**
     * 用于指定 OQL 语句中匿名参数的具体值
     * <p> 示例值：[\"_employee\"]
     */
    @SerializedName("args")
    private String args;
    /**
     * 用于指定 OQL 语句中具名参数的具体值
     * <p> 示例值：{\"user_status\" : \"_used\"}
     */
    @SerializedName("named_args")
    private String namedArgs;

    // builder 开始
    public OqlQueryApplicationObjectReqBody() {
    }

    public OqlQueryApplicationObjectReqBody(Builder builder) {
        /**
         * 待执行的 OQL 语句（关于支持的关键词及操作符，详见查看）
         * <p> 示例值：SELECT _id, _name FROM _user WHERE _type = $1 AND _accountStatus = $user_status LIMIT 10
         */
        this.query = builder.query;
        /**
         * 用于指定 OQL 语句中匿名参数的具体值
         * <p> 示例值：[\"_employee\"]
         */
        this.args = builder.args;
        /**
         * 用于指定 OQL 语句中具名参数的具体值
         * <p> 示例值：{\"user_status\" : \"_used\"}
         */
        this.namedArgs = builder.namedArgs;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public String getArgs() {
        return this.args;
    }

    public void setArgs(String args) {
        this.args = args;
    }

    public String getNamedArgs() {
        return this.namedArgs;
    }

    public void setNamedArgs(String namedArgs) {
        this.namedArgs = namedArgs;
    }

    public static class Builder {
        /**
         * 待执行的 OQL 语句（关于支持的关键词及操作符，详见查看）
         * <p> 示例值：SELECT _id, _name FROM _user WHERE _type = $1 AND _accountStatus = $user_status LIMIT 10
         */
        private String query;
        /**
         * 用于指定 OQL 语句中匿名参数的具体值
         * <p> 示例值：[\"_employee\"]
         */
        private String args;
        /**
         * 用于指定 OQL 语句中具名参数的具体值
         * <p> 示例值：{\"user_status\" : \"_used\"}
         */
        private String namedArgs;

        /**
         * 待执行的 OQL 语句（关于支持的关键词及操作符，详见查看）
         * <p> 示例值：SELECT _id, _name FROM _user WHERE _type = $1 AND _accountStatus = $user_status LIMIT 10
         *
         * @param query
         * @return
         */
        public Builder query(String query) {
            this.query = query;
            return this;
        }


        /**
         * 用于指定 OQL 语句中匿名参数的具体值
         * <p> 示例值：[\"_employee\"]
         *
         * @param args
         * @return
         */
        public Builder args(String args) {
            this.args = args;
            return this;
        }


        /**
         * 用于指定 OQL 语句中具名参数的具体值
         * <p> 示例值：{\"user_status\" : \"_used\"}
         *
         * @param namedArgs
         * @return
         */
        public Builder namedArgs(String namedArgs) {
            this.namedArgs = namedArgs;
            return this;
        }


        public OqlQueryApplicationObjectReqBody build() {
            return new OqlQueryApplicationObjectReqBody(this);
        }
    }
}
