// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.apaas.v1.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.apaas.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class UserScopeV2 {
    /**
     * 生效范围模式
     * <p> 示例值：
     */
    @SerializedName("user_scope_mode")
    private String userScopeMode;
    /**
     * 如果模式选的是user，则需要提供用户信息
     * <p> 示例值：
     */
    @SerializedName("user_list")
    private UserSimpleInfo[] userList;
    /**
     * 如果模式选的是role，则需要提供角色信息，角色目前只支持一个角色
     * <p> 示例值：
     */
    @SerializedName("role_list")
    private RoleApiNameSimpleInfo[] roleList;

    // builder 开始
    public UserScopeV2() {
    }

    public UserScopeV2(Builder builder) {
        /**
         * 生效范围模式
         * <p> 示例值：
         */
        this.userScopeMode = builder.userScopeMode;
        /**
         * 如果模式选的是user，则需要提供用户信息
         * <p> 示例值：
         */
        this.userList = builder.userList;
        /**
         * 如果模式选的是role，则需要提供角色信息，角色目前只支持一个角色
         * <p> 示例值：
         */
        this.roleList = builder.roleList;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getUserScopeMode() {
        return this.userScopeMode;
    }

    public void setUserScopeMode(String userScopeMode) {
        this.userScopeMode = userScopeMode;
    }

    public UserSimpleInfo[] getUserList() {
        return this.userList;
    }

    public void setUserList(UserSimpleInfo[] userList) {
        this.userList = userList;
    }

    public RoleApiNameSimpleInfo[] getRoleList() {
        return this.roleList;
    }

    public void setRoleList(RoleApiNameSimpleInfo[] roleList) {
        this.roleList = roleList;
    }

    public static class Builder {
        /**
         * 生效范围模式
         * <p> 示例值：
         */
        private String userScopeMode;
        /**
         * 如果模式选的是user，则需要提供用户信息
         * <p> 示例值：
         */
        private UserSimpleInfo[] userList;
        /**
         * 如果模式选的是role，则需要提供角色信息，角色目前只支持一个角色
         * <p> 示例值：
         */
        private RoleApiNameSimpleInfo[] roleList;

        /**
         * 生效范围模式
         * <p> 示例值：
         *
         * @param userScopeMode
         * @return
         */
        public Builder userScopeMode(String userScopeMode) {
            this.userScopeMode = userScopeMode;
            return this;
        }

        /**
         * 生效范围模式
         * <p> 示例值：
         *
         * @param userScopeMode {@link com.lark.oapi.service.apaas.v1.enums.UserScopeV2UserScopeModeEnum}
         * @return
         */
        public Builder userScopeMode(com.lark.oapi.service.apaas.v1.enums.UserScopeV2UserScopeModeEnum userScopeMode) {
            this.userScopeMode = userScopeMode.getValue();
            return this;
        }


        /**
         * 如果模式选的是user，则需要提供用户信息
         * <p> 示例值：
         *
         * @param userList
         * @return
         */
        public Builder userList(UserSimpleInfo[] userList) {
            this.userList = userList;
            return this;
        }


        /**
         * 如果模式选的是role，则需要提供角色信息，角色目前只支持一个角色
         * <p> 示例值：
         *
         * @param roleList
         * @return
         */
        public Builder roleList(RoleApiNameSimpleInfo[] roleList) {
            this.roleList = roleList;
            return this;
        }


        public UserScopeV2 build() {
            return new UserScopeV2(this);
        }
    }
}
