// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.attendance.v1.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.attendance.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class NormalLeaveBalance {
    /**
     * 假期授予记录ID
     * <p> 示例值：7476427589584551938
     */
    @SerializedName("balance_id")
    private String balanceId;
    /**
     * 用户ID
     * <p> 示例值：
     */
    @SerializedName("user_id")
    private String userId;
    /**
     * 假期ID
     * <p> 示例值：7476427589584551938
     */
    @SerializedName("leave_type_id")
    private String leaveTypeId;
    /**
     * 剩余余额
     * <p> 示例值：1.54
     */
    @SerializedName("quota")
    private String quota;
    /**
     * 授予额度
     * <p> 示例值：1.66
     */
    @SerializedName("grant_quota")
    private String grantQuota;
    /**
     * 使用额度
     * <p> 示例值：0.12
     */
    @SerializedName("used_quota")
    private String usedQuota;
    /**
     * 单位
     * <p> 示例值：day
     */
    @SerializedName("unit")
    private String unit;
    /**
     * 子类型
     * <p> 示例值：normal
     */
    @SerializedName("sub_type")
    private String subType;
    /**
     * 有效期结束时间
     * <p> 示例值：1757330769
     */
    @SerializedName("expire_time")
    private Integer expireTime;
    /**
     * 有效期开始时间
     * <p> 示例值：1757330769
     */
    @SerializedName("effective_time")
    private Integer effectiveTime;
    /**
     * 来源
     * <p> 示例值：system
     */
    @SerializedName("grant_source")
    private String grantSource;
    /**
     * 状态
     * <p> 示例值：active
     */
    @SerializedName("status")
    private String status;
    /**
     * 备注
     * <p> 示例值：补发假期
     */
    @SerializedName("desc")
    private String desc;
    /**
     * 逐日发放数量
     * <p> 示例值：1.66
     */
    @SerializedName("plan_target_quota")
    private String planTargetQuota;
    /**
     * 逐日发放结束时间
     * <p> 示例值：1757330769
     */
    @SerializedName("plan_end_time")
    private Integer planEndTime;
    /**
     * 是否逐日发放
     * <p> 示例值：true
     */
    @SerializedName("grant_daily")
    private Boolean grantDaily;

    // builder 开始
    public NormalLeaveBalance() {
    }

    public NormalLeaveBalance(Builder builder) {
        /**
         * 假期授予记录ID
         * <p> 示例值：7476427589584551938
         */
        this.balanceId = builder.balanceId;
        /**
         * 用户ID
         * <p> 示例值：
         */
        this.userId = builder.userId;
        /**
         * 假期ID
         * <p> 示例值：7476427589584551938
         */
        this.leaveTypeId = builder.leaveTypeId;
        /**
         * 剩余余额
         * <p> 示例值：1.54
         */
        this.quota = builder.quota;
        /**
         * 授予额度
         * <p> 示例值：1.66
         */
        this.grantQuota = builder.grantQuota;
        /**
         * 使用额度
         * <p> 示例值：0.12
         */
        this.usedQuota = builder.usedQuota;
        /**
         * 单位
         * <p> 示例值：day
         */
        this.unit = builder.unit;
        /**
         * 子类型
         * <p> 示例值：normal
         */
        this.subType = builder.subType;
        /**
         * 有效期结束时间
         * <p> 示例值：1757330769
         */
        this.expireTime = builder.expireTime;
        /**
         * 有效期开始时间
         * <p> 示例值：1757330769
         */
        this.effectiveTime = builder.effectiveTime;
        /**
         * 来源
         * <p> 示例值：system
         */
        this.grantSource = builder.grantSource;
        /**
         * 状态
         * <p> 示例值：active
         */
        this.status = builder.status;
        /**
         * 备注
         * <p> 示例值：补发假期
         */
        this.desc = builder.desc;
        /**
         * 逐日发放数量
         * <p> 示例值：1.66
         */
        this.planTargetQuota = builder.planTargetQuota;
        /**
         * 逐日发放结束时间
         * <p> 示例值：1757330769
         */
        this.planEndTime = builder.planEndTime;
        /**
         * 是否逐日发放
         * <p> 示例值：true
         */
        this.grantDaily = builder.grantDaily;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getBalanceId() {
        return this.balanceId;
    }

    public void setBalanceId(String balanceId) {
        this.balanceId = balanceId;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getLeaveTypeId() {
        return this.leaveTypeId;
    }

    public void setLeaveTypeId(String leaveTypeId) {
        this.leaveTypeId = leaveTypeId;
    }

    public String getQuota() {
        return this.quota;
    }

    public void setQuota(String quota) {
        this.quota = quota;
    }

    public String getGrantQuota() {
        return this.grantQuota;
    }

    public void setGrantQuota(String grantQuota) {
        this.grantQuota = grantQuota;
    }

    public String getUsedQuota() {
        return this.usedQuota;
    }

    public void setUsedQuota(String usedQuota) {
        this.usedQuota = usedQuota;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public String getSubType() {
        return this.subType;
    }

    public void setSubType(String subType) {
        this.subType = subType;
    }

    public Integer getExpireTime() {
        return this.expireTime;
    }

    public void setExpireTime(Integer expireTime) {
        this.expireTime = expireTime;
    }

    public Integer getEffectiveTime() {
        return this.effectiveTime;
    }

    public void setEffectiveTime(Integer effectiveTime) {
        this.effectiveTime = effectiveTime;
    }

    public String getGrantSource() {
        return this.grantSource;
    }

    public void setGrantSource(String grantSource) {
        this.grantSource = grantSource;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getPlanTargetQuota() {
        return this.planTargetQuota;
    }

    public void setPlanTargetQuota(String planTargetQuota) {
        this.planTargetQuota = planTargetQuota;
    }

    public Integer getPlanEndTime() {
        return this.planEndTime;
    }

    public void setPlanEndTime(Integer planEndTime) {
        this.planEndTime = planEndTime;
    }

    public Boolean getGrantDaily() {
        return this.grantDaily;
    }

    public void setGrantDaily(Boolean grantDaily) {
        this.grantDaily = grantDaily;
    }

    public static class Builder {
        /**
         * 假期授予记录ID
         * <p> 示例值：7476427589584551938
         */
        private String balanceId;
        /**
         * 用户ID
         * <p> 示例值：
         */
        private String userId;
        /**
         * 假期ID
         * <p> 示例值：7476427589584551938
         */
        private String leaveTypeId;
        /**
         * 剩余余额
         * <p> 示例值：1.54
         */
        private String quota;
        /**
         * 授予额度
         * <p> 示例值：1.66
         */
        private String grantQuota;
        /**
         * 使用额度
         * <p> 示例值：0.12
         */
        private String usedQuota;
        /**
         * 单位
         * <p> 示例值：day
         */
        private String unit;
        /**
         * 子类型
         * <p> 示例值：normal
         */
        private String subType;
        /**
         * 有效期结束时间
         * <p> 示例值：1757330769
         */
        private Integer expireTime;
        /**
         * 有效期开始时间
         * <p> 示例值：1757330769
         */
        private Integer effectiveTime;
        /**
         * 来源
         * <p> 示例值：system
         */
        private String grantSource;
        /**
         * 状态
         * <p> 示例值：active
         */
        private String status;
        /**
         * 备注
         * <p> 示例值：补发假期
         */
        private String desc;
        /**
         * 逐日发放数量
         * <p> 示例值：1.66
         */
        private String planTargetQuota;
        /**
         * 逐日发放结束时间
         * <p> 示例值：1757330769
         */
        private Integer planEndTime;
        /**
         * 是否逐日发放
         * <p> 示例值：true
         */
        private Boolean grantDaily;

        /**
         * 假期授予记录ID
         * <p> 示例值：7476427589584551938
         *
         * @param balanceId
         * @return
         */
        public Builder balanceId(String balanceId) {
            this.balanceId = balanceId;
            return this;
        }


        /**
         * 用户ID
         * <p> 示例值：
         *
         * @param userId
         * @return
         */
        public Builder userId(String userId) {
            this.userId = userId;
            return this;
        }


        /**
         * 假期ID
         * <p> 示例值：7476427589584551938
         *
         * @param leaveTypeId
         * @return
         */
        public Builder leaveTypeId(String leaveTypeId) {
            this.leaveTypeId = leaveTypeId;
            return this;
        }


        /**
         * 剩余余额
         * <p> 示例值：1.54
         *
         * @param quota
         * @return
         */
        public Builder quota(String quota) {
            this.quota = quota;
            return this;
        }


        /**
         * 授予额度
         * <p> 示例值：1.66
         *
         * @param grantQuota
         * @return
         */
        public Builder grantQuota(String grantQuota) {
            this.grantQuota = grantQuota;
            return this;
        }


        /**
         * 使用额度
         * <p> 示例值：0.12
         *
         * @param usedQuota
         * @return
         */
        public Builder usedQuota(String usedQuota) {
            this.usedQuota = usedQuota;
            return this;
        }


        /**
         * 单位
         * <p> 示例值：day
         *
         * @param unit
         * @return
         */
        public Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        /**
         * 单位
         * <p> 示例值：day
         *
         * @param unit {@link com.lark.oapi.service.attendance.v1.enums.NormalLeaveBalanceLeaveBalanceUnitEnum}
         * @return
         */
        public Builder unit(com.lark.oapi.service.attendance.v1.enums.NormalLeaveBalanceLeaveBalanceUnitEnum unit) {
            this.unit = unit.getValue();
            return this;
        }


        /**
         * 子类型
         * <p> 示例值：normal
         *
         * @param subType
         * @return
         */
        public Builder subType(String subType) {
            this.subType = subType;
            return this;
        }

        /**
         * 子类型
         * <p> 示例值：normal
         *
         * @param subType {@link com.lark.oapi.service.attendance.v1.enums.NormalLeaveBalanceLeaveSubTypeEnum}
         * @return
         */
        public Builder subType(com.lark.oapi.service.attendance.v1.enums.NormalLeaveBalanceLeaveSubTypeEnum subType) {
            this.subType = subType.getValue();
            return this;
        }


        /**
         * 有效期结束时间
         * <p> 示例值：1757330769
         *
         * @param expireTime
         * @return
         */
        public Builder expireTime(Integer expireTime) {
            this.expireTime = expireTime;
            return this;
        }


        /**
         * 有效期开始时间
         * <p> 示例值：1757330769
         *
         * @param effectiveTime
         * @return
         */
        public Builder effectiveTime(Integer effectiveTime) {
            this.effectiveTime = effectiveTime;
            return this;
        }


        /**
         * 来源
         * <p> 示例值：system
         *
         * @param grantSource
         * @return
         */
        public Builder grantSource(String grantSource) {
            this.grantSource = grantSource;
            return this;
        }

        /**
         * 来源
         * <p> 示例值：system
         *
         * @param grantSource {@link com.lark.oapi.service.attendance.v1.enums.NormalLeaveBalanceGrantSourceEnum}
         * @return
         */
        public Builder grantSource(com.lark.oapi.service.attendance.v1.enums.NormalLeaveBalanceGrantSourceEnum grantSource) {
            this.grantSource = grantSource.getValue();
            return this;
        }


        /**
         * 状态
         * <p> 示例值：active
         *
         * @param status
         * @return
         */
        public Builder status(String status) {
            this.status = status;
            return this;
        }

        /**
         * 状态
         * <p> 示例值：active
         *
         * @param status {@link com.lark.oapi.service.attendance.v1.enums.NormalLeaveBalanceGrantStatusEnum}
         * @return
         */
        public Builder status(com.lark.oapi.service.attendance.v1.enums.NormalLeaveBalanceGrantStatusEnum status) {
            this.status = status.getValue();
            return this;
        }


        /**
         * 备注
         * <p> 示例值：补发假期
         *
         * @param desc
         * @return
         */
        public Builder desc(String desc) {
            this.desc = desc;
            return this;
        }


        /**
         * 逐日发放数量
         * <p> 示例值：1.66
         *
         * @param planTargetQuota
         * @return
         */
        public Builder planTargetQuota(String planTargetQuota) {
            this.planTargetQuota = planTargetQuota;
            return this;
        }


        /**
         * 逐日发放结束时间
         * <p> 示例值：1757330769
         *
         * @param planEndTime
         * @return
         */
        public Builder planEndTime(Integer planEndTime) {
            this.planEndTime = planEndTime;
            return this;
        }


        /**
         * 是否逐日发放
         * <p> 示例值：true
         *
         * @param grantDaily
         * @return
         */
        public Builder grantDaily(Boolean grantDaily) {
            this.grantDaily = grantDaily;
            return this;
        }


        public NormalLeaveBalance build() {
            return new NormalLeaveBalance(this);
        }
    }
}
