// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.attendance.v1.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.attendance.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class NormalLeaveUserAccount {
    /**
     * 用户ID
     * <p> 示例值：
     */
    @SerializedName("user_id")
    private String userId;
    /**
     * 假期ID
     * <p> 示例值：7476427589584551938
     */
    @SerializedName("leave_type_id")
    private String leaveTypeId;
    /**
     * 数量(保留两位小数)
     * <p> 示例值：1.53
     */
    @SerializedName("quota")
    private String quota;
    /**
     * 单位
     * <p> 示例值：day
     */
    @SerializedName("unit")
    private String unit;
    /**
     * 子类型账户
     * <p> 示例值：
     */
    @SerializedName("sub_type_accounts")
    private UserSubTypeAccount[] subTypeAccounts;
    /**
     * 假期余额详情
     * <p> 示例值：
     */
    @SerializedName("balances")
    private NormalLeaveBalance[] balances;

    // builder 开始
    public NormalLeaveUserAccount() {
    }

    public NormalLeaveUserAccount(Builder builder) {
        /**
         * 用户ID
         * <p> 示例值：
         */
        this.userId = builder.userId;
        /**
         * 假期ID
         * <p> 示例值：7476427589584551938
         */
        this.leaveTypeId = builder.leaveTypeId;
        /**
         * 数量(保留两位小数)
         * <p> 示例值：1.53
         */
        this.quota = builder.quota;
        /**
         * 单位
         * <p> 示例值：day
         */
        this.unit = builder.unit;
        /**
         * 子类型账户
         * <p> 示例值：
         */
        this.subTypeAccounts = builder.subTypeAccounts;
        /**
         * 假期余额详情
         * <p> 示例值：
         */
        this.balances = builder.balances;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getLeaveTypeId() {
        return this.leaveTypeId;
    }

    public void setLeaveTypeId(String leaveTypeId) {
        this.leaveTypeId = leaveTypeId;
    }

    public String getQuota() {
        return this.quota;
    }

    public void setQuota(String quota) {
        this.quota = quota;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public UserSubTypeAccount[] getSubTypeAccounts() {
        return this.subTypeAccounts;
    }

    public void setSubTypeAccounts(UserSubTypeAccount[] subTypeAccounts) {
        this.subTypeAccounts = subTypeAccounts;
    }

    public NormalLeaveBalance[] getBalances() {
        return this.balances;
    }

    public void setBalances(NormalLeaveBalance[] balances) {
        this.balances = balances;
    }

    public static class Builder {
        /**
         * 用户ID
         * <p> 示例值：
         */
        private String userId;
        /**
         * 假期ID
         * <p> 示例值：7476427589584551938
         */
        private String leaveTypeId;
        /**
         * 数量(保留两位小数)
         * <p> 示例值：1.53
         */
        private String quota;
        /**
         * 单位
         * <p> 示例值：day
         */
        private String unit;
        /**
         * 子类型账户
         * <p> 示例值：
         */
        private UserSubTypeAccount[] subTypeAccounts;
        /**
         * 假期余额详情
         * <p> 示例值：
         */
        private NormalLeaveBalance[] balances;

        /**
         * 用户ID
         * <p> 示例值：
         *
         * @param userId
         * @return
         */
        public Builder userId(String userId) {
            this.userId = userId;
            return this;
        }


        /**
         * 假期ID
         * <p> 示例值：7476427589584551938
         *
         * @param leaveTypeId
         * @return
         */
        public Builder leaveTypeId(String leaveTypeId) {
            this.leaveTypeId = leaveTypeId;
            return this;
        }


        /**
         * 数量(保留两位小数)
         * <p> 示例值：1.53
         *
         * @param quota
         * @return
         */
        public Builder quota(String quota) {
            this.quota = quota;
            return this;
        }


        /**
         * 单位
         * <p> 示例值：day
         *
         * @param unit
         * @return
         */
        public Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        /**
         * 单位
         * <p> 示例值：day
         *
         * @param unit {@link com.lark.oapi.service.attendance.v1.enums.NormalLeaveUserAccountLeaveBalanceUnitEnum}
         * @return
         */
        public Builder unit(com.lark.oapi.service.attendance.v1.enums.NormalLeaveUserAccountLeaveBalanceUnitEnum unit) {
            this.unit = unit.getValue();
            return this;
        }


        /**
         * 子类型账户
         * <p> 示例值：
         *
         * @param subTypeAccounts
         * @return
         */
        public Builder subTypeAccounts(UserSubTypeAccount[] subTypeAccounts) {
            this.subTypeAccounts = subTypeAccounts;
            return this;
        }


        /**
         * 假期余额详情
         * <p> 示例值：
         *
         * @param balances
         * @return
         */
        public Builder balances(NormalLeaveBalance[] balances) {
            this.balances = balances;
            return this;
        }


        public NormalLeaveUserAccount build() {
            return new NormalLeaveUserAccount(this);
        }
    }
}
