// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.attendance.v1.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.attendance.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class OutTime {
    /**
     * 时间，时间格式为yyyy-MM-dd HH:mm
     * <p> 示例值：2025-01-01 09:00
     */
    @SerializedName("datetime")
    private String datetime;
    /**
     * 外出半天类型，枚举值：morning，afternoon，当外出时间单位为half_day时生效
     * <p> 示例值：morning
     */
    @SerializedName("day_type")
    private String dayType;

    // builder 开始
    public OutTime() {
    }

    public OutTime(Builder builder) {
        /**
         * 时间，时间格式为yyyy-MM-dd HH:mm
         * <p> 示例值：2025-01-01 09:00
         */
        this.datetime = builder.datetime;
        /**
         * 外出半天类型，枚举值：morning，afternoon，当外出时间单位为half_day时生效
         * <p> 示例值：morning
         */
        this.dayType = builder.dayType;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getDatetime() {
        return this.datetime;
    }

    public void setDatetime(String datetime) {
        this.datetime = datetime;
    }

    public String getDayType() {
        return this.dayType;
    }

    public void setDayType(String dayType) {
        this.dayType = dayType;
    }

    public static class Builder {
        /**
         * 时间，时间格式为yyyy-MM-dd HH:mm
         * <p> 示例值：2025-01-01 09:00
         */
        private String datetime;
        /**
         * 外出半天类型，枚举值：morning，afternoon，当外出时间单位为half_day时生效
         * <p> 示例值：morning
         */
        private String dayType;

        /**
         * 时间，时间格式为yyyy-MM-dd HH:mm
         * <p> 示例值：2025-01-01 09:00
         *
         * @param datetime
         * @return
         */
        public Builder datetime(String datetime) {
            this.datetime = datetime;
            return this;
        }


        /**
         * 外出半天类型，枚举值：morning，afternoon，当外出时间单位为half_day时生效
         * <p> 示例值：morning
         *
         * @param dayType
         * @return
         */
        public Builder dayType(String dayType) {
            this.dayType = dayType;
            return this;
        }

        /**
         * 外出半天类型，枚举值：morning，afternoon，当外出时间单位为half_day时生效
         * <p> 示例值：morning
         *
         * @param dayType {@link com.lark.oapi.service.attendance.v1.enums.OutTimeDayTypeEnum}
         * @return
         */
        public Builder dayType(com.lark.oapi.service.attendance.v1.enums.OutTimeDayTypeEnum dayType) {
            this.dayType = dayType.getValue();
            return this;
        }


        public OutTime build() {
            return new OutTime(this);
        }
    }
}
