// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.board.v1.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.board.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class RichTextElement {
    /**
     * 元素类别
     * <p> 示例值：
     */
    @SerializedName("element_type")
    private Integer elementType;
    /**
     * 文本类别信息
     * <p> 示例值：
     */
    @SerializedName("text_element")
    private RichTextElementText textElement;
    /**
     * 超链接类别信息
     * <p> 示例值：
     */
    @SerializedName("link_element")
    private RichTextElementLink linkElement;
    /**
     * @用户类别信息 <p> 示例值：
     */
    @SerializedName("mention_user_element")
    private RichTextElementMentionUser mentionUserElement;
    /**
     * 文档类别信息
     * <p> 示例值：
     */
    @SerializedName("mention_doc_element")
    private RichTextElementMentionDoc mentionDocElement;

    // builder 开始
    public RichTextElement() {
    }

    public RichTextElement(Builder builder) {
        /**
         * 元素类别
         * <p> 示例值：
         */
        this.elementType = builder.elementType;
        /**
         * 文本类别信息
         * <p> 示例值：
         */
        this.textElement = builder.textElement;
        /**
         * 超链接类别信息
         * <p> 示例值：
         */
        this.linkElement = builder.linkElement;
        /**
         * @用户类别信息
         * <p> 示例值：
         */
        this.mentionUserElement = builder.mentionUserElement;
        /**
         * 文档类别信息
         * <p> 示例值：
         */
        this.mentionDocElement = builder.mentionDocElement;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Integer getElementType() {
        return this.elementType;
    }

    public void setElementType(Integer elementType) {
        this.elementType = elementType;
    }

    public RichTextElementText getTextElement() {
        return this.textElement;
    }

    public void setTextElement(RichTextElementText textElement) {
        this.textElement = textElement;
    }

    public RichTextElementLink getLinkElement() {
        return this.linkElement;
    }

    public void setLinkElement(RichTextElementLink linkElement) {
        this.linkElement = linkElement;
    }

    public RichTextElementMentionUser getMentionUserElement() {
        return this.mentionUserElement;
    }

    public void setMentionUserElement(RichTextElementMentionUser mentionUserElement) {
        this.mentionUserElement = mentionUserElement;
    }

    public RichTextElementMentionDoc getMentionDocElement() {
        return this.mentionDocElement;
    }

    public void setMentionDocElement(RichTextElementMentionDoc mentionDocElement) {
        this.mentionDocElement = mentionDocElement;
    }

    public static class Builder {
        /**
         * 元素类别
         * <p> 示例值：
         */
        private Integer elementType;
        /**
         * 文本类别信息
         * <p> 示例值：
         */
        private RichTextElementText textElement;
        /**
         * 超链接类别信息
         * <p> 示例值：
         */
        private RichTextElementLink linkElement;
        /**
         * @用户类别信息 <p> 示例值：
         */
        private RichTextElementMentionUser mentionUserElement;
        /**
         * 文档类别信息
         * <p> 示例值：
         */
        private RichTextElementMentionDoc mentionDocElement;

        /**
         * 元素类别
         * <p> 示例值：
         *
         * @param elementType
         * @return
         */
        public Builder elementType(Integer elementType) {
            this.elementType = elementType;
            return this;
        }

        /**
         * 元素类别
         * <p> 示例值：
         *
         * @param elementType {@link com.lark.oapi.service.board.v1.enums.RichTextElementRichTextElementTypeEnum}
         * @return
         */
        public Builder elementType(com.lark.oapi.service.board.v1.enums.RichTextElementRichTextElementTypeEnum elementType) {
            this.elementType = elementType.getValue();
            return this;
        }


        /**
         * 文本类别信息
         * <p> 示例值：
         *
         * @param textElement
         * @return
         */
        public Builder textElement(RichTextElementText textElement) {
            this.textElement = textElement;
            return this;
        }


        /**
         * 超链接类别信息
         * <p> 示例值：
         *
         * @param linkElement
         * @return
         */
        public Builder linkElement(RichTextElementLink linkElement) {
            this.linkElement = linkElement;
            return this;
        }


        /**
         * @param mentionUserElement
         * @return
         * @用户类别信息 <p> 示例值：
         */
        public Builder mentionUserElement(RichTextElementMentionUser mentionUserElement) {
            this.mentionUserElement = mentionUserElement;
            return this;
        }


        /**
         * 文档类别信息
         * <p> 示例值：
         *
         * @param mentionDocElement
         * @return
         */
        public Builder mentionDocElement(RichTextElementMentionDoc mentionDocElement) {
            this.mentionDocElement = mentionDocElement;
            return this;
        }


        public RichTextElement build() {
            return new RichTextElement(this);
        }
    }
}
