// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.docs.v1.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.docs.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class GetContentReq {
    /**
     * 文档唯一标识
     * <p> 示例值：B4EPdAYx8oi8HRxgPQQbM15UcBf
     */
    @Query
    @SerializedName("doc_token")
    private String docToken;
    /**
     * 文档类型
     * <p> 示例值：docx
     */
    @Query
    @SerializedName("doc_type")
    private String docType;
    /**
     * 内容类型
     * <p> 示例值：markdown
     */
    @Query
    @SerializedName("content_type")
    private String contentType;
    /**
     * 语言
     * <p> 示例值：zh
     */
    @Query
    @SerializedName("lang")
    private String lang;

    // builder 开始
    public GetContentReq() {
    }

    public GetContentReq(Builder builder) {
        /**
         * 文档唯一标识
         * <p> 示例值：B4EPdAYx8oi8HRxgPQQbM15UcBf
         */
        this.docToken = builder.docToken;
        /**
         * 文档类型
         * <p> 示例值：docx
         */
        this.docType = builder.docType;
        /**
         * 内容类型
         * <p> 示例值：markdown
         */
        this.contentType = builder.contentType;
        /**
         * 语言
         * <p> 示例值：zh
         */
        this.lang = builder.lang;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getDocToken() {
        return this.docToken;
    }

    public void setDocToken(String docToken) {
        this.docToken = docToken;
    }

    public String getDocType() {
        return this.docType;
    }

    public void setDocType(String docType) {
        this.docType = docType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getLang() {
        return this.lang;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public static class Builder {
        private String docToken; // 文档唯一标识
        private String docType; // 文档类型
        private String contentType; // 内容类型
        private String lang; // 语言

        /**
         * 文档唯一标识
         * <p> 示例值：B4EPdAYx8oi8HRxgPQQbM15UcBf
         *
         * @param docToken
         * @return
         */
        public Builder docToken(String docToken) {
            this.docToken = docToken;
            return this;
        }


        /**
         * 文档类型
         * <p> 示例值：docx
         *
         * @param docType
         * @return
         */
        public Builder docType(String docType) {
            this.docType = docType;
            return this;
        }

        /**
         * 文档类型
         * <p> 示例值：docx
         *
         * @param docType {@link com.lark.oapi.service.docs.v1.enums.GetContentDocTypeEnum}
         * @return
         */
        public Builder docType(com.lark.oapi.service.docs.v1.enums.GetContentDocTypeEnum docType) {
            this.docType = docType.getValue();
            return this;
        }


        /**
         * 内容类型
         * <p> 示例值：markdown
         *
         * @param contentType
         * @return
         */
        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        /**
         * 内容类型
         * <p> 示例值：markdown
         *
         * @param contentType {@link com.lark.oapi.service.docs.v1.enums.GetContentContentTypeEnum}
         * @return
         */
        public Builder contentType(com.lark.oapi.service.docs.v1.enums.GetContentContentTypeEnum contentType) {
            this.contentType = contentType.getValue();
            return this;
        }


        /**
         * 语言
         * <p> 示例值：zh
         *
         * @param lang
         * @return
         */
        public Builder lang(String lang) {
            this.lang = lang;
            return this;
        }

        /**
         * 语言
         * <p> 示例值：zh
         *
         * @param lang {@link com.lark.oapi.service.docs.v1.enums.GetContentLangEnum}
         * @return
         */
        public Builder lang(com.lark.oapi.service.docs.v1.enums.GetContentLangEnum lang) {
            this.lang = lang.getValue();
            return this;
        }


        public GetContentReq build() {
            return new GetContentReq(this);
        }
    }
}
