// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.drive.v2.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.drive.v2.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class BizInfo {
    /**
     * 业务名称，ccm代表云文档容量，vc代表视频会议，mail代表邮箱，im代表聊天文件
     * <p> 示例值：ccm
     */
    @SerializedName("name")
    private String name;
    /**
     * 业务已经使用的容量，单位byte，最大可能为int64，需要自己转换为数字
     * <p> 示例值：345567888
     */
    @SerializedName("used")
    private String used;
    /**
     * 额度，单位byte，最大可能为int64，需要自己转换为数字
     * <p> 示例值：23455666
     */
    @SerializedName("quota")
    private String quota;
    /**
     * 是否没设置容量限制
     * <p> 示例值：true
     */
    @SerializedName("unlimited")
    private Boolean unlimited;

    // builder 开始
    public BizInfo() {
    }

    public BizInfo(Builder builder) {
        /**
         * 业务名称，ccm代表云文档容量，vc代表视频会议，mail代表邮箱，im代表聊天文件
         * <p> 示例值：ccm
         */
        this.name = builder.name;
        /**
         * 业务已经使用的容量，单位byte，最大可能为int64，需要自己转换为数字
         * <p> 示例值：345567888
         */
        this.used = builder.used;
        /**
         * 额度，单位byte，最大可能为int64，需要自己转换为数字
         * <p> 示例值：23455666
         */
        this.quota = builder.quota;
        /**
         * 是否没设置容量限制
         * <p> 示例值：true
         */
        this.unlimited = builder.unlimited;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUsed() {
        return this.used;
    }

    public void setUsed(String used) {
        this.used = used;
    }

    public String getQuota() {
        return this.quota;
    }

    public void setQuota(String quota) {
        this.quota = quota;
    }

    public Boolean getUnlimited() {
        return this.unlimited;
    }

    public void setUnlimited(Boolean unlimited) {
        this.unlimited = unlimited;
    }

    public static class Builder {
        /**
         * 业务名称，ccm代表云文档容量，vc代表视频会议，mail代表邮箱，im代表聊天文件
         * <p> 示例值：ccm
         */
        private String name;
        /**
         * 业务已经使用的容量，单位byte，最大可能为int64，需要自己转换为数字
         * <p> 示例值：345567888
         */
        private String used;
        /**
         * 额度，单位byte，最大可能为int64，需要自己转换为数字
         * <p> 示例值：23455666
         */
        private String quota;
        /**
         * 是否没设置容量限制
         * <p> 示例值：true
         */
        private Boolean unlimited;

        /**
         * 业务名称，ccm代表云文档容量，vc代表视频会议，mail代表邮箱，im代表聊天文件
         * <p> 示例值：ccm
         *
         * @param name
         * @return
         */
        public Builder name(String name) {
            this.name = name;
            return this;
        }


        /**
         * 业务已经使用的容量，单位byte，最大可能为int64，需要自己转换为数字
         * <p> 示例值：345567888
         *
         * @param used
         * @return
         */
        public Builder used(String used) {
            this.used = used;
            return this;
        }


        /**
         * 额度，单位byte，最大可能为int64，需要自己转换为数字
         * <p> 示例值：23455666
         *
         * @param quota
         * @return
         */
        public Builder quota(String quota) {
            this.quota = quota;
            return this;
        }


        /**
         * 是否没设置容量限制
         * <p> 示例值：true
         *
         * @param unlimited
         * @return
         */
        public Builder unlimited(Boolean unlimited) {
            this.unlimited = unlimited;
            return this;
        }


        public BizInfo build() {
            return new BizInfo(this);
        }
    }
}
