// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.drive.v2.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.drive.v2.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class Condition {
    /**
     * 条件类型
     * <p> 示例值：范围
     */
    @SerializedName("range")
    private Integer range;
    /**
     * 操作符
     * <p> 示例值：resign
     */
    @SerializedName("operator")
    private String operator;
    /**
     * 参数，具体取值与range有关，见range描述
     * <p> 示例值：
     */
    @SerializedName("params")
    private String[] params;

    // builder 开始
    public Condition() {
    }

    public Condition(Builder builder) {
        /**
         * 条件类型
         * <p> 示例值：范围
         */
        this.range = builder.range;
        /**
         * 操作符
         * <p> 示例值：resign
         */
        this.operator = builder.operator;
        /**
         * 参数，具体取值与range有关，见range描述
         * <p> 示例值：
         */
        this.params = builder.params;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Integer getRange() {
        return this.range;
    }

    public void setRange(Integer range) {
        this.range = range;
    }

    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public String[] getParams() {
        return this.params;
    }

    public void setParams(String[] params) {
        this.params = params;
    }

    public static class Builder {
        /**
         * 条件类型
         * <p> 示例值：范围
         */
        private Integer range;
        /**
         * 操作符
         * <p> 示例值：resign
         */
        private String operator;
        /**
         * 参数，具体取值与range有关，见range描述
         * <p> 示例值：
         */
        private String[] params;

        /**
         * 条件类型
         * <p> 示例值：范围
         *
         * @param range
         * @return
         */
        public Builder range(Integer range) {
            this.range = range;
            return this;
        }

        /**
         * 条件类型
         * <p> 示例值：范围
         *
         * @param range {@link com.lark.oapi.service.drive.v2.enums.ConditionRangeEnum}
         * @return
         */
        public Builder range(com.lark.oapi.service.drive.v2.enums.ConditionRangeEnum range) {
            this.range = range.getValue();
            return this;
        }


        /**
         * 操作符
         * <p> 示例值：resign
         *
         * @param operator
         * @return
         */
        public Builder operator(String operator) {
            this.operator = operator;
            return this;
        }


        /**
         * 参数，具体取值与range有关，见range描述
         * <p> 示例值：
         *
         * @param params
         * @return
         */
        public Builder params(String[] params) {
            this.params = params;
            return this;
        }


        public Condition build() {
            return new Condition(this);
        }
    }
}
